<?php

$this->start_controls_section(
	'team_one_section',
	[
		'label'     => __( 'Content', 'konta' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style!' => 'layout_five']
	]
);

$repeater = new \Elementor\Repeater();

$repeater->add_control(
	'name', [
		'label' 		=> __( 'Name', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'default' 		=> __( 'Safe Cleaning Supplies' , 'konta' ),
		'rows' 			=> 2,
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'profile_link',
	[
		'label' 		=> esc_html__( 'Profile Link', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
		'default' 		=> [
			'url' 			=> '#',
			'is_external' 	=> false,
			'nofollow' 		=> false,
		],
	]
);
$repeater->add_control(
	'designation', [
		'label' 		=> __( 'Designation', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXT,
		'default' 		=> __( 'Customer' , 'konta' ),
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'team_image',
	[
		'label' 		=> esc_html__( 'Speaker Image', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
		'default' 		=> [
			'url' =>  \Elementor\Utils::get_placeholder_image_src(),
		],
	]
);
$repeater->add_control(
	'fb_link',
	[
		'label' 		=> esc_html__( 'Facebook Link', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
		'default' 		=> [
			'url' 			=> '#',
			'is_external' 	=> false,
			'nofollow' 		=> false,
		],
	]
);
$repeater->add_control(
	'twitter_link',
	[
		'label' 		=> esc_html__( 'Twitter Link', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
		'default' 		=> [
			'url' 			=> '#',
			'is_external' 	=> false,
			'nofollow' 		=> false,
		],
	]
);
$repeater->add_control(
	'linkedin_link',
	[
		'label' 		=> esc_html__( 'Linkedin Link', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
	]
);

$this->add_control(
	'team_members',
	[
		'label' 		=> __( 'Team Member', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'title' 		=> __( 'Your Name', 'konta' ),
			],
		],
		'title_field' 	=> '{{{ name }}}',
	]
);

$this->end_controls_section();