<?php

$this->start_controls_section(
	'2_testimonials_section',
	[
		'label'     => __( 'Content', 'konta' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style' => ['layout_two' ,'layout_three', 'layout_four' ,'layout_five']]
	]
);

$repeater = new \Elementor\Repeater();

$repeater->add_control(
	'name', [
		'label' 		=> __( 'Name', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'default' 		=> __( 'Safe Cleaning Supplies' , 'konta' ),
		'rows' 			=> 2,
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'designation', [
		'label' 		=> __( 'Designation', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXT,
		'default' 		=> __( 'Customer' , 'konta' ),
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'feedback', [
		'label' 		=> __( 'Feedback', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'default' 		=> __( 'Customer' , 'konta' ),
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'client_rating',
	[
		'label' 	=> __( 'Client Rating', 'konta' ),
		'type' 		=> \Elementor\Controls_Manager::SELECT,
		'default' 	=> '5',
		'options' 	=> [
			'one'  		=> __( 'One Star', 'konta' ),
			'two' 		=> __( 'Two Star', 'konta' ),
			'three' 	=> __( 'Three Star', 'konta' ),
			'four' 		=> __( 'Four Star', 'konta' ),
			'five' 	 	=> __( 'Five Star', 'konta' ),
		],
	]
);
$repeater->add_control(
	'client_image',
	[
		'label' 		=> esc_html__( 'Client Image', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
		'default' 		=> [
			'url' =>  \Elementor\Utils::get_placeholder_image_src(),
		],
	]
);

$this->add_control(
	'2_testimonials',
	[
		'label' 		=> __( 'Testimonials', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'name' 		=> __( 'Your Name', 'konta' ),
			],
		],
		'title_field' 	=> '{{{ name }}}',
	]
);

$this->end_controls_section();