<?php
$this->start_controls_section(
	'2_wcu',
	[
		'label'     => __( 'Content', 'konta' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style' => ['layout_two']]
	]
);
$this->add_control(
	'2_title', [
		'label' 		=> __( 'Title', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'rows' 			=> 2,
		'default' 		=> __( ' WHY CHOOSE US' , 'konta' ),
		'label_block' 	=> true,
	]
);
$this->add_control(
	'2_subtitle', [
		'label' 		=> __( 'Subtitle', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'rows' 			=> 2,
		'default' 		=> __( 'High Quality Construction Projects & Innovate Design!' , 'konta' ),
		'label_block' 	=> true,
	]
);
$this->add_control(
	'2_desc', [
		'label' 		=> __( 'Descriptions', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::WYSIWYG,
		'default' 		=> __( 'High Quality Construction Projects & Innovate Design!' , 'konta' ),
		'label_block' 	=> true,
	]
);

$repeater = new \Elementor\Repeater();

$repeater->add_control(
	'title',
	[
		'label'     => __( 'Title', 'konta' ),
        'type'      => \Elementor\Controls_Manager::TEXTAREA,
        'rows' 		=> 2,
	]
);
$repeater->add_control(
	'number',
	[
		'label'     => __( 'Number', 'konta' ),
        'type'      => \Elementor\Controls_Manager::TEXTAREA,
        'rows' 		=> 2,
	]
);
$this->add_control(
	'1_skill',
	[
		'label' 		=> __( 'Skills', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'title' 		=> __( 'title', 'konta' ),
			],
		],
	]
);
$this->add_control(
	'2_exp', [
		'label' 		=> __( 'Experience', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::WYSIWYG,
		'default' 		=> __( 'High Quality Construction Projects & Innovate Design!' , 'konta' ),
		'label_block' 	=> true,
	]
);


$this->add_control(
    '2_banner_img',
    [
        'label'     => __( 'Thumb Image', 'konta' ),
        'type'      => \Elementor\Controls_Manager::MEDIA,
        'dynamic' 		=> [
			'active' 		=> true,
		],
		'default' 		=> [
			'url' 		=>  \Elementor\Utils::get_placeholder_image_src(),
		],
    ]
);



$this->end_controls_section();