<?php

$this->start_controls_section(
	'wp_one_section',
	[
		'label'     => __( 'Content', 'konta' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style' => ['layout_one']]
	]
);
$this->add_control(
	'shape',
	[
		'label' 		=> esc_html__( 'Shape Image', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
		'default' 		=> [
			'url' =>  \Elementor\Utils::get_placeholder_image_src(),
		],
	]
);

$repeater = new \Elementor\Repeater();

$repeater->add_control(
	'title', [
		'label' 		=> __( 'Title', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'default' 		=> __( 'Safe Cleaning Supplies' , 'konta' ),
		'rows' 			=> 2,
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'content', [
		'label' 		=> __( 'Content', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXT,
		'default' 		=> __( 'Customer' , 'konta' ),
		'label_block' 	=> true,
	]
);
$repeater->add_control(
	'icon_image',
	[
		'label' 		=> esc_html__( 'Icon Image', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
		'default' 		=> [
			'url' =>  \Elementor\Utils::get_placeholder_image_src(),
		],
	]
);
$this->add_control(
	'process',
	[
		'label' 		=> __( 'Process', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'title' 		=> __( 'Your Name', 'konta' ),
			],
		],
		'title_field' 	=> '{{{ title }}}',
	]
);

$this->end_controls_section();