<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget .
 *
 */
class Konta_Header2 extends Widget_Base {

	public function get_name() {
		return 'drillerheader';
	}
	public function get_title() {
		return __( 'Header v2', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta_header_elements' ];
	}
	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' 	=> __( 'Header', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'header_style',
			[
				'label' 		=> __( 'Header Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'konta' ),
					'2' 		=> __( 'Style Two', 'konta' ),
					'3' 		=> __( 'Style Three', 'konta' ),
				],
			]
		);

		// Topbar
		$this->add_control(
			'show_header_topbar',
			[
				'label' 		=> __( 'Show Topbar ?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'header_style' => '3'
				]
			]
		);

		$this->add_control(
			'topbar_phone_icon',
			[
				'label' 		=> __( 'Phone Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
					'show_header_topbar' => 'yes'
				]
			]
		);			
		$this->add_control(
			'topbar_phone',
			[
				'label' 		=> __( 'Phone', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
					'show_header_topbar' => 'yes'
				]
			]
		);		
		$this->add_control(
			'topbar_email_icon',
			[
				'label' 		=> __( 'Email Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
					'show_header_topbar' => 'yes'
				]
			]
		);		
		$this->add_control(
			'topbar_email',
			[
				'label' 		=> __( 'Email', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
					'show_header_topbar' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_language_switcher',
			[
				'label' 		=> __( 'Show Language ?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'header_style' => '3',
					'show_header_topbar' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_social_icon',
			[
				'label' 		=> __( 'Show Social ?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'header_style' => '3',
					'show_header_topbar' => 'yes'
				]
			]
		);

	
		//----------------------------maim menu control----------------------------//

		$this->add_control(

			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$menus = $this->konta_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'konta_menu_select',
				[
					'label'     	=> __( 'Select Konta Menu', 'konta' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'konta' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'konta' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'konta' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}
		
		$this->add_control(
			'show_search_btn',
			[
				'label' 		=> __( 'Show Search ?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);


        $this->end_controls_section();
       
        //-----------------------------------General Styling-------------------------------------//
         $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'General Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'header_style' => '3'
				]
			]
        );

        $this->add_control(
			'general_bg_color',
			[
				'label' 		=> __( 'Topbar Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-top' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );        
        $this->add_control(
			'general_shape_color',
			[
				'label' 		=> __( 'Topbar Shape Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-top:before' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );       
        $this->add_control(
			'general_menu_color',
			[
				'label' 		=> __( 'Menu Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .menu-area' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'general_logo_color',
			[
				'label' 		=> __( 'Logo Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .logo-style3:before' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );


          $this->end_controls_section();

            //-----------------------------------General Styling-------------------------------------//
         $this->start_controls_section(
			'content_styling',
			[
				'label'     => __( 'Content Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'header_style' => '3'
				]
			]
        );

        $this->add_control(
			'content_icon_color',
			[
				'label' 		=> __( 'Content Icon Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-links li > i' => 'color: {{VALUE}} !important;',
                ]
			]
        );        
        $this->add_control(
			'content_color',
			[
				'label' 		=> __( 'Content Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-top a' => 'color: {{VALUE}} !important;',
                ]
			]
        );         
        $this->add_control(
			'content_hover_color',
			[
				'label' 		=> __( 'Content Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-top a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );    
        $this->add_control(
			'social_color',
			[
				'label' 		=> __( 'Social Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-links .header-social i' => 'color: {{VALUE}} !important;',
                ]
			]
        );         
        $this->add_control(
			'social_hover_color',
			[
				'label' 		=> __( 'Social Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-social i:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );    

          $this->end_controls_section();


        //-----------------------------------Menubar Styling-------------------------------------//
        $this->start_controls_section(
			'menubar_styling',
			[
				'label'     => __( 'Menubar Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'top_level_menu_bg_color',
			[
				'label' 		=> __( 'Menu Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_txt_color',
			[
				'label' 			=> __( 'Menu Text Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul > li > a' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_hover_color',
			[
				'label' 			=> __( 'Menu Hover Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu > ul > li > a:hover' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_hover_txt_color',
			[
				'label' 			=> __( 'Menu Hover Text Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul > li > a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_hover_bottom_color',
			[
				'label' 			=> __( 'Menu Bottom Hover Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .menu-style1 > ul > li > a::before' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'top_level_menu_typography',
				'label' 		=> __( 'Menu Typography', 'konta' ),
                'selector' 		=> '{{WRAPPER}} .main-menu ul > li > a',
			]
		);

        $this->add_responsive_control(
			'top_level_menu_margin',
			[
				'label' 		=> __( 'Menu Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

        $this->add_responsive_control(
			'top_level_menu_padding',
			[
				'label' 		=> __( 'Menu Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_control(
			'top_level_menu_height',
			[
				'label' 		=> __( 'Height', 'konta' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max'	=> 500
					],
				],
				'selectors' => [
					'{{WRAPPER}} .main-menu ul > li > a' => 'height: {{SIZE}}{{UNIT}} !important;line-height: {{SIZE}}{{UNIT}} !important;'
                ]
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:after,{{WRAPPER}} .th-btn:before' => '--white-color:{{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Border Hover', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn:hover',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'konta' ),
				'selector' => '{{WRAPPER}} .th-btn',
			]
		);
        $this->end_controls_section();
    }

    public function konta_menu_select(){
	    $konta_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'konta' );
	    foreach( $konta_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $konta_avaiable_menu   = $this->konta_menu_select();
		if( ! $konta_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['konta_menu_select'],
			'menu_class' 	=> 'konta-menu',
			'container' 	=> '',
		];

	    echo '<!--=========================Mobile Menu========================= -->';
	    echo konta_mobile_menu();

	    echo konta_search_box();

	    $show_header_topbar      = $settings['show_header_topbar']; 
        $show_social_icon        = $settings['show_social_icon']; 
        $topbar_phone_icon      = $settings['topbar_phone_icon'];          
        $topbar_phone      = $settings['topbar_phone'];          
        $topbar_email_icon       = $settings['topbar_email_icon']; 
        $topbar_email       = $settings['topbar_email']; 
        $show_language_switcher       = $settings['show_language_switcher']; 

        $phone      = $topbar_phone;
        $email      = $topbar_email;

        $replace        = array(' ','-',' - ');
        $with           = array('','','');

        $phoneurl       = str_replace( $replace, $with, $phone );
        $eamilurl       = str_replace( $replace, $with, $email );

        if( class_exists( 'ReduxFramework' ) ){ 
			if(konta_opt('konta_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}


	    if($settings['header_style'] == 1) {
	    	$headr_class = 'header-layout9';
	    	$logo_class = 'header-logo';
	    	$search_class = 'simple-icon';
	    }elseif($settings['header_style'] == 2){
	    	$headr_class = 'header-layout2';
	    	$logo_class = 'logo-style2';
	    	$search_class = 'simple-icon';
	    }else{
	    	$headr_class = 'header-layout5';
	    	$logo_class = 'logo-style3';
	    	$search_class = 'icon-btn';
	    }

	    	echo '<div class="th-header '.esc_attr($headr_class).'">';
		    	if( $show_header_topbar ){
		    		echo '<div class="header-top">';
		                echo '<div class="container">';
		                    echo '<div class="header-top-inner">';
		                        echo '<div class="row justify-content-center justify-content-md-between align-items-center gy-2">';
		                            echo '<div class="col-auto d-none d-md-block">';
		                                echo '<div class="header-links d-none d-md-block">';
		                                    echo '<ul>';
		                                        if(!empty($phone )){
		                                            echo '<li>'.wp_kses_post($topbar_phone_icon).'<a href="'.esc_attr( 'tel:'.$phoneurl ).'">'.esc_html($phone).'</a></li>';
		                                        }
		                                        if(!empty($email )){
		                                            echo '<li>'.wp_kses_post($topbar_email_icon).'<a href="'.esc_attr( 'mailto:'.$email ).'">'.esc_html($email).'</a></li>';
		                                        }
		                                    echo '</ul>';
		                                echo '</div>';
		                            echo '</div>';
		                            echo '<div class="col-auto">';
		                                echo '<div class="header-links">';
		                                    echo '<ul>';
		                                        if($show_language_switcher){
		                                            echo '<li>';
		                                                echo '<i class="fal fa-globe"></i><a class="dropdown-toggle" href="'.esc_url('#').'" role="button" id="dropdownMenuLink6" data-bs-toggle="dropdown" aria-expanded="false">'.esc_html__('Language', 'konta').'</a>';
		                                                echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink6">';
		                                                    echo ' <li>';
		                                                        echo do_shortcode('[gtranslate]');
		                                                    echo ' </li>';
		                                                echo '</ul>';
		                                            echo '</li>';
		                                        }
		                                        if( $show_social_icon ){
		                                            echo '<li>';
		                                                echo '<div class="header-social">';
		                                                     konta_social_icon();
		                                                echo '</div>';
		                                            echo '</li>';
		                                        }
		                                    echo '</ul>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        }

		        echo '<div class="sticky-wrapper">';
		            echo '<div class="sticky-active">';
		                echo '<!-- Main Menu Area -->';
		                echo '<div class="menu-area">';
		                    echo '<div class="container">';
		                        echo '<div class="row align-items-center justify-content-between">';
		                            if( ! empty( $settings['logo_image']['url'] ) ){
							            echo '<div class="col-auto">';
								            echo '<div class="'.esc_attr($logo_class).'">';
								                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
													echo konta_img_tag( array(
							                        	'url' => esc_url( $settings['logo_image']['url'] ),
							                        ) );
												echo '</a>';

								            echo '</div>';
							            echo '</div>';
							        }
		                            echo '<div class="col-auto">';
		                                echo '<div class="row align-items-center">';
		                                    echo '<div class="col-auto">';
		                                        echo '<nav class="main-menu '.esc_attr($menu_icon).' d-none d-lg-inline-block">';
		                                            if( ! empty( $settings['konta_menu_select'] ) ){
														wp_nav_menu( $args );
													} 
		                                        echo '</nav>';
		                                        echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                                    echo '</div>';
		                                    echo '<div class="col-auto d-none d-xl-block">';
		                                        echo '<div class="header-button">';

		                                        	if( $settings['show_search_btn'] == 'yes' ){
			                                            echo '<button type="button" class="'.esc_attr($search_class).' searchBoxToggler"><i class="far fa-search"></i></button>';
			                                        }
			                                        if(!empty($settings['button_text'])){
			                                           echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style3 ml-25">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                                        }
		                                        echo '</div>';
		                                    echo '</div>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';		
	}
}