<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget .
 *
 */
class Konta_Header_3 extends Widget_Base {

	public function get_name() {
		return 'drillerheader2';
	}
	public function get_title() {
		return __( 'Header New Version', 'konta' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'konta_header_elements' ];
	}
	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' 	=> __( 'Header 2', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'header_style',
			[
				'label' 		=> __( 'Header Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'konta' ),
					'2' 		=> __( 'Style Two', 'konta' ),
					'3' 		=> __( 'Style Three', 'konta' ),
				],
			]
		);


		$this->add_control(
			'show_header_top',
			[
				'label' 		=> __( 'Show Header Top?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 'header_style' => '1' ],
			]
		);

		$this->add_control(
			'slogan',
			[
				'label' 		=> __( 'Slogan', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Welcome to Konta Online Learning & Education Platform', 'konta' ),
				'condition'		=> [ 'show_header_top' => [ 'yes' ], 'header_style' => '1' ],
			]
		);
		$this->add_control(
			'show_language_switcher',
			[
				'label' 		=> __( 'Show Language ?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'header_style' => ['1'],
					'show_header_top' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_menu_top',
			[
				'label' 		=> __( 'Show Menu Top?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
			$this->add_control(
			'slogan_2',
			[
				'label' 		=> __( 'Slogan', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Welcome to Konta Online Learning & Education Platform', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style' => '3' ,
				]
			]
		);
		$this->add_control(
			'contact_phone_icon',
			[
				'label' 		=> __( 'Phone Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '<i class="fas fa-phone"></i>', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
				],
			]
		);			
		$this->add_control(
			'contact_phone',
			[
				'label' 		=> __( 'Contact Phone', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '256 214 203 215', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'contact_email_icon',
			[
				'label' 		=> __( 'Email Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '<i class="far fa-envelope"></i>', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
				],
			]
		);	

		$this->add_control(
			'contact_email',
			[
				'label' 		=> __( 'Contact Email', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'info@konta.com', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'office_hours_icon',
			[
				'label' 		=> __( 'Office Hours Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '<i class="icon-btn fas fa-clock"></i>', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style' => '1' ,
				]
			]
		);
		$this->add_control(
			'office_hours', [
				'label' 		=> __( 'Office Hours', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style' => '1' ],
			]
        );
        $this->add_control(
			'location_icon',
			[
				'label' 		=> __( 'Location Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( '<i class="far fa-location-dot"></i>', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style' => ['2', '3'] ,
				]
			]
		);
        $this->add_control(
			'location', [
				'label' 		=> __( 'Location', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style' => ['2', '3'] ,
				],
			]
        );

        $this->add_control(
			'show_language',
			[
				'label' 		=> __( 'Show Language?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 'show_menu_top' => [ 'yes' ],
									  'header_style' => '2' ],
			]
		);        
		$this->add_control(
			'show_social',
			[
				'label' 		=> __( 'Show Social?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator' => 'before',
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style!' =>  ['4', '5', '7']
				],
			]
		);
		
        $this->add_control(
			'social_text',
			[
				'label' 		=> __( 'Social Text', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Follow Us:', 'konta' ),
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'header_style' => ['2'] ,
					'show_social' => [ 'yes' ],
				]
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' 	=> __( 'Social Icon', 'konta' ),
				'type' 		=> Controls_Manager::ICONS,
				'default' 	=> [
					'value' 	=> 'fab fa-facebook-f',
					'library' 	=> 'solid',
				],
			]
		);

		$repeater->add_control(
			'icon_link',
			[
				'label' 		=> __( 'Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(

			'social_icon_list',
			[
				'label' 		=> __( 'Social Icon', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'social_icon' => __( 'Add Social Icon','konta' ),
					],
				],
				'title_field' 	=> '{{{ social_icon.value }}}',
				'condition'		=> [ 
					'show_menu_top' => [ 'yes' ],
					'show_social' => [ 'yes' ],
					'header_style!' =>  ['4', '5', '7']
				],
			]
		);
		

		//---------------------------Main Menu Controls---------------------------//

		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(

			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$menus = $this->konta_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'konta_menu_select',
				[
					'label'     	=> __( 'Select Konta Menu', 'konta' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'konta' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'konta' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'konta' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}	

		$this->add_control(
			'show_top_btn',
			[
				'label' 		=> __( 'Show Button?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 
					'header_style!' => '3' ,
				],
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'condition'		=> [ 
					'header_style!' => '3' ,
					'show_top_btn' => 'yes' 
				],
			]
		);
		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'		=> [ 
					'header_style!' => '3' ,
					'show_top_btn' => 'yes' 
				],
				'separator' => 'after'
			]
		);
		
		$this->add_control(
			'show_search_btn',
			[
				'label' 		=> __( 'Show Search Button?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);		
		$this->add_control(
			'show_offcanvas_btn',
			[
				'label' 		=> __( 'Show Offcanvas Button?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();

         //-----------------------------------General Styling-------------------------------------//
        $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'General Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'top_bar_bg',
			[
				'label' 		=> __( 'Top Bar Background', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-top' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );        
        $this->add_control(
			'middle_bg',
			[
				'label' 		=> __( 'Middle Background', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .menu-top' => 'background-color: {{VALUE}} !important;',
                ],
                'condition'		=> [ 
					'header_style' => '1' ,
				],
			]
        );
        $this->add_control(
			'menu_bg',
			[
				'label' 		=> __( 'Menu Background', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .menu-area' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );        
        $this->add_control(
			'logo_bg',
			[
				'label' 		=> __( 'Logo Background', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .logo-shape' => 'background-color: {{VALUE}} !important;',
                ],
                'condition'		=> [ 
					'header_style' => ['1', '2'] ,
				],
			]
        );       
         $this->add_control(
			'logo_bg2',
			[
				'label' 		=> __( 'Logo Background', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .header-logo' => 'background-color: {{VALUE}} !important;',
                ],
                'condition'		=> [ 
					'header_style' => '3' ,
				],
			]
        );

        $this->end_controls_section();

        //-----------------------------------Menubar Styling-------------------------------------//
        $this->start_controls_section(
			'menubar_styling',
			[
				'label'     => __( 'Menubar Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'top_level_menu_bg_color',
			[
				'label' 		=> __( 'Menu Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_txt_color',
			[
				'label' 			=> __( 'Menu Text Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul > li > a' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_hover_color',
			[
				'label' 			=> __( 'Menu Hover Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu > ul > li > a:hover' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_hover_txt_color',
			[
				'label' 			=> __( 'Menu Hover Text Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul > li > a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'top_level_menu_hover_bottom_color',
			[
				'label' 			=> __( 'Menu Bottom Hover Color', 'konta' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .menu-style1 > ul > li > a::before' => 'background-color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'top_level_menu_typography',
				'label' 		=> __( 'Menu Typography', 'konta' ),
                'selector' 		=> '{{WRAPPER}} .main-menu ul > li > a',
			]
		);

        $this->add_responsive_control(
			'top_level_menu_margin',
			[
				'label' 		=> __( 'Menu Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

        $this->add_responsive_control(
			'top_level_menu_padding',
			[
				'label' 		=> __( 'Menu Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_control(
			'top_level_menu_height',
			[
				'label' 		=> __( 'Height', 'konta' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max'	=> 500
					],
				],
				'selectors' => [
					'{{WRAPPER}} .main-menu ul > li > a' => 'height: {{SIZE}}{{UNIT}} !important;line-height: {{SIZE}}{{UNIT}} !important;'
                ]
			]
		);
		$this->end_controls_section();
    }

    public function konta_menu_select(){
	    $konta_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'konta' );
	    foreach( $konta_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $konta_avaiable_menu   = $this->konta_menu_select();
		if( ! $konta_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['konta_menu_select'],
			'menu_class' 	=> 'konta-menu',
			'container' 	=> '',
		];

		if( class_exists( 'ReduxFramework' ) ){ 
			if(konta_opt('konta_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}



		echo konta_mobile_menu();
        echo konta_search_box();
        echo konta_header_offcanvas();

        
         if($settings['header_style'] == 1 ){
	        echo '<div class="th-header header-layout10">';
		        echo '<div class="top-area" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/header_bg_1.png">';
		        	if( $settings['show_header_top'] == 'yes' ){
			            echo '<div class="header-top">';
			                echo '<div class="container">';
			                    echo '<div class="row justify-content-center justify-content-md-between align-items-center">';
			                        echo '<div class="col-auto">';
				                        if( ! empty( $settings['slogan'] ) ){
					                        echo '<p class="header-notice">'.esc_html($settings['slogan']).'</p>';
					                    }
			                        echo '</div>';
			                        echo '<div class="col-auto d-none d-md-block">';
			                            echo '<div class="header-links">';
			                                echo '<ul>';
						  							if($settings['show_language_switcher']){
		                                            echo '<li>';
		                                                echo '<i class="fal fa-globe"></i><a class="dropdown-toggle" href="'.esc_url('#').'" role="button" id="dropdownMenuLink6" data-bs-toggle="dropdown" aria-expanded="false">'.esc_html__('Language', 'konta').'</a>';
		                                                echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink6">';
		                                                    echo ' <li>';
		                                                        echo do_shortcode('[gtranslate]');
		                                                    echo ' </li>';
		                                                echo '</ul>';
		                                            echo '</li>';
		                                        	}
			                                echo '</ul>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }
			        if( $settings['show_menu_top'] == 'yes' ){
			        	$email    	= $settings['contact_email'];
		                $phone    	= $settings['contact_phone'];

		                $email          = is_email( $email );

		                $replace        = array(' ','-',' - ');
		                $with           = array('','','');

		                $emailurl       = str_replace( $replace, $with, $email );
		                $phoneurl       = str_replace( $replace, $with, $phone );
			            echo '<div class="menu-top">';
			                echo '<div class="container">';
			                    echo '<div class="row align-items-center justify-content-center justify-content-sm-between">';
			                        echo '<div class="col-auto d-none d-sm-block">';
			                        ?>
			                        	<?php if(!empty($phone)): ?>
			                        	<a class="header-link" href="<?php echo esc_attr( 'tell:'.$phoneurl ); ?>">
			                        		<?php if(!empty($settings['contact_phone_icon'])): ?>
			                        		<span class="icon-btn"><?php echo wp_kses_post($settings['contact_phone_icon']); ?></span>
			                        		<?php endif; ?>
			                        		<?php echo esc_html($phone); ?>
			                        	</a>
			                        	<?php endif ?>

			                        	<?php if(!empty($email)): ?>
			                            <a class="header-link d-none d-lg-inline-block" href="<?php echo esc_attr( 'mailto:'.$emailurl ); ?>">
			                            	<?php if(!empty($settings['contact_email_icon'])): ?>
			                        		<span class="icon-btn"><?php echo wp_kses_post($settings['contact_email_icon']); ?></span>
			                        		<?php endif; ?>
			                            	<?php echo esc_html($email); ?>
			                        	</a>
			                        	<?php endif ?>

			                        	<?php if(!empty($settings['office_hours'])): ?>
			                            <span class="header-link d-none d-xl-inline-block">
			                            	<?php if(!empty($settings['office_hours_icon'])): ?>
			                        		<span class="icon-btn"><?php echo wp_kses_post($settings['office_hours_icon']); ?></span>
			                        		<?php endif; ?>
			                            	<?php echo esc_html($settings['office_hours']); ?>
			                            </span>
			                            <?php endif ?>
			                        <?php

			                       echo ' </div>';
			                       echo ' <div class="col-auto">';
			                            echo '<div class="th-social">';
			                                foreach( $settings['social_icon_list'] as $social_icon ){
					                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
					                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

					                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

					                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

					                          	echo '</a> ';
					                      	}
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }
		        echo '</div>';
		        echo '<div class="sticky-wrapper">';
		            echo '<div class="sticky-active">';
		                echo '<div class="menu-area">';
		                    echo '<div class="container">';
		                        echo '<div class="row align-items-center justify-content-between">';
		                        	if( ! empty( $settings['logo_image']['url'] ) ){
			                        	echo '<div class="col-auto">';
								            echo '<div class="header-logo">';
								                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
													echo konta_img_tag( array(
							                        	'url' => esc_url( $settings['logo_image']['url'] ),
							                        ) );
												echo '</a>';
								            echo '</div>';
							            echo '</div>';
							        }
		                            echo '<div class="col-auto">';
		                                echo '<div class="row align-items-center justify-content-between">';
		                                    echo '<div class="col-auto">';
		                                        echo '<nav class=" '.esc_attr($menu_icon).' main-menu d-none d-lg-inline-block">';
		                                           if( ! empty( $settings['konta_menu_select'] ) ){
														wp_nav_menu( $args );
													}  
		                                        echo '</nav>';
		                                        echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                                    echo '</div>';
		                                    echo '<div class="col-auto d-none d-xl-block">';
		                                        echo '<div class="header-button">';
		                                        	if( $settings['show_search_btn'] == 'yes' ){		
											        	echo '<button type="button" class="icon-btn style2 searchBoxToggler"><i class="far fa-search"></i></button>';
			                                        }

			                                        if( ! empty( $settings['button_text'] ) ){
						                                echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style6 d-none d-xxl-inline-block">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                            }

						                            if( ! empty( $settings['show_offcanvas_btn'] ) ){
							                            echo '<a href="#" class="icon-btn style2 sideMenuToggler"><i class="fas fa-grid"></i></a>';
							                        }
		                                        echo '</div>';
		                                    echo '</div>';
		                                echo '</div>';
		                           echo ' </div>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="logo-shape" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/pattern_bg_1.png"></div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['header_style'] == 2 ){
			echo '<div class="th-header header-layout11">';
				if( $settings['show_menu_top'] == 'yes' ){
		        	$email    	= $settings['contact_email'];
	                $phone    	= $settings['contact_phone'];

	                $email          = is_email( $email );

	                $replace        = array(' ','-',' - ');
	                $with           = array('','','');

	                $emailurl       = str_replace( $replace, $with, $email );
	                $phoneurl       = str_replace( $replace, $with, $phone );
			        echo '<div class="header-top">';
			            echo '<div class="container">';
			                echo '<div class="row justify-content-center justify-content-md-between align-items-center gy-2">';
			                    echo '<div class="col-auto d-none d-md-block">';
			                        echo '<div class="header-links">';
			                            echo '<ul>';
			                            	
				                            if(!empty($phone)){	
				                                echo '<li>'.wp_kses_post($settings['contact_phone_icon']).'<a href="'.esc_attr( 'tell:'.$phoneurl ).'">'.esc_html($phone).'</a></li>';
				                            }
				                            if(!empty($settings['location'])){	
				                                echo '<li class="d-none d-xl-inline-block">'.wp_kses_post($settings['location_icon']).''.esc_html($settings['location']).'</li>';
				                            }
			                                if(!empty($email)){	
				                                echo '<li>'.wp_kses_post($settings['contact_email_icon']).'<a href="'.esc_attr( 'mailto:'.$emailurl ).'">'.esc_html($email).'</a></li>';
				                            }
			                            echo '</ul>';
			                        echo '</div>';
			                    echo '</div>';
			                    echo '<div class="col-auto">';
			                        echo '<div class="header-links">';
			                            echo '<ul>';
			                            	if( class_exists( 'GTranslate' ) && $settings['show_language'] == 'yes' ){
				                               	echo ' <li class="d-none d-lg-inline-block">';
				                                    echo '<div class="dropdown-link">';
				                                        echo '<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">'.esc_html__( 'Language', 'konta' ).'</a>';
				                                        echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">';
				                                           echo do_shortcode('[gtranslate]'); 
				                                        echo '</ul>';
				                                    echo '</div>';
				                                echo '</li>';
				                            }
			                                echo '<li>';
			                                    echo '<div class="header-social">';
			                                        echo '<span class="social-title">'.esc_html($settings['social_text']).'</span>';
			                                        foreach( $settings['social_icon_list'] as $social_icon ){
							                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

							                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

							                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

							                          	echo '</a> ';
							                      	}
			                                    echo '</div>';
			                                echo '</li>';
			                            echo '</ul>';
			                       echo ' </div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			       echo ' </div>';
			   }
		       echo ' <div class="sticky-wrapper">';
		            echo '<div class="sticky-active">';
		                echo '<!-- Main Menu Area -->';
		                echo '<div class="menu-area" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/pattern_bg_2.png">';
		                   echo ' <div class="container">';
		                        echo '<div class="row align-items-center justify-content-between">';
		                        	if( ! empty( $settings['logo_image']['url'] ) ){
			                        	echo '<div class="col-auto">';
								            echo '<div class="header-logo">';
								                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
													echo konta_img_tag( array(
							                        	'url' => esc_url( $settings['logo_image']['url'] ),
							                        ) );
												echo '</a>';
								            echo '</div>';
							            echo '</div>';
							        }
		                            echo '<div class="col-auto">';
		                                echo '<div class="row align-items-center">';
		                                    echo '<div class="col-auto">';
		                                        echo '<nav class=" '.esc_attr($menu_icon).' main-menu d-none d-lg-inline-block">';
		                                            if( ! empty( $settings['konta_menu_select'] ) ){
														wp_nav_menu( $args );
													} 
		                                        echo '</nav>';
		                                        echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                                    echo '</div>';
		                                    echo '<div class="col-auto d-none d-xl-block">';
		                                        echo '<div class="header-button">';
		                                            if( $settings['show_search_btn'] == 'yes' ){		
											        	echo '<button type="button" class="simple-icon me-3 searchBoxToggler"><i class="far fa-search"></i></button>';
			                                        }
			                                        if( ! empty( $settings['button_text'] ) ){
		                                           		echo ' <a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style3">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
		                                           	}

		                                           	if( ! empty( $settings['show_offcanvas_btn'] ) ){
							                            echo '<a href="#" class="simple-icon style2 ms-3 sideMenuToggler"><i class="fas fa-grid"></i></a>';
							                        }
		                                           
		                                        echo '</div>';
		                                    echo '</div>';
		                                echo '</div>';
		                           echo ' </div>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="logo-shape"></div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		   echo ' </div>';
		}elseif($settings['header_style'] == 3 ){
			echo '<header class="th-header header-layout12">';
				if( $settings['show_menu_top'] == 'yes' ){
		        	$email    	= $settings['contact_email'];
	                $phone    	= $settings['contact_phone'];

	                $email          = is_email( $email );

	                $replace        = array(' ','-',' - ');
	                $with           = array('','','');

	                $emailurl       = str_replace( $replace, $with, $email );
	                $phoneurl       = str_replace( $replace, $with, $phone );
			        echo '<div class="header-top">';
			            echo '<div class="container">';
			                echo '<div class="row gx-0 justify-content-center justify-content-md-between align-items-center">';
			                    echo '<div class="col-auto">';
			                        echo '<div class="top-left">';
			                        	if( ! empty( $settings['slogan_2'] ) ){
					                        echo '<p class="header-notice">'.esc_html($settings['slogan_2']).'</p>';
					                    }
			                        echo '</div>';
			                    echo '</div>';
			                    echo '<div class="col-auto d-none d-md-block">';
			                        echo '<div class="top-right">';
			                            echo '<div class="row gx-0 align-items-center justify-content-between">';
			                                echo '<div class="col-auto">';
			                                    echo '<div class="header-links">';
			                                        echo '<ul>';
			                                        	if(!empty($phone)){	
							                                echo '<li class="d-none d-lg-inline-block">'.wp_kses_post($settings['contact_phone_icon']).'<a href="'.esc_attr( 'tell:'.$phoneurl ).'">'.esc_html($phone).'</a></li>';
							                            }
							                            if(!empty($settings['location'])){	
							                                echo '<li class="d-none d-xxl-inline-block">'.wp_kses_post($settings['location_icon']).''.esc_html($settings['location']).'</li>';
							                            }
						                                if(!empty($email)){	
							                                echo '<li>'.wp_kses_post($settings['contact_email_icon']).'<a href="'.esc_attr( 'mailto:'.$emailurl ).'">'.esc_html($email).'</a></li>';
							                            }
			                                        echo '</ul>';
			                                    echo '</div>';
			                                echo '</div>';
			                                echo '<div class="col-auto">';
			                                    echo '<div class="header-social">';
			                                       foreach( $settings['social_icon_list'] as $social_icon ){
							                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

							                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

							                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

							                          	echo '</a> ';
							                      	}
			                                        
			                                    echo '</div>';
			                               echo ' </div>';
			                            echo '</div>';
			                        echo '</div>';
			                   echo ' </div>';
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    }
		        echo '<div class="sticky-wrapper">';
		            echo '<div class="sticky-active">';
		               echo ' <div class="container">';
		                   echo ' <div class="row gx-0 justify-content-between">';
		                   		if( ! empty( $settings['logo_image']['url'] ) ){
		                        	echo '<div class="col-auto">';
							            echo '<div class="header-logo">';
							                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
												echo konta_img_tag( array(
						                        	'url' => esc_url( $settings['logo_image']['url'] ),
						                        ) );
											echo '</a>';
							            echo '</div>';
						            echo '</div>';
						        }
		                        echo '<div class="col-auto">';
		                            echo '<div class="menu-area">';
		                               echo ' <div class="row gx-0 align-items-center justify-content-between">';
		                                   echo ' <div class="col-auto">';
		                                       echo ' <nav class=" '.esc_attr($menu_icon).' main-menu d-none d-lg-inline-block">';
		                                            if( ! empty( $settings['konta_menu_select'] ) ){
														wp_nav_menu( $args );
													} 
		                                       echo ' </nav>';
		                                        echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                                    echo '</div>';
		                                    echo '<div class="col-auto d-none d-xxl-block">';
		                                        echo '<div class="header-button">';
		                                        	if( $settings['show_search_btn'] == 'yes' ){	
		                                           		echo '<button type="button" class="icon-btn style2 searchBoxToggler"><i class="far fa-search"></i></button>';
		                                           	}

		                                           	if( ! empty( $settings['show_offcanvas_btn'] ) ){
							                            echo '<a href="#" class="simple-icon style2 sideMenuToggler"><i class="fas fa-grid"></i></a>';
							                        }
		                                          
		                                       echo ' </div>';
		                                    echo '</div>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                   echo ' </div>';
		                echo '</div>';
		            echo '</div>';
		       echo ' </div>';
		   echo ' </div>';
		}

	}
}