<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Tab Builder Widget .
 *
 */
class Konta_Tab_Builder extends Widget_Base {

	public function get_name() {
		return 'kontatabbuilder';
	}

	public function get_title() {
		return __( 'Tab Builder', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	protected function register_controls() {

		// $settings = $this->get_settings_for_display();

		$this->start_controls_section(
			'tab_builder_section',
			[
				'label' 	=> __( 'Tab Builder', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Service Style', 'konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'layout_one',
				'options' 	=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
				],
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'tab_builder_text',
			[
				'label' 	=> __( 'Tab Title', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Ut fermentum massa justo', 'konta' )
			]
        );

		$repeater->add_control(
			'konta_tab_builder_option',
			[
				'label'     => __( 'Tab Name', 'konta' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->konta_tab_builder_choose_option(),
				'default'	=> ''
			]
		);

		$this->add_control(
			'tab_builder_repeater',
			[
				'label' 		=> __( 'Tab', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_builder_text'    => __( 'Cardiology', 'konta' ),
					],
					[
						'tab_builder_text'    => __( 'Gastroenterologist', 'konta' ),
					],
					[
						'tab_builder_text'    => __( 'Neurology', 'konta' ),
					],
				],
				'title_field' 	=> '{{{ tab_builder_text }}}',
			]
		);

        $this->end_controls_section();


    }

	public function konta_tab_builder_choose_option(){

		$konta_post_query = new WP_Query( array(
			'post_type'				=> 'konta_tab_builder',
			'posts_per_page'	    => -1,
		) );

		$konta_tab_builder_title = array();
		$konta_tab_builder_title[''] = __( 'Select a Tab','konta');

		while( $konta_post_query->have_posts() ) {
			$konta_post_query->the_post();
			$konta_tab_builder_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();

		return $konta_tab_builder_title;

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
	        echo '<div class="container">';
		        echo '<div class="row">';
		            echo '<div class="col-lg-3">';
		                echo '<div class="service-tab-menu nav">';
		                	$i = 0;
		                	foreach( $settings['tab_builder_repeater'] as $single_menu ){
		                		$i++;

			            		$title			= $single_menu['tab_builder_text'];
								$replace 		= array(' ',' - ');
								$with 			= array('-','-');
								$tabid 			= strtolower( str_replace( $replace, $with, $title ) );

								$active_class = ( $i == 1 ) ? 'active' : '';

			                    echo '<button class="tab-btn '.esc_attr( $active_class ).'" data-bs-toggle="tab" data-bs-target="#service-tab-'.$tabid.'">'.esc_html( $single_menu['tab_builder_text'] ).'</button>';
			                }
		                    
		                echo '</div>';
		            echo '</div>';
		            echo '<div class="col-lg-9">';
		                echo '<div class="service-slider1 tab-content">';

		                	$i = 0;
		                	foreach( $settings['tab_builder_repeater'] as $single_menu ){
		                		$i++;

			            		$title			= $single_menu['tab_builder_text'];
								$replace 		= array(' ',' - ');
								$with 			= array('-','-');
								$tabid 			= strtolower( str_replace( $replace, $with, $title ) );

								$active_class = ( $i == 1 ) ? 'show active' : '';

			                    echo '<div class="tab-pane fade '.esc_attr( $active_class ).'" id="service-tab-'.$tabid.'" role="tabpanel">';
			                        $elementor = \Elementor\Plugin::instance();
			                        if( ! empty( $single_menu['konta_tab_builder_option'] ) ){
			                            echo $elementor->frontend->get_builder_content_for_display( $single_menu['konta_tab_builder_option'] );
			                        }
			                    echo '</div>';
			                }
		                    
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
	        echo '</div>';
	    }
	}
}