<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Konta_Blog_Post extends Widget_Base {

	public function get_name() {
		return 'kontablogpost';
	}

	public function get_title() {
		return __( 'Konta Blog Post', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __( 'Blog Post', 'konta' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Brand Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
					'layout_five'  		=> __( 'Style Five', 'konta' ),
				]
			]
		);
        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'konta' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default'  	=> __( '4', 'konta' )
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '5', 'konta' ),
			]
		);
		$this->add_control(
			'con_count',
			[
				'label' 	=> __( 'Excerpt Length', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '16', 'konta' ),
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'konta' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','konta'),
                    'DESC'   	=> __('DESC','konta'),
                ],
                'default'  	=> 'DESC'
			]
        );

        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'konta' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'konta' ),
                    'author'    => __( 'Author', 'konta' ),
                    'title'    	=> __( 'Title', 'konta' ),
                    'date'    	=> __( 'Date', 'konta' ),
                    'rand'    	=> __( 'Random', 'konta' ),
                ],
                'default'  	=> 'ID'
			]
        );

        $this->add_control(
			'exclude_cats',
			[
				'label' 		=> __( 'Exclude Categories', 'konta' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->konta_get_categories(),
			]
        );

        $this->add_control(
			'exclude_tags',
			[
				'label' 		=> __( 'Exclude Tags', 'konta' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->konta_get_tags(),
			]
        );

        $this->add_control(
			'exclude_post_id',
			[
				'label'         => __( 'Exclude Post', 'konta' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
				'options'       => $this->konta_post_id(),
			]
        );
        $this->add_control(
			'read_more',
			[
				'label' 	=> __( 'Read More Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Read More', 'konta' ),
			]
        );
        $this->end_controls_section();




        /*-----------------------------------------meta styling------------------------------------*/

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta_hvr_color',
			[
				'label' 		=> __( 'Meta HoverColor', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'konta' ),
				'selector' 	=> '{{WRAPPER}} .blog-meta a',
			]
		);

		$this->add_control(
			'admin_color',
			[
				'label' 		=> __( 'Author Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-box .author-name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'author_typography',
				'label' 	=> __( 'Author Typography', 'konta' ),
				'selector' 	=> '{{WRAPPER}} .blog-box .author-name',
			]
		);
		$this->end_controls_section();

		/*-----------------------------------------title styling------------------------------------*/

        $this->start_controls_section(
			'blog_title_styling',
			[
				'label' 	=> __( 'Title Styling', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'blog_title_color',
			[
				'label' 		=> __( 'Title Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_control(
			'blog_title_hvr_color',
			[
				'label' 		=> __( 'Title Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a:hover'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'blog_title_typography',
		 		'label' 		=> esc_html__( 'Title Typography', 'konta' ),
		 		'selector' 		=> '{{WRAPPER}} .blog-title a',
		 	]
		);

        $this->add_responsive_control(
			'blog_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'blog_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

        //----------------------------------button styling----------------------------------//

        $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'btn_color',
			[
				'label' 		=> __( 'Button Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn'	=> 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .line-btn' => 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_control(
			'btn_hvr_color',
			[
				'label' 		=> __( 'Button Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .line-btn:hover'	=> 'color: {{VALUE}}!important;',
				],
			]
        );


        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'button_typography',
		 		'label' 		=> __( 'Typography', 'konta' ),
		 		'selector' 		=> '{{WRAPPER}} .vs-btn, {{WRAPPER}} .line-btn'
			]
		);

		$this->add_control(
			'btn_text_color',
			[
				'label' 		=> __( 'Text Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn'	=> 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .line-btn'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_control(
			'btn_text_hvr_color',
			[
				'label' 		=> __( 'Text Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn:hover'	=> 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .line-btn:hover'	=> 'color: {{VALUE}}!important;',
				],
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .line-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .line-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
        $this->end_controls_section();

		
    }

    public function konta_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'konta');
        }

        return $catarr;
    }

    public function konta_get_tags() {
        $cats = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'konta');
        }

        return $catarr;
    }

    // Get Specific Post
    public function konta_post_id(){
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        );

        $konta_post = new WP_Query( $args );

        $postarray = [];

        while( $konta_post->have_posts() ){
            $konta_post->the_post();
            $postarray[get_the_Id()] = get_the_title();
        }
        wp_reset_postdata();
        return $postarray;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $exclude_post = $settings['exclude_post_id'];

        if( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats']
            );
        } elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags']
            );
        }elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
            );
        } elseif( empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'post__not_in'          => $exclude_post
            );
        } else {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true
            );
        }


        $blogpost = new WP_Query( $args );

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="row slider-shadow th-carousel blog-slider-1" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">';
        		if( $blogpost->have_posts() ) { 
	           		while( $blogpost->have_posts() ) { $blogpost->the_post();
	           			$categories = get_the_category();
		                echo '<div class="col-md-6 col-xl-4">';
		                    echo '<div class="th-blog blog-single style2">';
		                    	if(has_post_thumbnail()){
			                        echo '<div class="blog-img">';
			                            the_post_thumbnail( 'konta_391x280' );
			                        echo '</div>';
			                    }
		                        echo '<div class="blog-content">';
		                            echo '<div class="blog-date"><span>'.esc_html( get_the_date( 'd' ) ).'</span> '.esc_html( get_the_date( 'M, Y' ) ).'</div>';
		                            echo '<div class="blog-meta">';
		                                echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fa-solid fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
		                                echo '<a href="'. esc_url( get_category_link( $categories[0]->term_id ) ) . '"><i class="fa-solid fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>';
		                            echo '</div>';
		                            if( get_the_title() ){
			                            echo '<h4 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
			                        }
			                        if(!empty($settings['read_more'])){
			                            echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style2">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
	            	}
	            	wp_reset_postdata();
	            }
            echo '</div>';
        }elseif( $settings['layout_style'] == 'layout_two' ){
        	echo '<div class="blog-grid-wrap">';
        		if( $blogpost->have_posts() ) { 
        			$i = 0;
	           		while( $blogpost->have_posts() ) { $blogpost->the_post();
		           		$categories = get_the_category();
		           		$i++;

		           		$thumb = $i == 1 ? 'konta_598x270' : 'konta_287x280';

			        	echo '<div class="blog-grid">';
			        		if(has_post_thumbnail()){
				                echo '<div class="blog-img">';
				                    the_post_thumbnail( $thumb );
				                    echo '<div class="blog-date"><span>'.esc_html( get_the_date( 'd' ) ).'</span> '.esc_html( get_the_date( 'M, Y' ) ).'</div>';
				                echo '</div>';
				            }
			                echo '<div class="blog-content">';
			                    echo '<div class="blog-meta">';
			                        echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fa-solid fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
			                        echo '<a href="'. esc_url( get_category_link( $categories[0]->term_id ) ) . '"><i class="fa-solid fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>';
			                    echo '</div>';
			                    if( get_the_title() ){
		                            echo '<h3 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
		                        }
			                    echo '<p class="blog-text">'.esc_html( wp_trim_words( get_the_content( ), $settings['con_count'], '' ) ).'</p>';
			                    if(!empty($settings['read_more'])){
				                    echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style2">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                }
			                echo '</div>';
			            echo '</div>';
	            	}
	            	wp_reset_postdata();
	            }
            echo '</div>';
        }elseif( $settings['layout_style'] == 'layout_three' ){
        	 echo '<div class="row th-carousel arrow-style7" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">';
                if( $blogpost->have_posts() ) { 
	           		while( $blogpost->have_posts() ) { $blogpost->the_post();
	           			$categories = get_the_category();
		                echo '<div class="col-md-6 col-xl-4">';
		                    echo '<div class="th-blog blog-single style4">';
		                        if(has_post_thumbnail()){
			                        echo '<div class="blog-img">';
			                            the_post_thumbnail( 'konta_391x280' );
			                        echo '</div>';
			                    }
		                        echo '<div class="blog-content">';
		                            echo '<div class="blog-meta">';
		                                echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-solid fa-calendar-days"></i>'.esc_html( get_the_date( 'd m, y' ) ).'</a>';
		                                echo '<a href="'. esc_url( get_category_link( $categories[0]->term_id ) ) . '"><i class="fa-solid fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>';
		                            echo '</div>';
		                            if( get_the_title() ){
			                            echo '<h4 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
			                        }
		                            if(!empty($settings['read_more'])){
					                    echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style2">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right ms-1"></i></a>';
					                }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
		            wp_reset_postdata();
		        }
            echo '</div>';
        }elseif( $settings['layout_style'] == 'layout_four' ){
        	echo '<div class="row th-carousel arrow-style8 arrow-wrap" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">';
        		if( $blogpost->have_posts() ) { 
	           		while( $blogpost->have_posts() ) { $blogpost->the_post();
		           		$categories = get_the_category();
	                
		                echo '<div class="col-md-6 col-xl-4">';
		                    echo '<div class="th-blog blog-single style5">';
		                    	if(has_post_thumbnail()){
			                        echo '<div class="blog-img">';
			                            the_post_thumbnail( 'konta_391x280' );
			                            echo '<div class="blog-date"><span>'.esc_html( get_the_date( 'd' ) ).'</span>'.esc_html( get_the_date( 'm, y' ) ).'</div>';
			                        echo '</div>';
			                    }
		                        echo '<div class="blog-content">';
		                            echo '<div class="blog-meta">';
		                                echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fa-solid fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
		                                echo '<a href="'. esc_url( get_category_link( $categories[0]->term_id ) ) . '"><i class="fa-solid fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>';
		                            echo '</div>';
		                            if( get_the_title() ){
			                            echo '<h4 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
			                        }
			                        if(!empty($settings['read_more'])){
			                            echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style2">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
		            wp_reset_postdata();
	            }
            echo '</div>';
        }else{
        	echo '<div class="row th-carousel arrow-wrap" data-slide-show="2" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">';

                if( $blogpost->have_posts() ) { 
	           		while( $blogpost->have_posts() ) { $blogpost->the_post();
		           		$categories = get_the_category();
		                echo '<div class="col-md-6 col-xl-4">';
		                    echo '<div class="th-blog blog-single style3">';
		                        if(has_post_thumbnail()){
			                        echo '<div class="blog-img">';
			                            the_post_thumbnail( 'konta_554x397' );
			                        echo '</div>';
			                    }
		                        echo '<div class="blog-content">';
		                            echo '<div class="blog-meta">';
		                                echo '<a class="blog-date" href="'.esc_url( get_permalink() ).'">'.esc_html( get_the_date( 'd M, Y' ) ).'</a>';
		                                echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fa-solid fa-user"></i>'.esc_html( ucwords( get_the_author() ) ).'</a>';
		                                echo '<a href="'. esc_url( get_category_link( $categories[0]->term_id ) ) . '"><i class="fa-solid fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>'; 
		                            echo '</div>';
		                            if( get_the_title() ){
			                            echo '<h4 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h4>';
			                        }
		                            if(!empty($settings['read_more'])){
			                            echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn style10">'.esc_html($settings['read_more']).' <i class="fas fa-arrow-right ms-2"></i></a>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
		            wp_reset_postdata();
		        }
            echo '</div>';
        }
	}
}