<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Utils;
/**
 *
 * Button With Author Widget .
 *
 */
class Konta_Button_Author extends Widget_Base {

	public function get_name() {
		return 'kontabuttonwithauthors';
	}

	public function get_title() {
		return __( 'Button + Author', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'button_section',
			[
				'label' 	=> __( 'Button', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
            'layout_style',
            [
                'label' => __('Select Layout', 'konta'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'konta'),
                ]
            ]
        );
        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Button Text', 'konta' )
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$this->add_control(
			'author_name',
			[
				'label' 	=> __( 'Author Name', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Ronald Richards', 'konta' )
			]
        );
        $this->add_control(
			'author_desig',
			[
				'label' 	=> __( 'Author Designation', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Founder CEO', 'konta' )
			]
        );
        $this->add_control(
			'image',
			[
				'label' 		=> __( 'Author Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		
        $this->end_controls_section();

       

       	$this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn', ['layout_one']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn', ['layout_one']);
					konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .th-btn', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn', ['layout_one']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn:hover', ['layout_one']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn:before, {{WRAPPER}} .th-btn:after', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button Hover', '{{WRAPPER}} .th-btn:hover', ['layout_one']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        
		$this->add_render_attribute( 'button', 'class', 'th-btn' );
		
	    


        if( ! empty( $settings['button_link']['url'] ) ) {
            $this->add_render_attribute( 'button', 'href', esc_url( $settings['button_link']['url'] ) );
        }

        if( ! empty( $settings['button_link']['nofollow'] ) ) {
            $this->add_render_attribute( 'button', 'rel', 'nofollow' );
        }

        if( ! empty( $settings['button_link']['is_external'] ) ) {
            $this->add_render_attribute( 'button', 'target', '_blank' );
        }

        echo '<div class="btn-group mt-15">';

            echo '<a '.$this->get_render_attribute_string('button').'>'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';

            echo '<div class="about-profile">';
            	if( ! empty( $settings['image']['url'] ) ){
	                echo '<div class="avater">';
	                    echo konta_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						) );
	                echo '</div>';
	            }

                echo '<div class="media-body">';
                	if( ! empty( $settings['author_name'] ) ){
	                    echo '<h5 class="about-profile-name">'.esc_html($settings['author_name']).'</h5>';
	                }
	                if( ! empty( $settings['author_desig'] ) ){
	                   	echo ' <p class="desig">'.esc_html($settings['author_desig']).'</p>';
	                }
                echo '</div>';
            echo '</div>';
        echo '</div>';
	}

}