<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Widget .
 *
 */
class Konta_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'kontacontactform';
	}
	public function get_title() {
		return __( 'Contact Form', 'konta' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'konta' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'konta' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'konta' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'contact_form_section',
			[
				'label' 	=> __( 'Contact Form', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Chose Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
				]
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Title', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Send Message', 'konta' ),
				'rows' => '2',
				'condition'	=> ['layout_style' => ['layout_one', 'layout_three']]
			]
        );

		$this->add_control(
            'konta_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'konta' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );
        $this->add_control(
			'content_area',
			[
				'label' 	=> __( 'Information', 'konta' ),
                'type' 		=> Controls_Manager::WYSIWYG,
                'default'  	=> __( 'Send Message', 'konta' ),
				'rows' => '2',
				'condition'	=> ['layout_style' => ['layout_two']]
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

	    $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="align-self-center">';
                echo '<div class="testi-contace-wrap bg-white">';
                    echo '<div class="contact-form-wrap">';
                    	if(!empty($settings['section_title'])){
		                    echo '<h2 class="title h4 text-center">'.esc_html($settings['section_title']).'</h2>';
		                }
		                if( !empty($settings['konta_select_contact_form']) ){
	                        echo do_shortcode( '[contact-form-7  id="'.$settings['konta_select_contact_form'].'"]' ); 
	                    }else{
	                        echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'konta' ). '</p></div>';
	                    }
                    echo '</div>';
                echo '</div>';
           	echo '</div>';
        }elseif( $settings['layout_style'] == 'layout_two' ){

        	function custom_kses_post($data) {
			    $allowed_tags = wp_kses_allowed_html('post');

			    // Add form tag and its attributes to the allowed tags
			    $allowed_tags['form'] = array(
			        'action'   => true,
			        'method'   => true,
			        'id'       => true,
			        'class'    => true,
			        'enctype'  => true,
			        'accept'   => true,
			        'name'     => true,
			        'target'   => true,
			        'novalidate' => true,
			    );

			    // Add other form related tags if needed e.g., input, select, etc.
			    $allowed_tags['input'] = array(
			        'type'         => true,
			        'name'         => true,
			        'value'        => true,
			        'placeholder'  => true,
			        'required'     => true,
			        'id'           => true,
			        'class'        => true,
			    );
			    $allowed_tags['i'] = array(
			        'class' => true,
			        'id'    => true,
			    );


			    return wp_kses($data, $allowed_tags);
			}


        	echo '<div class="contact-wrap1">';
                echo '<div class="contact-form-wrap">';
                    if( !empty($settings['konta_select_contact_form']) ){
                        echo do_shortcode( '[contact-form-7  id="'.$settings['konta_select_contact_form'].'"]' ); 
                    }else{
                        echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'konta' ). '</p></div>';
                    }
                    
                echo '</div>';
                echo '<div class="newsletter-card bg-title">';
                   	if(!empty($settings['content_area'])){
	                    echo custom_kses_post( $settings['content_area'] );
	                }

                echo '</div>';
            echo '</div>';
        }else{
        	echo '<div class="wcu-contact-wrap bg-white">';
                echo '<div class="contact-form-wrap">';
                    if(!empty($settings['section_title'])){
	                    echo '<h2 class="title h4 text-center">'.esc_html($settings['section_title']).'</h2>';
	                }
                    echo '<div class="contact-form">';
                        if( !empty($settings['konta_select_contact_form']) ){
	                        echo do_shortcode( '[contact-form-7  id="'.$settings['konta_select_contact_form'].'"]' ); 
	                    }else{
	                        echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'konta' ). '</p></div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
	}
}