<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Tab Widget .
 *
 */
class Konta_Contact_Info_V2 extends Widget_Base {

	public function get_name() {
		return 'kontacontactinfov2';
	}

	public function get_title() {
		return __( 'Konta Contact Info', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {


		$this->start_controls_section(
			'contact_information',
			[
				'label' 	=> __( 'Contact Information', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
            'title',
            [
                'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
                'default'   => __( 'Our Contact Information', 'konta' )
            ]
        );
        $this->add_control(
            'desc',
            [
                'label'     => __( 'Description', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
                'default'   => __( 'Have a inquiry or some feedback for us? Fill out the form below to contact our team.', 'konta' )
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
			'phone_section',
			[
				'label' 	=> __( 'Phone Info', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'phone_contact_label',
			[
				'label'     => __( 'Phone Label', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Call Now:', 'konta' )
			]
        );
        $this->add_control(
			'phone_contact_info',
			[
				'label'     => __( 'Phone Info', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '+1 504-899-8221', 'konta' )
			]
        );
        $this->add_control(
            'email_contact_label',
            [
                'label'     => __( 'Email Label', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
                'default'   => __( 'Email Now:', 'konta' )
            ]
        );
        $this->add_control(
            'email_contact_info',
            [
                'label'     => __( 'Email Info', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
                'default'   => __( 'info@konta.com', 'konta' )
            ]
        );
        $this->add_control(
			'phone_icon',
			[
				'label' 	=> __( 'Icon', 'konta' ),
				'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
			]
		);
        $this->end_controls_section();


        

        $this->start_controls_section(
			'address_section',
			[
				'label' 	=> __( 'Adress Info', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'address_contact_label',
			[
				'label'     => __( 'Address Label', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Location:', 'konta' )
			]
        );
        $this->add_control(
			'address_contact_info',
			[
				'label'     => __( 'Address Info', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '1403 Washington Ave, New Orlea <br> ns, LA 70130 United States', 'konta' )
			]
        );
        $this->add_control(
			'address_icon',
			[
				'label' 	=> __( 'Icon', 'konta' ),
				'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'o_h_section',
			[
				'label' 	=> __( 'Opening Hours Info', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'o_h_contact_label',
			[
				'label'     => __( 'Opening Hours Label', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Location:', 'konta' )
			]
        );
        $this->add_control(
			'o_h_contact_info',
			[
				'label'     => __( 'Opening Hours Info', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '1403 Washington Ave, New Orlea <br> ns, LA 70130 United States', 'konta' )
			]
        );
        $this->add_control(
			'o_h_icon',
			[
				'label' 	=> __( 'Icon', 'konta' ),
				'type'      => Controls_Manager::TEXTAREA,
                'rows'      => 2,
			]
		);
        $this->end_controls_section();

        /*-----------------------------------------section Content styling------------------------------------*/

        $this->start_controls_section(
            'section_con_styling',
            [
                'label'     => __( 'Content Style', 'digalu' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'style_tabs1'
        );


        $this->start_controls_tab(
            'style_normal_tab1',
            [
                'label' => esc_html__( 'Label', 'digalu' ),
            ]
        );
        $this->add_control(
            's_title_color',
            [
                'label'         => __( 'Color', 'digalu' ),
                'type'          => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} h3, {{WRAPPER}} h4'    => '--title-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_group_control(
        Group_Control_Typography::get_type(),
            [
                'name'          => 's_title_typography',
                'label'         => __( 'Typography', 'digalu' ),
                'selector'  => '{{WRAPPER}} h3 ,{{WRAPPER}} h4',
            ]
        );

        $this->add_responsive_control(
            's_title_margin',
            [
                'label'         => __( 'Margin', 'digalu' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '{{WRAPPER}} h3, {{WRAPPER}} h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            's_title_padding',
            [
                'label'         => __( 'Padding', 'digalu' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '{{WRAPPER}} h3, {{WRAPPER}} h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'

                ],
            ]
        );
        $this->end_controls_tab();

        //--------------------secound--------------------//

        $this->start_controls_tab(
            'style_hover_tab2',
            [
                'label' => esc_html__( 'Info', 'digalu' ),
            ]
        );
        $this->add_control(
            's_content_color',
            [
                'label'         => __( 'Color', 'digalu' ),
                'type'          => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .contact-info_text, {{WRAPPER}} .contact-feature_text'    => '--body-color: {{VALUE}}!important;',
                ]
            ]
        );
        $this->add_group_control(
        Group_Control_Typography::get_type(),
            [
                'name'          => 's_content_typography',
                'label'         => __( 'Typography', 'digalu' ),
                'selector'  => '{{WRAPPER}} .contact-info_text, {{WRAPPER}} .contact-feature_text',
            ]
        );

        $this->add_responsive_control(
            's_content_margin',
            [
                'label'         => __( 'Margin', 'digalu' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '{{WRAPPER}} .contact-info_text, {{WRAPPER}} .contact-feature_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
            's_content_padding',
            [
                'label'         => __( 'Padding', 'digalu' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '{{WRAPPER}} .contact-info_text, {{WRAPPER}} .contact-feature_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        
        echo '<div class="row gy-4 justify-content-center">';

            if(!empty($settings['address_contact_label'] && $settings['address_contact_info'] && $settings['address_icon'])){
                echo '<div class="col-xl-4 col-lg-6">';
                    echo '<div class="contact-feature">';
                        echo '<div class="contact-feature-icon">'.wp_kses_post($settings['address_icon']).'</div>';
                        echo '<div class="media-body">';
                            echo '<p class="contact-feature_label">'.esc_html($settings['address_contact_label']).'</p>';
                            echo '<span class="contact-info_text">'.wp_kses_post($settings['address_contact_info']).'</span>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
            if(!empty($settings['phone_contact_label'] && $settings['phone_contact_info'] && $settings['phone_icon'])){
                $phone      = $settings['phone_contact_info'];
                $replace        = array(' ','-',' - ');
                $with           = array('','','');
                $phonelurl       = str_replace( $replace, $with, $phone );

                $email      = $settings['email_contact_info'];
                $email          = is_email( $email );
                $replace        = array(' ','-',' - ');
                $with           = array('','','');
                $emaillurl       = str_replace( $replace, $with, $email );
                echo '<div class="col-xl-4 col-lg-6">';
                    echo '<div class="contact-feature">';
                        echo '<div class="contact-feature-icon">'.wp_kses_post($settings['phone_icon']).'</div>';
                        echo '<div class="media-body">';
                            echo '<p class="contact-feature_label">'.esc_html($settings['phone_contact_label']).'</p>';
                            echo '<a href="'.esc_attr( 'tel:'.$phonelurl ).'" class="contact-feature_link">Mobile: '.esc_html($settings['phone_contact_info']).'</a>';
                            echo '<a href="'.esc_attr( 'mailto:'.$emaillurl ).'" class="contact-feature_link">Email: '.esc_html($settings['email_contact_info']).'</a>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
            if(!empty($settings['o_h_contact_label'] && $settings['o_h_contact_info'] && $settings['o_h_icon'])){
                echo '<div class="col-xl-4 col-lg-6">';
                    echo '<div class="contact-feature">';
                        echo '<div class="contact-feature-icon">'.wp_kses_post($settings['o_h_icon']).'</div>';
                        echo '<div class="media-body">';
                            echo '<p class="contact-feature_label">'.esc_html($settings['o_h_contact_label']).'</p>';
                            echo wp_kses_post($settings['o_h_contact_info']);
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
        echo '</div>';
	}
}