<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Counter Up Widget .
 *
 */
class Konta_Counterup extends Widget_Base {

	public function get_name() {
		return 'kontacounterup';
	}

	public function get_title() {
		return __( 'Konta Counter Up', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Content', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        ); 
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Counter Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
					'layout_five'  		=> __( 'Style Five', 'konta' ),
				],
			]
		);
		$this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'konta' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Title' , 'konta' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'konta' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Subtitle' , 'konta' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		 $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Button Text', 'konta' ),
                'condition'	=> ['layout_style' => ['layout_four']]
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'counter_number',
			[
				'label'     => __( 'Counter Number', 'konta' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( '25', 'konta' ),
			]
		);
		$repeater->add_control(
			'counter_suffix',
			[
				'label'     => __( 'Suffix', 'konta' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( 'K+', 'konta' ),
			]
		);
		$repeater->add_control(
			'counter_text',
			[
				'label'     => __( 'Counter Text', 'konta' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( 'Years Of Experience', 'konta' ),
			]
		);
		$repeater->add_control(
			'counter_image',
			[
				'label' 		=> __( 'Counter Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'counter',
			[
				'label' 		=> __( 'Counter', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'counter_text' 		=> __( 'Counter One', 'konta' ),
					],
				],
				'title_field' 	=> '{{{ counter_text }}}',
			]
		);
		$this->add_control(
			'thumb',
			[
				'label' 		=> __( 'Thumbnail', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);
		$this->end_controls_section();

        
        //-------------------------------------number styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Number Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Number', '{{WRAPPER}} .number-selector',['layout_one', 'layout_three', 'layout_four', 'layout_five'] );
		konta_all_elementor_style($this, 'Counter', '{{WRAPPER}} .counter-grid.style2 .counter-grid_number',['layout_two'] );

        $this->end_controls_section();


        
        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Counter Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one', 'layout_two', 'layout_three', 'layout_four','layout_five'] );

        $this->end_controls_section();

         //-------------------------------------section title styling-------------------------------------//

        $this->start_controls_section(
			'section_title1_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['layout_style' => ['layout_four']]

			]
		);
		konta_all_elementor_style($this, 'Section Title', '{{WRAPPER}} .sec-title',['layout_four'] );

        $this->end_controls_section();


        //-------------------------------------section subtitle styling-------------------------------------//
       

        $this->start_controls_section(
			'section_sub_style_section',
			[
				'label' => __( 'Subtitle Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['layout_style' => ['layout_four']]

			]
		);
		konta_all_elementor_style($this, 'Section Subtitle', '{{WRAPPER}} .sub-title4',['layout_four'] );

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();


        if( $settings['layout_style'] == 'layout_one' ){
         	echo '<div class="counter-area-1">';
		        echo '<div class="container">';
		            echo '<div class="row justify-content-between gy-5">';
		            	foreach( $settings['counter'] as $data ) {
			                echo '<div class="col-sm-6 col-xl-3">';
			                    echo '<div class="counter-grid">';
			                    	if( ! empty( $data['counter_image']['url']  ) ){
				                        echo '<div class="counter-grid_icon">';
				                            echo konta_img_tag( array(
							                    'url'   => esc_url( $data['counter_image']['url']  ),
							                ));
				                        echo '</div>';
				                    }
			                        echo '<div class="details">';
			                        	if( ! empty( $data['counter_number'] ) ){
			                        		$counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';

				                            echo '<h2 class="counter-grid_number number-selector"><span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h2>';
				                        }
				                        if( !empty( $data['counter_text'] ) ){
				                            echo '<p class="counter-grid_text title-selector">'.esc_html( $data['counter_text'] ).'</p>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_two' ){
			echo '<div class="z-index-common">';
		        echo '<div class="container">';
		            echo '<div class="counter-area-2 bg-smoke">';
		                echo '<div class="row align-items-center flex-row-reverse">';
		                	if( ! empty( $settings['thumb']['url']  ) ){
			                    echo '<div class="col-xl-5">';
			                        echo '<div class="counter-thumb mb-5 mb-xl-0">';
				                        echo konta_img_tag( array(
						                    'url'   => esc_url( $settings['thumb']['url']  ),
						                ));
			                        echo '</div>';
			                    echo '</div>';
			                }
		                    echo '<div class="col-xl-7">';
		                        echo '<div class="row gy-4">';
		                        	foreach( $settings['counter'] as $data ) {
			                            echo '<div class="col-md-6">';
			                                echo '<div class="counter-grid style2">';
			                                	if( ! empty( $data['counter_image']['url']  ) ){
							                        echo '<div class="counter-grid_icon">';
							                            echo konta_img_tag( array(
										                    'url'   => esc_url( $data['counter_image']['url']  ),
										                ));
							                        echo '</div>';
							                    }
			                                    echo '<div class="details">';
			                                    	if( ! empty( $data['counter_number'] ) ){
			                                    		$counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';

				                                        echo '<h2 class="counter-grid_number-shadow">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h2>';
				                                        echo '<h2 class="counter-grid_number"><span class="counter-number number-selector">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h2>';
				                                    }
				                                    if( !empty( $data['counter_text'] ) ){
				                                        echo '<p class="counter-grid_text title-selector">'.esc_html( $data['counter_text'] ).'</p>';
				                                    }
			                                    echo '</div>';
			                                echo '</div>';
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_three' ){
			echo '<div class="counter-area-3 space-extra2">';
                echo '<div class="row gy-40 justify-content-between">';
                    foreach( $settings['counter'] as $data ) {
	                    echo '<div class="col-md-6 col-lg-auto">';
	                        echo '<div class="counter-grid style3">';
	                        	if( ! empty( $data['counter_image']['url']  ) ){
		                            echo '<div class="counter-grid_icon">';
		                                echo konta_img_tag( array(
						                    'url'   => esc_url( $data['counter_image']['url']  ),
						                ));
		                            echo '</div>';
		                        }

	                            echo '<div class="details">';
	                            	if( ! empty( $data['counter_number'] ) ){
			                            $counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';
	                                	echo '<h2 class="counter-grid_number  number-selector"><span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h2>';
	                                }
	                                if( !empty( $data['counter_text'] ) ){
		                                echo '<p class="counter-grid_text title-selector">'.esc_html( $data['counter_text'] ).'</p>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="z-index-common">';
		        echo '<div class="container th-container2">';
		            echo '<div class="counter-area-4">';
		                echo '<div class="row align-items-center justify-content-between">';
		                    echo '<div class="col-xl-5">';
		                        echo '<div class="title-area mb-xl-0 text-center text-xl-start mb-50">';
		                        	if( ! empty( $settings['title'] ) ){
			                            echo '<span class="sub-title4">'.esc_html( $settings['title'] ).'</span>';
			                        }
			                        if( ! empty( $settings['subtitle'] ) ){
			                            echo '<h2 class="sec-title fw-semibold">'.esc_html( $settings['subtitle'] ).'</h2>';
			                        }
			                        if( ! empty( $settings['button_text'] ) ) {
			                            echo '<a href="'.esc_url( $settings['button_link']['url'] ).'" class="th-btn mt-10">'.esc_html( $settings['button_text'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="col-xl-7">';
		                        echo '<div class="counter-wrap4">';
		                            echo '<div class="row">';
		                                foreach( $settings['counter'] as $data ) {
		                                	$counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';
			                                echo '<div class="col-sm-6 counter-grid-wrap">';
			                                    echo '<div class="counter-grid style4">';
			                                        if( ! empty( $data['counter_image']['url']  ) ){
								                        echo '<div class="counter-grid_icon">';
								                            echo konta_img_tag( array(
											                    'url'   => esc_url( $data['counter_image']['url']  ),
											                ));
								                        echo '</div>';
								                    }
			                                        echo '<div class="details">';
			                                        	if( ! empty( $data['counter_number'] ) ){
				                                            echo '<h2 class="counter-grid_number"><span class="counter-number number-selector">'.esc_html( $data['counter_number'] ).'</span>'.wp_kses_post( $counter_suffix ).'</h2>';
				                                        }
				                                        if( !empty( $data['counter_text'] ) ){
				                                            echo '<p class="counter-grid_text title-selector">'.esc_html( $data['counter_text'] ).'</p>';
				                                        }
			                                        echo '</div>';
			                                    echo '</div>';
			                                echo '</div>';
			                            }
		                                

		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}else{
			echo '<div class="about-grid-wrap2">';
				foreach( $settings['counter'] as $data ) {
		            $counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';

	                echo '<div class="about-grid3">';
	                    echo '<h3 class="about-grid_year"><span class="counter-number number-selector">'.esc_html( $data['counter_number'] ).'</span><span class="text-theme fw-normal">'.wp_kses_post( $counter_suffix ).'</span></h3>';
	                    
	                    if( !empty( $data['counter_text'] ) ){
                            echo '<p class="about-grid_text  title-selector">'.esc_html( $data['counter_text'] ).'</p>';
                        }
	                echo '</div>';
	            }
            echo '</div>';
		}
	}
}