<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget .
 *
 */
class Konta_CTA extends Widget_Base {

	public function get_name() {
		return 'kontacta';
	}

	public function get_title() {
		return __( 'CTA', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'konta' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'konta' ) ] = 0;
        }
        return $as_cfa;
    }


	protected function register_controls() {

		$this->start_controls_section(
			'wcu_section',
			[
				'label' 	=> __( 'CTA', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Feature Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
				],
			]
		);
		$this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( ' WHY CHOOSE US' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $this->add_control(
            'title_img',
            [
                'label'     => __( 'Title Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'High Quality Construction Projects & Innovate Design!' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $this->add_control(
			'desc', [
				'label' 		=> __( 'Description', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'High Quality Construction Projects & Innovate Design!' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $this->add_control(
			'important_note',
			[
				'label' => esc_html__( 'Information', 'konta' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'raw' => esc_html__( 'A very important message to show in the panel.', 'textdomain' ),
			]
		);

         $this->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);


		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Form Title', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Send Message', 'konta' ),
				'rows' => '2',
			]
        );

		$this->add_control(
            'konta_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'konta' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );
        
        
        $this->end_controls_section();


        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one'],'--white-color' );

        $this->end_controls_section();

         //-------------------------------------subtitle styling-------------------------------------//

        $this->start_controls_section(
			'section_subtitle_style_section',
			[
				'label' => __( 'Subtitle Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Subtitle', '{{WRAPPER}} .subtitle-selector',['layout_one'],'--white-color' );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Description Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_one'],'--white-color' );

        $this->end_controls_section();

        //-------------------------------------features  styling-------------------------------------//

        $this->start_controls_section(
			'features_style_section',
			[
				'label' => __( 'Features Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Features', '{{WRAPPER}} .wcu-box .box-title',['layout_one'] );
		konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .wcu-box', ['layout_one'], 'background');

        $this->end_controls_section();

        //-------------------------Button Style-----------------------//
		
		$this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'First Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn.style6', ['layout_one']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn.style6', ['layout_one']);
					konta_elementor_color_style($this, 'Button Background', '{{WRAPPER}} .th-btn.style6', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn.style6', ['layout_one']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn.style6:hover', ['layout_one']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn.style6:before, {{WRAPPER}} .th-btn.style6:after', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Buttonn-Hover', '{{WRAPPER}} .th-btn.style6:hover', ['layout_one']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();

		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<div class="container" id="contact-sec">';
	        echo '<div class="cta-area-1">';
	            echo '<div class="row g-0 align-items-center">';
	                echo '<div class="col-xl-5">';
	                    echo '<div class="cta-wrap title-area mb-0 bg-theme">';
	                    	if(!empty($settings['title'])){
                                echo '<span class="sub-title text-white title-selector">';
	                                if(!empty($settings['title_img']['url'])){
					                    echo konta_img_tag( array(
				                        	'url' => esc_url( $settings['title_img']['url'] ),
				                        ) );
					                }
	                                echo esc_html($settings['title']);
                                echo '</span>';
                            }
	                        if(!empty($settings['subtitle'])){
	                            echo '<h2 class="sec-title text-white subtitle-selector">'.esc_html($settings['subtitle']).'</h2>';
	                        }
	                        if(!empty($settings['desc'])){
	                            echo '<p class="sec-text text-white desc-selector">'.esc_html($settings['desc']).'</p>';
	                        }
	                        echo '<div class="cta-link-wrap mb-40">';
	                            
	                        if(!empty($settings['important_note'])){
	                            echo $settings['important_note'];
	                        }

	                        echo '</div>';
	                        if(!empty($settings['button_text'])){
	                            echo '<a href="'.esc_url( $settings['button_link']['url'] ).'" class="th-btn style6">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-1"></i></a>';
	                        }
	                    echo '</div>';
	                echo '</div>';
	                echo '<div class="col-xl-7">';
	                    echo '<div class="contact-form-wrap">';
	                    	if(!empty($settings['section_title'])){
	                            echo '<h2 class="title h4 text-center">'.esc_html($settings['section_title']).'</h2>';
	                        }
	                        echo '<div class="contact-form ">';
	                            if( !empty($settings['konta_select_contact_form']) ){
			                        echo do_shortcode( '[contact-form-7  id="'.$settings['konta_select_contact_form'].'"]' ); 
			                    }else{
			                        echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'konta' ). '</p></div>';
			                    }


	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';
	    echo '</div>';
	}
}