<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Gallery Widget .
 *
 */
class konta_Gallery extends Widget_Base {

	public function get_name() {
		return 'kontagallery';
	}

	public function get_title() {
		return __( 'konta Gallery', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'gallery_section',
			[
				'label'		 	=> __( 'Gallery', 'konta' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Gallery Slider', 'aduki' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);

        $this->end_controls_section();

	}

	protected function render() {

    $settings = $this->get_settings_for_display();
    	echo '<div class="row gy-4 masonary-active">';
            foreach ( $settings['gallery'] as $single_data ){   
	            echo '<div class="col-md-6 col-xxl-auto filter-item">';
	                echo '<div class="gallery-card">';
	                    echo '<div class="gallery-img">';
	                        echo konta_img_tag( array(
									'url'   => esc_url( $single_data['url'] )
								) );
	                        echo '<a href="'.esc_url( $single_data['url'] ).'" class="gallery-btn popup-image"><i class="fas fa-plus"></i></a>';
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
	        } 
        echo '</div>';
	}
}