<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Konta_Group_Image extends Widget_Base {

	public function get_name() {
		return 'kontagroupimage';
	}

	public function get_title() {
		return __( 'Konta Group Image', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Group Image', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Group Style', 'konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'layout_one',
				'options' 	=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  	=> __( 'Style Four', 'konta' ),
				],
			]
		);


        $this->add_control(
			'image1',
			[
				'label' 		=> __( 'Image 1', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image2',
			[
				'label' 		=> __( 'Image 2', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' => ['layout_one','layout_three' ,'layout_four'] ],
			]
		);
		$this->add_control(
			'image3',
			[
				'label' 		=> __( 'Image 3', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' => ['layout_one','layout_three','layout_four'] ],
				
			]
		);
		$this->add_control(
			'image4',
			[
				'label' 		=> __( 'Image 4', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' => ['layout_three','layout_four'] ],
				
			]
		);
		$this->add_control(
			'url',
			[
				'label'         => __( 'Video Url', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( '#' , 'konta' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' => ['layout_three'] ],
			]		
		);
		$this->add_control(
			'desc',
            [
				'label'         => __( 'Experience Area', 'konta' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'Neurology Specialist' , 'konta' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' => ['layout_one', 'layout_two','layout_four'] ],
			]
		);
		
		
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="img-box1">';
        		if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }

	            if(!empty($settings['desc'])){
	                echo '<div class="about-grid">';
	                    echo wp_kses_post( $settings['desc'] );
	                echo '</div>';
	            }

                if(!empty($settings['image2']['url'])){
	                echo '<div class="img2">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image2']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	                echo '<div class="shape-mockup about-shape1 jump" data-left="-67px" data-bottom="0">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url']  ),
		                ));
	                echo '</div>';
	            }

            echo '</div>';
        }elseif( $settings['layout_style'] == 'layout_two' ){
        	echo '<div class="wcu-img-2 tilt-active mb-50 mb-xl-0 me-xl-4">';
        		if(!empty($settings['image1']['url'])){
        			echo konta_img_tag( array(
	                    'url'   => esc_url( $settings['image1']['url']  ),
	                ));
        		}
        		if(!empty($settings['desc'])){
	                echo '<div class="wcu-experience-wrap movingX">';
	                    echo wp_kses_post( $settings['desc'] );
	                echo '</div>';
	            }
            echo '</div>';
        }elseif( $settings['layout_style'] == 'layout_three' ){
        	echo '<div class="img-box4">';
        		if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2 tilt-active">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image2']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	            	if(!empty( $settings['url'] )){
		                echo '<a href="'.esc_url( $settings['url'] ).'" class="play-btn style4 popup-video" tabindex="-1"><i class="fa-sharp fa-solid fa-play"></i></a>';
		            }
	                echo '<div class="shape1 shape-mockup jump" data-bottom="57px" data-left="-57px">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['image4']['url'])){
	                echo '<div class="shape2 shape-mockup movingX" data-top="0" data-right="75px">';
	                    echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url']  ),
		                ));
	                echo '</div>';
	            }

            echo '</div>';
        }else{
        	echo '<div class="img-box7">';
        		if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                	echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2">';
	                	echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image2']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	                echo '<div class="shape">';
	                	echo konta_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url']  ),
		                    'class' => 'tilt-active',
		                ));
	                echo '</div>';
	            }
                echo '<div class="about-counter1" data-bg-src="'.esc_url( $settings['image4']['url']  ).'">';
                    if(!empty($settings['desc'])){
		                echo wp_kses_post( $settings['desc'] );
		            }
                echo '</div>';
            echo '</div>';
        }
	}
}

