<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Menu Select Widget .
 *
 */
class Kunta_Menu extends Widget_Base {

	public function get_name() {
		return 'kontamenuselect';
	}
	public function get_title() {
		return __( 'Menu Select', 'konta' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Navigation Menu', 'konta' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );

		$menus = $this->konta_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'konta_menu_select',
				[
					'label'     	=> __( 'Select konta Menu', 'konta' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'konta' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'konta' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'konta' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------


	}

    public function konta_menu_select(){ 
	    $konta_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'konta' );
	    foreach( $konta_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

	$settings = $this->get_settings_for_display();

        //Menu by menu select
        $konta_avaiable_menu   = $this->konta_menu_select();

        if( ! $konta_avaiable_menu ){
            return;
        }
        $args = [
            'menu' 		=> $settings['konta_menu_select'],
            'menu_class' 	=> 'konta-menu',
            'container' 	=> '',
        ];


        if( ! empty( $settings['title'] ) ){
	        echo '<h3 class="widget_title">'.esc_html( $settings['title'] ).'</h3>';
	    }
        if( ! empty( $settings['konta_menu_select'] ) ){
            wp_nav_menu( $args );
        } 


	}

}