<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Konta_Blog_Post_2 extends Widget_Base {

	public function get_name() {
		return 'drillerblogpost';
	}

	public function get_title() {
		return __( 'Blog Post v2', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __( 'Blog Post', 'Konta' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'blog_slider_style',
			[
				'label' 		=> __( 'Blog Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options'		=> [
					'one'  			=> __( 'Style One', 'Konta' ),
					'two' 			=> __( 'Style Two', 'Konta' ),
					'three' 			=> __( 'Style Three', 'Konta' ),
				],
			]
		);
        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'Konta' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default'  	=> __( '4', 'Konta' )
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'Konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '5', 'Konta' ),
			]
		);
		$this->add_control(
			'con_count',
			[
				'label' 	=> __( 'Content Length', 'Konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '5', 'Konta' ),
			]
		);

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'Konta' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','Konta'),
                    'DESC'   	=> __('DESC','Konta'),
                ],
                'default'  	=> 'DESC'
			]
        );

        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'Konta' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'Konta' ),
                    'author'    => __( 'Author', 'Konta' ),
                    'title'    	=> __( 'Title', 'Konta' ),
                    'date'    	=> __( 'Date', 'Konta' ),
                    'rand'    	=> __( 'Random', 'Konta' ),
                ],
                'default'  	=> 'ID'
			]
        );

        $this->add_control(
			'exclude_cats',
			[
				'label' 		=> __( 'Exclude Categories', 'Konta' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->Konta_get_categories(),
			]
        );

        $this->add_control(
			'exclude_tags',
			[
				'label' 		=> __( 'Exclude Tags', 'Konta' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->Konta_get_tags(),
			]
        );

        $this->add_control(
			'exclude_post_id',
			[
				'label'         => __( 'Exclude Post', 'Konta' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
				'options'       => $this->Konta_post_id(),
			]
        );
        $this->add_control(
			'read_more',
			[
				'label' 	=> __( 'Read More Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Read More ', 'Konta' ),
			]
        );
        $this->end_controls_section();

		/*-----------------------------------------general styling------------------------------------*/

		$this->start_controls_section(
			'general_styling',
			[
				'label' 	=> __( 'General Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'con_bg_color',
			[
				'label' 		=> __( 'Post Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-card'	=> 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .blog-content'	=> 'background-color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' 			=> 'border',
				'label' 		=> esc_html__( 'Border', 'Konta' ),
				'selector' 		=> '{{WRAPPER}} .blog-content',
			]
		);
		$this->add_control(
			'date_bg_color',
			[
				'label' 		=> __( 'Date Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-wide .blog-date a'	=> 'background-color: {{VALUE}}!important;',
				],
			]
        );
        
        $this->end_controls_section();


        /*-----------------------------------------meta styling------------------------------------*/

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Meta Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta_hvr_color',
			[
				'label' 		=> __( 'Meta HoverColor', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __( 'Meta Typography', 'Konta' ),
				'selector' 	=> '{{WRAPPER}} .blog-meta a',
			]
		);

		$this->add_control(
			'admin_color',
			[
				'label' 		=> __( 'Author Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-box .author-name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'author_typography',
				'label' 	=> __( 'Author Typography', 'Konta' ),
				'selector' 	=> '{{WRAPPER}} .blog-box .author-name',
			]
		);
		$this->end_controls_section();

		/*-----------------------------------------title styling------------------------------------*/

        $this->start_controls_section(
			'blog_title_styling',
			[
				'label' 	=> __( 'Title Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'blog_title_color',
			[
				'label' 		=> __( 'Title Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_control(
			'blog_title_hvr_color',
			[
				'label' 		=> __( 'Title Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a:hover'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'blog_title_typography',
		 		'label' 		=> esc_html__( 'Title Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} .blog-title a',
		 	]
		);

        $this->add_responsive_control(
			'blog_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'blog_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

        /*-----------------------------------------Description styling------------------------------------*/

        $this->start_controls_section(
			'blog_desc_styling',
			[
				'label' 	=> __( 'Description Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'blog_desc_color',
			[
				'label' 		=> __( ' Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-text'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'blog_desc_typography',
		 		'label' 		=> esc_html__( ' Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} .blog-text',
		 	]
		);

        $this->add_responsive_control(
			'blog_desc_margin',
			[
				'label' 		=> __( ' Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'blog_desc_padding',
			[
				'label' 		=> __( ' Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

        /*-----------------------------------------Button styling------------------------------------*/

        $this->start_controls_section(
			'blog_btn_styling',
			[
				'label' 	=> __( 'Button Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'blog_btn_color',
			[
				'label' 		=> __( ' Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .link-btn'	=> 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .link-btn:before'	=> 'background-color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_control(
			'blog_btn_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .link-btn:hover'	=> 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .link-btn:hover::before'	=> 'background-color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'blog_btn_typography',
		 		'label' 		=> esc_html__( ' Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} .link-btn',
		 	]
		);

        $this->add_responsive_control(
			'blog_btn_margin',
			[
				'label' 		=> __( ' Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .link-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'blog_btn_padding',
			[
				'label' 		=> __( ' Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .link-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

    }

    public function Konta_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'Konta');
        }

        return $catarr;
    }

    public function Konta_get_tags() {
        $cats = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'Konta');
        }

        return $catarr;
    }

    // Get Specific Post
    public function Konta_post_id(){
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        );

        $Konta_post = new WP_Query( $args );

        $postarray = [];

        while( $Konta_post->have_posts() ){
            $Konta_post->the_post();
            $postarray[get_the_Id()] = get_the_title();
        }
        wp_reset_postdata();
        return $postarray;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $exclude_post = $settings['exclude_post_id'];

        if( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats']
            );
        } elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags']
            );
        }elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
            );
        } elseif( empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'post__not_in'          => $exclude_post
            );
        } else {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true
            );
        }


        $blogpost = new WP_Query( $args );

        if( $settings['blog_slider_style'] == 'three' ){
        	$row_wrap = 'row';
        }else{
        	$row_wrap = 'row blog_slider1 slider-shadow';
        }

        $i = 0;

    	echo '<div class="'.esc_attr($row_wrap).'">';
            while( $blogpost->have_posts() ) {$blogpost->the_post();
            	$categories = get_the_category();
            	if( $settings['blog_slider_style'] == 'one' ){
	            	echo '<div class="col-md-6 col-xl-4">';
	                    echo '<div class="blog-card">';
	                    	if(has_post_thumbnail()){
		                        echo '<div class="blog-img">';
		                            the_post_thumbnail('Konta_391X220');
		                        echo '</div>';
		                    }
	                        echo '<div class="blog-content pt-0">';
	                            echo '<div class="blog-meta style2">';
	                                echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'">';
	                                echo Konta_img_tag( array(
			                            "url"       => esc_url( get_avatar_url( get_the_author_meta('ID'), array() ) ),
			                            "width"     => 30,
			                            "height"    => 30,
			                        ) );
	                                echo esc_html( ucwords( get_the_author() ) ).'</a>';
	                                echo '<a href="'.esc_url( Konta_blog_date_permalink() ).'"><i class="fal fa-calendar-days"></i>'.esc_html( get_the_date( 'd M, Y' ) ).'</a>';
	                            echo '</div>';
	                            if( get_the_title() ){
		                            echo '<h3 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
		                        }
	                            echo '<p class="blog-text">'.esc_html( wp_trim_words( get_the_content( ), $settings['con_count'], '' ) ).'</p>';
	                            if(!empty($settings['read_more'])){
		                            echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style3">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right"></i></a>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }elseif( $settings['blog_slider_style'] == 'two' ){
	            	echo '<div class="col-md-6 col-xl-4">';
	                    echo '<div class="blog-card">';
	                        if(has_post_thumbnail()){
		                        echo '<div class="blog-img">';
		                            the_post_thumbnail('Konta_391X220');
		                        echo '</div>';
		                    }
	                        echo '<div class="blog-content">';
	                            echo '<div class="blog-meta">';
	                                echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'">';
	                                echo Konta_img_tag( array(
			                            "url"       => esc_url( get_avatar_url( get_the_author_meta('ID'), array() ) ),
			                            "width"     => 30,
			                            "height"    => 30,
			                        ) );
	                                echo esc_html( ucwords( get_the_author() ) ).'</a>';
	                                echo '<a href="'.esc_url( Konta_blog_date_permalink() ).'"><i class="fal fa-calendar-days"></i>'.esc_html( get_the_date( 'd M, Y' ) ).'</a>';
	                                
	                            echo '</div>';
	                            if( get_the_title() ){
		                            echo '<h3 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
		                        }
	                            echo '<p class="blog-text">'.esc_html( wp_trim_words( get_the_content( ), $settings['con_count'], '' ) ).'</p>';
	                            if(!empty($settings['read_more'])){
		                            echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style3">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right"></i></a>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }else{
	            	$i++;
		    		if( $i == 1 ){
		    			$before_main_wraper = '<div class="col-xl-6 mb-30 mb-xl-0">';
		    			$style_class 		= 'style-big';
		    			$image_crop 		= 'Konta_600X309';
		    			$after_main_wraper 	= '</div>';
		    		}elseif($i == 2){
		    			$before_main_wraper = '<div class="col-xl-6">';
		    			$style_class 		= 'style-small';
		    			$image_crop 		= 'Konta_218X277';
		    			$after_main_wraper 	= '';
		    		}elseif($i == 3){
		    			$before_main_wraper = '';
		    			$style_class 		= 'style-small';
		    			$image_crop 		= 'Konta_218X278';
		    			$after_main_wraper 	= '</div>';
		    		}
	            	echo wp_kses_post($before_main_wraper);
	                    echo '<div class="blog-grid style2 '.esc_attr($style_class).'">';
	  
	                        if(has_post_thumbnail()){
		                        echo '<div class="blog-img">';
		                            the_post_thumbnail($image_crop);
		                        echo '</div>';
		                    }
		                 
	                        echo '<div class="blog-content">';
	                            echo '<div class="blog-meta">';
	                                echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'">';
	                                echo Konta_img_tag( array(
			                            "url"       => esc_url( get_avatar_url( get_the_author_meta('ID'), array() ) ),
			                            "width"     => 30,
			                            "height"    => 30,
			                        ) );
	                                echo esc_html( ucwords( get_the_author() ) ).'</a>';
	                                echo '<a href="'.esc_url( Konta_blog_date_permalink() ).'"><i class="fal fa-calendar-days"></i>'.esc_html( get_the_date( 'd M, Y' ) ).'</a>';
	                                
	                            echo '</div>';
	                            if( get_the_title() ){
		                            echo '<h3 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
		                        }
	                            echo '<p class="blog-text">'.esc_html( wp_trim_words( get_the_content( ), $settings['con_count'], '' ) ).'</p>';
	                            if(!empty($settings['read_more'])){
		                            echo '<a href="'.esc_url( get_permalink() ).'" class="link-btn style3">'.esc_html($settings['read_more']).'<i class="fas fa-arrow-right"></i></a>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	               echo wp_kses_post($after_main_wraper);
	            }
	        } wp_reset_postdata(); 

		echo '</div>';
	}
}