<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Counter Up Widget .
 *
 */
class Konta_Counterup_2 extends Widget_Base {

	public function get_name() {
		return 'drillercounterup';
	}

	public function get_title() {
		return __( 'Counter Up v2', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Content', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        ); 
        $this->add_control(
			'counter_style',
			[
				'label' 		=> __( 'Counter Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
					'4' 		=> __( 'Style Four', 'Konta' ),
				],
			]
		);    
		$repeater = new Repeater();

		$repeater->add_control(
			'counter_number',
			[
				'label'     => __( 'Counter Number', 'Konta' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( '25', 'Konta' ),
			]
		);
		$repeater->add_control(
			'counter_suffix',
			[
				'label'     => __( 'Suffix', 'Konta' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( 'K+', 'Konta' ),
			]
		);
		$repeater->add_control(
			'counter_text',
			[
				'label'     => __( 'Counter Text', 'Konta' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( 'Years Of Experience', 'Konta' ),
			]
		);
		$repeater->add_control(
			'counter_image',
			[
				'label' 		=> __( 'Counter Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'counter',
			[
				'label' 		=> __( 'Counter', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'counter_text' 		=> __( 'Counter One', 'Konta' ),
					],
				],
				'title_field' 	=> '{{{ counter_text }}}',
			]
		);
		$this->end_controls_section();

        /*-----------------------------------------Feedback styling------------------------------------*/

		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Content Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs(
			'style_tabs2'
		);


		$this->start_controls_tab(
			'style_normal_tab2',
			[
				'label' => esc_html__( 'Number', 'Konta' ),
			]
		);
        $this->add_control(
			'overview_title_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h2, {{WRAPPER}} h3'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_title_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} h2, {{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'overview_title_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h2, {{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_title_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h2, {{WRAPPER}} h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_tab();

		//--------------------secound--------------------//

		$this->start_controls_tab(
			'style_hover_tab2',
			[
				'label' => esc_html__( 'Ttitle', 'Konta' ),
			]
		);
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} p',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['counter_style'] == '1' ){
        	$wrapper_style = 'counter-card-wrap2';
        	$style = 'style2';
        }else{
        	$wrapper_style = 'counter-card-wrap';
        	$style = '';
        }

        if( $settings['counter_style'] == '3' ){
			echo '<div class="achive-counter-wrap">';
	        	foreach( $settings['counter'] as $data ) {
	            echo '<div class="achive-counter">';
	                echo '<div class="achive-counter_icon">';
	                     echo Konta_img_tag( array(
		                    'url'   => esc_url( $data['counter_image']['url']  ),
		                ));
	                echo '</div>';
	                if( ! empty( $data['counter_number'] ) ){
		                echo '<h3 class="achive-counter_number"><span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $data['counter_suffix'] ).'</h3>';
		            }
	                 if( !empty( $data['counter_text'] ) ){
		                echo '<p class="achive-counter_text">'.esc_html( $data['counter_text'] ).'</p>';
		            }
	            echo '</div>';
	        	}
	        echo '</div>';
		}elseif( $settings['counter_style'] == '4' ){
			echo '<div class="row gy-50 justify-content-between">';

		 		foreach( $settings['counter'] as $data ) {
	                echo '<div class="col-sm-6 col-xl-auto">';
	                    echo '<div class="counter-card style3">';
	                    	if( ! empty( $data['counter_number'] ) ){
		                        echo '<div class="counter-card_bg-number">';
		                            echo '<span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $data['counter_suffix'] ).'';
		                        echo '</div>';
		                    }
	                        echo '<div class="media-body">';
	                            echo '<h2 class="counter-card_number"><span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $data['counter_suffix'] ).'</h2>';
	                            if( !empty( $data['counter_text'] ) ){
		                            echo '<p class="counter-card_text">'.esc_html( $data['counter_text'] ).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}else{

        echo '<div class="th-container2">';
            echo '<div class="container '.esc_attr($wrapper_style).'">';
                echo '<div class="row gy-30 justify-content-between">';
                	foreach( $settings['counter'] as $data ) {
	                    echo '<div class="col-sm-6 col-xl-auto">';
	                        echo '<div class="counter-card '.esc_attr($style).'">';
	                            if(!empty($data['counter_image']['url'])){
			                        echo '<div class="counter-card_icon">';
			                            echo Konta_img_tag( array(
						                    'url'   => esc_url( $data['counter_image']['url']  ),
						                ));
			                        echo '</div>';
			                    }
	                            echo '<div class="media-body">';
	                            	if( ! empty( $data['counter_number'] ) ){
		                                echo '<h2 class="counter-card_number text-title"><span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $data['counter_suffix'] ).'</h2>';
		                            }
		                            if( !empty( $data['counter_text'] ) ){
		                                echo '<p class="counter-card_text text-body">'.esc_html( $data['counter_text'] ).'</p>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                    
                echo '</div>';
            echo '</div>';
        echo '</div>';	
        }


	}

}