<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget .
 *
 */
class Konta_Feature_2 extends Widget_Base {

	public function get_name() {
		return 'drillerfeature';
	}

	public function get_title() {
		return __( 'Feature v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Feature', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'feature_style',
			[
				'label' 		=> __( 'Feature Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
					'4' 		=> __( 'Style Four', 'Konta' ),
					'5' 		=> __( 'Style Five', 'Konta' ),
				],
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'features',
			[
				'label' 		=> __( 'Features', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'Konta' ),
					],
				],
				'condition' => [
					'feature_style!' => ['5']
				]
			]
		);


        $repeater2 = new Repeater();

		$repeater2->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater2->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'features2',
			[
				'label' 		=> __( 'Features', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'Konta' ),
					],
				],
				'condition' => [
					'feature_style' => ['5']
				]
			]
		);

        $this->end_controls_section();


        /*-----------------------------------------features styling------------------------------------*/

		$this->start_controls_section(
			'title_style_section',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h3'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*-----------------------------------------features styling------------------------------------*/

		$this->start_controls_section(
			'contetnt_style_section',
			[
				'label' 	=> __( 'Content Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'feature_style!' => ['5']
				]
			]
        );
		$this->add_control(
			'Konta_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'Konta_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} p',
			]
		);

        $this->add_responsive_control(
			'Konta_content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'Konta_content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if( $settings['feature_style'] == '1' ){
	        echo '<div class="feature-grid-wrap">';
	            foreach( $settings['features'] as $data ) {     
		            echo '<div class="feature-grid">';
		            	if( ! empty( $data['image']['url'] ) ){
			                echo '<div class="feature-grid_icon">';
			                    echo Konta_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								) );
			                echo '</div>';
			            }
		                echo '<div>';
		                	if( ! empty( $data['title'] ) ){
			                    echo '<h3 class="feature-grid_title">'.esc_html( $data['title'] ).'</h3>';
			                }
			                if( ! empty( $data['content'] ) ){
			                    echo '<p class="feature-grid_text">'.esc_html( $data['content'] ).'</p>';
			                }
		                echo '</div>';
		            echo '</div>';
		        }    
	        echo '</div>';
	    }elseif( $settings['feature_style'] == '2' ){
	    	echo '<div class="row gy-4 justify-content-center">';
                foreach( $settings['features'] as $data ) { 
		            echo '<div class="col-lg-4 col-md-6">';
		                echo '<div class="feature-card3" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/feature_card_bg.png">';
		                    if( ! empty( $data['image']['url'] ) ){
				                echo '<div class="feature-card3_icon">';
				                    echo Konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
				                echo '</div>';
				            }
		                    if( ! empty( $data['title'] ) ){
			                    echo '<h3 class="feature-card3_title">'.esc_html( $data['title'] ).'</h3>';
			                }
			                if( ! empty( $data['content'] ) ){
			                    echo '<p class="feature-card3_text">'.esc_html( $data['content'] ).'</p>';
			                }
		                    echo '<div class="icon-btn"><i class="fas fa-arrow-right"></i></div>';
		                echo '</div>';
		            echo '</div>';
		        }   
	       echo ' </div>';
	    }elseif( $settings['feature_style'] == '3' ){
	    	foreach( $settings['features'] as $data ) { 
		    	echo '<div class="about-feature">';
		    		if( ! empty( $data['image']['url'] ) ){
		                echo '<div class="about-feature_icon">';
		                    echo Konta_img_tag( array(
								'url'   => esc_url( $data['image']['url'] ),
							) );
		                echo '</div>';
		            }
	                echo '<div>';
	                	if( ! empty( $data['title'] ) ){
		                    echo '<h3 class="about-feature_title">'.esc_html( $data['title'] ).'</h3>';
		                }
		                if( ! empty( $data['content'] ) ){
		                    echo '<p class="about-feature_text">'.esc_html( $data['content'] ).'</p>';
		                }
	                echo '</div>';
	            echo '</div>';
	        }
	    }elseif( $settings['feature_style'] == '4' ){
	    	echo '<div class="row slider-shadow feature-slide">';
	    	foreach( $settings['features'] as $data ) { 
		    	echo '<div class="col-xl-3 col-lg-3 col-sm-6">';
			    	echo '<div class="feature-box">';
			    		if( ! empty( $data['image']['url'] ) ){
			                echo '<div class="feature-box_icon">';
			                    echo Konta_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								) );
			                echo '</div>';
			            }
		                echo '<div>';
		                	if( ! empty( $data['title'] ) ){
			                    echo '<h3 class="feature-box_title box-title">'.esc_html( $data['title'] ).'</h3>';
			                }
			                if( ! empty( $data['content'] ) ){
			                    echo '<p class="feature-box_text">'.esc_html( $data['content'] ).'</p>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
	        }
	        echo '</div>';
	    }else{
    	 echo '<div class="achive-feature-wrap">';
    	 	foreach( $settings['features2'] as $data ) { 
             echo '<div class="achive-feature">';
             	if( ! empty( $data['image']['url'] ) ){
                 echo '<div class="achive-feature_icon">';
                     echo Konta_img_tag( array(
							'url'   => esc_url( $data['image']['url'] ),
						) );
                 echo '</div>';
                 }
                 if( ! empty( $data['title'] ) ){
                 echo '<h3 class="achive-feature_title">'.esc_html( $data['title'] ).'</h3>';
                 }
             echo '</div>';
             }
         echo '</div>';
	    }


        
	}
}