<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Konta_Group_Image_2 extends Widget_Base {

	public function get_name() {
		return 'drillergroupimage';
	}

	public function get_title() {
		return __( 'Group Image v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Group Image', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'iamge_style',
			[
				'label' 	=> __( 'Group Style', 'Konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2'  		=> __( 'Style Two', 'Konta' ),
					'3'  		=> __( 'Style Three', 'Konta' ),
					'4'  		=> __( 'Style Four', 'Konta' ),
				],
			]
		);


        $this->add_control(
			'image1',
			[
				'label' 		=> __( 'Image 1', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image2',
			[
				'label' 		=> __( 'Image 2', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'iamge_style!' =>  '2'  ],
			]
		);
		$this->add_control(
			'image3',
			[
				'label' 		=> __( 'Image 3', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'iamge_style' =>  ['1','4']  ],
			]
		);
		$this->add_control(
			'image4',
			[
				'label' 		=> __( 'Image 4', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'iamge_style' =>  '1'  ],
			]
		);
		$this->add_control(
			'experience_label',
            [
				'label'         => __( 'Experience Label', 'Konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Years Experience' , 'Konta' ),
				'label_block'   => true,
				'condition'		=> [ 'iamge_style' =>  ['2', '3', '4']  ],
			]
		);
		$this->add_control(
			'experience',
            [
				'label'         => __( 'Experience Duration', 'Konta' ),
				'type'          => Controls_Manager::NUMBER,
				'condition'		=> [ 'iamge_style' =>  ['2', '3', '4']  ],
			]
		);
		
		
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['iamge_style'] == '1' ){
        	$class = 'img-box11';
        }elseif( $settings['iamge_style'] == '2' ){
        	$class = 'img-box8';
        }elseif( $settings['iamge_style'] == '3' ){
        	$class = 'img-box1';
        }else{
        	$class = 'img-box1 img-box5';
        }
        echo '<div class="'.esc_attr($class).'">';
        	if( $settings['iamge_style'] != '4' ){
		        if(!empty($settings['image1']['url'])){
		            echo '<div class="img1">';
		                echo Konta_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
		            echo '</div>';
		        }
		        if( $settings['iamge_style'] != '3' ){
			        if( $settings['iamge_style'] == '2' ){
				        echo '<div class="about-counter2" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/counter_bg.png">';
				        	if(!empty($settings['experience'])){
				                echo '<h3 class="counter-title"><span class="counter-number">'.esc_html($settings['experience']).'</span></h3>';
				            }
				            if(!empty($settings['experience_label'])){
				                echo '<span class="counter-text">'.esc_html($settings['experience_label']).'</span>';
				            }
			            echo '</div>';
			        }

			        if(!empty($settings['image2']['url'])){
			            echo '<div class="text-end">';
				            echo '<div class="img2">';
				                echo Konta_img_tag( array(
				                    'url'   => esc_url( $settings['image2']['url']  ),
				                ));
				            echo '</div>';
			            echo '</div>';
			        }


			        if(!empty($settings['image3']['url'])){
			            echo '<div class="shape1">';
			                echo Konta_img_tag( array(
			                    'url'   => esc_url( $settings['image3']['url']  ),
			                ));
			            echo '</div>';
			        }
			        if(!empty($settings['image4']['url'])){
			            echo '<div class="shape2">';
			                echo Konta_img_tag( array(
			                    'url'   => esc_url( $settings['image4']['url']  ),
			                ));
			            echo '</div>';
			        }
			    }else{
			    	if(!empty($settings['image2']['url'])){
				    	echo '<div class="shape">';
		                    echo Konta_img_tag( array(
			                    'url'   => esc_url( $settings['image2']['url']  ),
			                ));
		                echo '</div>';
		            }
	                echo '<div class="about-counter1" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/bg_pattern_3.png">';
	                	if(!empty($settings['experience'])){
		                    echo '<h3 class="counter-title"><span class="counter-number">'.esc_html($settings['experience']).'</span></h3>';
		                }
		                if(!empty($settings['experience_label'])){
		                    echo '<span class="counter-text">'.esc_html($settings['experience_label']).'</span>';
		                }
	                echo '</div>';
			    }
			}else{
			    if(!empty($settings['image1']['url'])){
		            echo '<div class="img1">';
		                echo Konta_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
		            echo '</div>';
		        }
			    if(!empty($settings['image2']['url'])){
		            echo '<div class="img2">';
		                echo Konta_img_tag( array(
		                    'url'   => esc_url( $settings['image2']['url']  ),
		                ));
		            echo '</div>';
		        }
			    if(!empty($settings['image3']['url'])){
		            echo '<div class="shape">';
		                echo Konta_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url']  ),
		                ));
		            echo '</div>';
		        }
			    echo '<div class="about-counter1" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/bg_pattern_3.png">';
			    	if(!empty($settings['experience'])){
				        echo '<h3 class="counter-title"><span class="counter-number">'.esc_html($settings['experience']).'</span></h3>';
				    }
				    if(!empty($settings['experience_label'])){
				        echo '<span class="counter-text">'.esc_html($settings['experience_label']).'</span>';
				    }
			    echo '</div>';

			}
	        
        echo '</div>'; 
	}

}

