<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Pricing Box Widget .
 *
 */
class Konta_Pricing_2 extends Widget_Base {

	public function get_name() {
		return 'drillerpricing';
	}

	public function get_title() {
		return __( 'Pricing v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Pricing', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'make_it_active',
			[
				'label' 		=> __( 'Make It Active?', 'Konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'Konta' ),
				'label_off' 	=> __( 'No', 'Konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		 $this->add_control(
			'price_style',
			[
				'label' 		=> __( 'Price Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
				],
			]
		);


		$this->add_control(
			'plan',
			[
				'label'     => __( 'Plan', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 	=> __( 'Basic Plan', 'Konta' ),
			]
        );
        $this->add_control(
			'priceing_plan',
			[
				'label'     => __( 'Price', 'Konta' ),
                'type'      => Controls_Manager::WYSIWYG,
                'default' 	=> __( '<span class="h1 price">$299 <span class="currency">$</span></span><span class="package-duration">Per Month</span>', 'Konta' ),
			]
        );
        $this->add_control(
			'desc',
			[
				'label'     => __( 'Description', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 3,
                'default' 	=> __( 'Efficiently promote process-centric networks after enterprise.', 'Konta' ),
			]
        );
        $this->add_control(
			'features',
			[
				'label'     => __( 'Features', 'Konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );
        $this->add_control(
			'btn_txt',
			[
				'label'     => __( 'Butto Text', 'Konta' ),
                'type'      => Controls_Manager::TEXT,
                'default' 	=> __( 'CHOOSE PLAN', 'Konta' ),
			]
        );
        $this->add_control(
			'btn_url',
			[
				'label'     => __( 'Button Url', 'Konta' ),
                'type'      => Controls_Manager::TEXT,
                'rows' 		=> 2,
                'default' 	=> __( '#', 'Konta' ),
			]
        );

        $this->end_controls_section();

        /*-----------------------------------------GENERAL styling------------------------------------*/

        $this->start_controls_section(
			'basic_styling',
			[
				'label' 	=> __( 'General Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'general_color',
			[
				'label' 		=> __( 'Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-box, {{WRAPPER}} .price-card'	=> 'background-color: {{VALUE}}!important;',
				]
			]
        );    

        $this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Box Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .price-box, {{WRAPPER}} .price-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);    
        $this->add_control(
			'plan_bg_color',
			[
				'label' 		=> __( 'Plan BG Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-card_title'	=> 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .price-box_title'	=> 'border-color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_control(
			'price_color',
			[
				'label' 		=> __( 'Price Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-card_price .price, {{WRAPPER}} .price-box_price'	=> '--theme-color: {{VALUE}}!important;',
				]
			]
        );
        $this->end_controls_section();

        $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:before, {{WRAPPER}} .th-btn:after' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Border Hover', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn:hover',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'Konta' ),
				'selector' => '{{WRAPPER}} .th-btn',
			]
		);
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if($settings['make_it_active'] == 'yes'){
        	$active_class = 'active';
        }else{
        	$active_class = 'normal';
        }

        if($settings['price_style'] == 2){
        	echo '<div class="price-box">';
			    echo '<h3 class="price-box_title box-title">'.esc_html( $settings['plan'] ).'</h3>';
			    echo '<div class="price-box_price">';
			        echo '<span class="price">'.wp_kses_post( $settings['priceing_plan'] ).'</span>';
			    echo '</div>';
			    if( ! empty( $settings['desc'] ) ){
		            echo '<p class="price-card_text mt-15">'.esc_html( $settings['desc'] ).'</p>';
		        }
			    if( ! empty( $settings['features'] ) ){
				    echo '<div class="available-list2">';
				      echo wp_kses_post( $settings['features'] );  
				    echo '</div>';
				}
			    if( ! empty( $settings['btn_txt'] ) ){
			    	echo '<a href="'.esc_url( $settings['btn_url'] ).'" class="th-btn">'.esc_html( $settings['btn_txt'] ).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				}
			echo '</div>';
        }else{
        echo '<div class="price-card '.esc_attr($active_class).'">';
        	if( ! empty( $settings['plan'] ) ){
	            echo '<h3 class="price-card_title">'.esc_html( $settings['plan'] ).'</h3>';
	        }
	        if( ! empty( $settings['priceing_plan'] ) ){
	            echo '<div class="price-card_price">';
	              echo wp_kses_post( $settings['priceing_plan'] );  
	            echo '</div>';
	        }
	        if( ! empty( $settings['desc'] ) ){
	            echo '<p class="price-card_text">'.esc_html( $settings['desc'] ).'</p>';
	        }
	        if( ! empty( $settings['features'] ) ){
	            echo '<div class="price-card_content">';
	               echo wp_kses_post( $settings['features'] );   
	            echo '</div>';
	        }
	        if( ! empty( $settings['btn_txt'] ) ){
	            echo '<a href="'.esc_url( $settings['btn_url'] ).'" class="th-btn">'.esc_html( $settings['btn_txt'] ).'<i class="fas fa-arrow-right ms-2"></i></a>';
	        }
        echo '</div>'; 
        }

	}
}