<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Project Info Widget .
 *
 */
class Konta_Project_Info_Widget_2 extends Widget_Base{

	public function get_name() {
		return 'drillerprojectinfo';
	}

	public function get_title() {
		return esc_html__( 'Project Info v2', 'clianio' );
	}

	public function get_icon() {
		return 'fa fa-code';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'project_content',
			[
				'label'		=> esc_html__( 'Project Info','clianio' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'heading',
			[
				'label' 	=> esc_html__( 'Heading', 'clianio' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> esc_html__( 'Konta - Heading', 'clianio' ),
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'label',
			[
				'label'     => __( 'Label : ', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'info',
			[
				'label'     => __( 'Informations', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'informations',
			[
				'label' 		=> __( 'Informations', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'label' => __( 'Label : ', 'Konta' ),
					],
				]
			]
		);


		$this->end_controls_section();

		//-----------------------------------------Heading STYLING---------------------------------------------//

		$this->start_controls_section(
			'content_heading',
			[
				'label' 	=> esc_html__( 'Heading Styling', 'clianio' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'heading_color',
			[
				'label' 		=> esc_html__( 'Heading Color', 'clianio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .project-information h3'=> 'color: {{VALUE}}!important;',
				],
			]
        );

        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'heading_typography',
		 		'label' 		=> esc_html__( 'Heading Typography', 'clianio' ),
		 		'selector' 		=> '{{WRAPPER}} .project-information h3',
			]
		);

        $this->add_responsive_control(
			'heading_margin',
			[
				'label' 		=> esc_html__( 'Heading Margin', 'clianio' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .project-information h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'heading_padding',
			[
				'label' 		=> esc_html__( 'Heading Padding', 'clianio' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .project-information h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();

         //-----------------------------------------info  STYLING---------------------------------------------//

		$this->start_controls_section(
			'info_Styling',
			[
				'label' 	=> esc_html__( 'Information Styling', 'clianio' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'info_title_color',
			[
				'label' 		=> esc_html__( 'Info Title Color', 'clianio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-list strong'=> '--theme-color: {{VALUE}}!important;',
				],
			]
        );

        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'info_title_typography',
		 		'label' 		=> esc_html__( 'Info Title Typography', 'clianio' ),
		 		'selector' 		=> '{{WRAPPER}} .info-list strong',
			]
		);

		$this->add_control(
			'info_color',
			[
				'label' 		=> esc_html__( 'Info Color', 'clianio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-list li'=> '--white-color: {{VALUE}}!important;',
				],
			]
        );

        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'info_typography',
		 		'label' 		=> esc_html__( 'Info Title Typography', 'clianio' ),
		 		'selector' 		=> '{{WRAPPER}} .info-list li',
			]
		);

       
        $this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

    	echo '<!-----------------------Start Project Info----------------------->';
    	
    	echo '<div class="widget widget_info  ">';
    		if(!empty($settings['heading'])){
	            echo '<h3 class="widget_title">'.esc_html($settings['heading']).'</h3>';
	        }
            echo '<div class="info-list">';
                echo '<ul>';
                	foreach( $settings['informations'] as $data ) {
	                    echo '<li>';
	                    	if(!empty($data['label'])){
		                        echo '<strong>'.esc_html($data['label']).'</strong>';
		                    }
		                    if(!empty($data['info'])){
		                        echo '<span>'.esc_html($data['info']).'</span>';
		                    }
	                    echo '</li>';
	                }
                echo '</ul>';
            echo '</div>';
        echo '</div>';

		echo '<!-----------------------End Project Info----------------------->';
	}
}