<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Project Box Widget .
 *
 */
class Konta_Project_2 extends Widget_Base {

	public function get_name() {
		return 'drillerproject';
	}

	public function get_title() {
		return __( 'Project v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'project_section',
			[
				'label' 	=> __( 'Project', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'project_style',
			[
				'label' 		=> __( 'Project Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
					'4' 		=> __( 'Style Four', 'Konta' ),
					'5' 		=> __( 'Style Five', 'Konta' ),
					'6' 		=> __( 'Style Six', 'Konta' ),
				],
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Title', 'Konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'Konta' ),
                'condition'	=> ['project_style' => '3']
			]
        );
        $this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Subitle', 'Konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subitle', 'Konta' ),
                'condition'	=> ['project_style' => '3']
			]
        );
        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Button Text', 'Konta' ),
                'condition'	=> ['project_style' => '3']
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['project_style' => '3']
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label' 		=> __( 'BG Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['project_style' => '3']
			]
		);
		$this->add_control(
			'all_text', [
				'label' 		=> __( 'All filter label', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'All' , 'Konta' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'		=> [ 'project_style' =>  '4' ],
			]
		);		
		$this->add_control(
			'slider_id', [
				'label' 		=> __( 'Arrow Slider ID', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '' , 'Konta' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'		=> [ 'project_style' =>  ['5','6'] ],
			]
		);
        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'Konta' ),
			]
        );
        $repeater->add_control(
			'cats',
			[
				'label'     => __( 'Categories Name', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'CONSTRUCTION' , 'Konta' ),
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'details_page',
			[
				'label'     => __( 'Single Page URL', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'projects',
			[
				'label' 		=> __( 'Projects', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'Konta' ),
					],
				],
				'condition'		=> [ 'project_style!' =>  '6' ],
			]
		);

		$repeater2 = new Repeater();

		$repeater2->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'konta' ),
			]
        );
        $repeater2->add_control(
			'desc',
			[
				'label'     => __( 'Description', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'CONSTRUCTION' , 'konta' ),
			]
        );
        $repeater2->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater2->add_control(
			'details_page',
			[
				'label'     => __( 'Single Page URL', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater2->add_control(
			'btn_txt',
			[
				'label'     => __( 'Button Text', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Read More' , 'konta' ),
			]
        );
        $this->add_control(
			'projects2',
			[
				'label' 		=> __( 'Projects', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition'		=> [ 'project_style' =>  '6' ],
			]
		);

        $this->end_controls_section();


        /*-----------------------------------------projects styling------------------------------------*/

		$this->start_controls_section(
			'title_style_section',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h3'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*-----------------------------------------projects styling------------------------------------*/

		$this->start_controls_section(
			'contetnt_style_section',
			[
				'label' 	=> __( 'Category', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'Konta_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'Konta_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} p',
			]
		);

        $this->add_responsive_control(
			'Konta_content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'Konta_content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if( $settings['project_style'] == '1' ){

        	echo '<div class="row" id="projectSlide3">';
                foreach( $settings['projects'] as $data ) {  
	                echo '<div class="col-md-6 col-lg-4">';
	                    echo '<div class="project-box">';
	                    	if( ! empty( $data['image']['url'] ) ){
		                        echo '<div class="project-img">';
		                            echo Konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
		                        echo '</div>';
		                    }

	                        echo '<div class="project-content">';
	                        	if( ! empty( $data['cats'] ) ){
		                            echo '<p class="project-subtitle">'.esc_html( $data['cats'] ).'</p>';
		                        }
		                        if( ! empty( $data['title'] ) ){
		                            echo '<h3 class="project-title"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h3>';
		                        }
	                            echo '<a href="'.esc_url($data['details_page']).'" class="project-icon"><i class="far fa-plus"></i></a>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
                
            echo '</div>';
	    }elseif( $settings['project_style'] == '2' ){
	    	echo '<div class="row">';
                echo '<div class="col-xl-9 col-lg-8">';
                    echo '<div class=" " id="projectSlide2">';
                    	foreach( $settings['projects'] as $data ) { 
	                        echo '<div>';
	                            echo '<div class="project-grid">';
	                                if( ! empty( $data['image']['url'] ) ){
				                        echo '<div class="project-img">';
				                            echo Konta_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
				                        echo '</div>';
				                    }
	                                echo '<div class="project-content">';
	                                    if( ! empty( $data['cats'] ) ){
				                            echo '<p class="project-subtitle">'.esc_html( $data['cats'] ).'</p>';
				                        }
	                                    if( ! empty( $data['title'] ) ){
				                            echo '<h3 class="project-title"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h3>';
				                        }
	                                    echo '<a href="'.esc_url($data['details_page']).'" class="project-icon"><i class="far fa-plus"></i></a>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                        
                    echo '</div>';
                echo '</div>';
                echo '<div class="col-xl-3 col-lg-4">';
                    echo '<div class="row projectSlideThumb">';
                        foreach( $settings['projects'] as $data ) { 
	                        echo '<div class="col-auto">';
	                            echo '<div class="project-6thumb">';
	                            	if( ! empty( $data['image']['url'] ) ){
		                                echo '<div class="project-thumb_img">';
		                                    echo Konta_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
		                                echo '</div>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                    }
                        
                    echo '</div>';
                    echo '<div class="icon-box style3" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/bg_pattern_13.png">';
                        echo '<button data-slick-prev="#projectSlide2" class="slick-arrow default"><i class="far fa-arrow-left"></i></button>';
                        echo '<button data-slick-next="#projectSlide2" class="slick-arrow default"><i class="far fa-arrow-right"></i></button>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
	    }elseif( $settings['project_style'] == '3' ){

	    	echo '<div class="project-sec" data-sec-space="margin-top">';
		        echo '<div class="container th-container4 bg-smoke space" data-bg-src="'.esc_url($settings['bg_image']['url']).'">';
		            echo '<div class="container">';
		                echo '<div class="project-card2-wrap">';
		                    echo '<div class="row justify-content-lg-between align-items-end">';
		                        echo '<div class="col-lg-7 mb-n2 mb-lg-0">';
		                            echo '<div class="title-area">';
		                            	if(!empty($settings['section_title'])){
			                                echo '<span class="sub-title6">'.esc_html($settings['section_title']).'<span class="shape right"><span class="dots"></span></span></span>';
			                            }
			                            if(!empty($settings['section_subtitle'])){
			                                echo '<h2 class="sec-title">'.esc_html($settings['section_subtitle']).'</h2>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                        if(!empty($settings['button_text'])){
		                        	if( ! empty( $settings['button_link']['url'] ) ) {
							            $this->add_render_attribute( 'button', 'href', esc_url( $settings['button_link']['url'] ) );
							            $this->add_render_attribute( 'button', 'class', 'th-btn' );
							        }

							        if( ! empty( $settings['button_link']['nofollow'] ) ) {
							            $this->add_render_attribute( 'button', 'rel', 'nofollow' );
							        }

							        if( ! empty( $settings['button_link']['is_external'] ) ) {
							            $this->add_render_attribute( 'button', 'target', '_blank' );
							        }
			                        echo '<div class="col-auto">';
			                            echo '<div class="sec-btn">';
			                                echo '<a '.$this->get_render_attribute_string('button').'>'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                            echo '</div>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                    echo '<div class="row slider-shadow th-carousel" id="projectSlide1" data-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1">';
					    		foreach( $settings['projects'] as $data ) { 
					                echo '<div class="col-md-6 col-lg-4">';
					                    echo '<div class="project-card2">';
					                        if( ! empty( $data['image']['url'] ) ){
						                        echo '<div class="project-img">';
						                            echo Konta_img_tag( array(
														'url'   => esc_url( $data['image']['url'] ),
													) );
						                        echo '</div>';
						                    }
					                        echo '<div class="project-content">';
					                            if( ! empty( $data['cats'] ) ){
						                            echo '<p class="project-subtitle">'.esc_html( $data['cats'] ).'</p>';
						                        }
					                            if( ! empty( $data['title'] ) ){
						                            echo '<h3 class="project-title"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h3>';
						                        }
					                            echo '<a href="'.esc_url($data['details_page']).'" class="project-icon"><i class="far fa-plus"></i></a>';
					                        echo '</div>';
					                    echo '</div>';
					                echo '</div>';
					            }
				                
				            echo '</div>';
				           	echo ' <div class="icon-box">';
				                echo '<button data-slick-prev="#projectSlide1" class="slick-arrow default"><i class="far fa-arrow-left"></i></button>';
				                echo '<button data-slick-next="#projectSlide1" class="slick-arrow default"><i class="far fa-arrow-right"></i></button>';
				           	echo ' </div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
	    }elseif( $settings['project_style'] == '4' ){
	    	if(count( $settings['projects'] ) > 0){
		    	echo '<div class="tab-menu-wrap">';
	                echo '<span class="shape left"><span class="dots"></span></span>';
	                echo '<div class="tab-menu5 filter-menu-active">';
	                	$text = !empty( $settings['all_text'] ) ? $settings['all_text'] : esc_html__( 'All', 'angfuxsoft' );
	                	$filters = array();
		            	foreach( $settings['projects'] as $project ) {
		            		$temp_filters = explode (",", $project['cats']);
		            		foreach( $temp_filters as $temp_filter ) {
		            			$filters[strtolower(trim($temp_filter))] = $temp_filter;
		            		}
		            	}
	                    echo '<button data-filter="*" class="active" type="button">' .esc_html( $text ). '</button>';
	                    foreach( $filters as $filter ) {
		                    echo '<button data-filter=".'.esc_attr( strtolower($filter) ).'" type="button">'.esc_html( $filter ).'</button>';
		                }
	                echo '</div>';
	                echo '<span class="shape right"><span class="dots"></span></span>';
	            echo '</div>';

	            echo '<div class="row gy-40 filter-active">';

	            	foreach( $settings['projects'] as $project ) {
				        $filter_slug = strtolower(str_replace(',', ' ', $project['cats']));
		                echo '<div class="col-md-6 col-lg-4 filter-item '.esc_attr( $filter_slug ).'">';
		                    echo '<div class="project-card">';
		                        if( ! empty( $project['image']['url'] ) ){
			                        echo '<div class="project-img">';
			                            echo Konta_img_tag( array(
											'url'   => esc_url( $project['image']['url'] ),
										) );
			                        echo '</div>';
			                    }
		                        echo '<div class="project-content">';
		                            if( ! empty( $project['cats'] ) ){
			                            echo '<p class="project-subtitle">'.esc_html( $project['cats'] ).'</p>';
			                        }
		                            if( ! empty( $project['title'] ) ){
			                            echo '<h3 class="project-title"><a href="'.esc_url($project['details_page']).'">'.esc_html( $project['title'] ).'</a></h3>';
			                        }
		                            echo '<a href="'.esc_url($project['details_page']).'" class="project-icon"><i class="far fa-plus"></i></a>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	                
	            echo '</div>';
	        }
	    }elseif( $settings['project_style'] == '5' ){
    	echo '<div class="th-container5">';
	    	echo '<div class="row slider-shadow project-carousel5" id="'.$settings['slider_id'].'">';
	            foreach( $settings['projects'] as $data ) {  
	                echo '<div class="col-md-6 col-lg-4">';
	                    echo '<div class="project-block">';
	                    	if( ! empty( $data['image']['url'] ) ){
		                        echo '<div class="project-img">';
		                            echo Konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
		                        echo '</div>';
		                    }

	                        echo '<div class="project-content">';
		                        echo '<div class="media-body">';
		                        	if( ! empty( $data['cats'] ) ){
			                            echo '<p class="project-subtitle">'.esc_html( $data['cats'] ).'</p>';
			                        }
			                        if( ! empty( $data['title'] ) ){
			                            echo '<h3 class="project-title"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h3>';
			                        }
		                        echo '</div>';
	                            echo '<a href="'.esc_url($data['details_page']).'" class="project-icon"><i class="far fa-plus"></i></a>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
	            
	        echo '</div>';
        echo '</div>';
	    }else{
	    	echo '<div class="overflow-hidden">';
	            echo '<div class="container-fluid p-0">';
	                echo '<div class="row slider-shadow th-carousel g-0" id="projectSlide5" data-slide-show="4" data-xl-slide-show="3" data-ml-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1">';


	                	foreach( $settings['projects2'] as $data ) {  
	                    echo '<div class="col-md-6 col-lg-4">';
	                        echo '<div class="project-block2">';
	                        	if( ! empty( $data['image']['url'] ) ){
		                            echo '<div class="project-img">';
		                                echo konta_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
		                            echo '</div>';
		                        }
	                            echo '<div class="project-content">';
	                            	if( ! empty( $data['title'] ) ){
			                            echo '<h3 class="project-title h4"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h3>';
			                        }
	                               if( ! empty( $data['desc'] ) ){
		                                echo '<p class="project-text">'.esc_html( $data['desc'] ).'</p>';
		                            }
	                                echo '<a href="'.esc_url($data['details_page']).'" class="link-btn">'.esc_html( $data['btn_txt'] ).'<i class="fas fa-arrow-right"></i></a>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
	                    
	                    
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';
	    }
	}
}