<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
/**
 *
 * Product Widget .
 *
 */
class Konta_Slider_Arrow_2 extends Widget_Base {

	public function get_name() {
		return 'drillersliderarrow';
	}

	public function get_title() {
		return __( 'Slider Arrow v2', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'slider_arrow_section',
			[
				'label' 	=> __( 'Slider Arrow', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'slider_id',
			[
				'label' 		=> __( 'Slider Id?', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> 'p_001',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'general',
			[
				'label' 	=> __( 'General', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'arrow_color',
			[
				'label' 	=> __( 'Arrow Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-arrow' => '--theme-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'arrow_hover_color',
			[
				'label' 	=> __( 'Arrow Hover Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-arrow:hover' => '--white-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'arrow_bg_color',
			[
				'label' 	=> __( 'Arrow Background Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-arrow' => '--white-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'arrow_bg_hover_color',
			[
				'label' 	=> __( 'Arrow Background Hover Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-arrow:hover' => '--theme-color: {{VALUE}}',
                ],
			]
        );

		$this->end_controls_section();

    }


	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<div class="sec-btn">';
            echo '<div class="icon-box style2">';
                echo '<button data-slick-prev="#'.esc_attr( $settings['slider_id'] ).'" class="slick-arrow default"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slick-next="#'.esc_attr( $settings['slider_id'] ).'" class="slick-arrow default"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';
        echo '</div>';
	}
}