
<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Konta_Testimonial_Slider_2 extends Widget_Base{

	public function get_name() {
		return 'drillertestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial v2', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __( 'Testimonial Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options'		=> [
					'one'  			=> __( 'Style One', 'Konta' ),
					'two' 			=> __( 'Style Two', 'Konta' ),
					'three' 			=> __( 'Style Three', 'Konta' ),
				],
			]
		);
		$this->add_control(
			'slider_id',
			[
				'label' 		=> __( 'Slider Id?', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> 'p_001',
				'condition' 	=> [
                    'testimonial_style' => 'two'
                ]
			]
		);

		//----------------------------feddback repeter start--------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Rubaida Kanom' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_designation', [
				'label' 		=> __( 'Client Designation', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Chef Leader' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ' , 'Konta' ),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'Konta' ),
						'client_feedback' 	=> __( '“Synergistically transform 24/7 schemas extensible synergy. Progressively develop inexpensive catalysts for change before transparent customer service.”', 'Konta' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'Konta' ),
						'client_feedback' 	=> __( '“Synergistically transform 24/7 schemas extensible synergy. Progressively develop inexpensive catalysts for change before transparent customer service.”', 'Konta' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'Konta' ),
						'client_feedback' 	=> __( '“Synergistically transform 24/7 schemas extensible synergy. Progressively develop inexpensive catalysts for change before transparent customer service.”', 'Konta' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition' => [
					'testimonial_style' => ['one', 'two']
				]
			]
		);

		$repeater2 = new Repeater();

		$repeater2->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater2->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Rubaida Kanom' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
		$repeater2->add_control(
			'client_designation', [
				'label' 		=> __( 'Client Designation', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Chef Leader' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater2->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ' , 'Konta' ),
				'label_block' 	=> true,
			]
		);
		$repeater2->add_control(
			'client_rating',
			[
				'label' 	=> __( 'Client Rating', 'acadu' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '5',
				'options' 	=> [
					'one'  		=> __( 'One Star', 'acadu' ),
					'two' 		=> __( 'Two Star', 'acadu' ),
					'three' 	=> __( 'Three Star', 'acadu' ),
					'four' 		=> __( 'Four Star', 'acadu' ),
					'five' 	 	=> __( 'Five Star', 'acadu' ),
				],
			]
		);
		$this->add_control(
			'slides2',
			[
				'label' 		=> __( 'Slides', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'Konta' ),
						'client_feedback' 	=> __( '“Synergistically transform 24/7 schemas extensible synergy. Progressively develop inexpensive catalysts for change before transparent customer service.”', 'Konta' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'Konta' ),
						'client_feedback' 	=> __( '“Synergistically transform 24/7 schemas extensible synergy. Progressively develop inexpensive catalysts for change before transparent customer service.”', 'Konta' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Rubaida Kanom', 'Konta' ),
						'client_feedback' 	=> __( '“Synergistically transform 24/7 schemas extensible synergy. Progressively develop inexpensive catalysts for change before transparent customer service.”', 'Konta' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition' => [
					'testimonial_style' => ['three']
				]
			]
		);


		$this->end_controls_section();


        //-------------------------------general settings-------------------------------//

		$this->start_controls_section(
			'testimonial_general',
			[
				'label' 	=> __( 'General', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'feedback_bg_clr',
			[
				'label' 		=> __( 'Feedback Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-card2' => '--white-color: {{VALUE}}!important;',
					'{{WRAPPER}} .testi_box_body' => 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .testi-box_content, {{WRAPPER}} .testi-grid' => '--white-color: {{VALUE}}!important;',
				],
			]
		);
		$this->end_controls_section();

		 /*-----------------------------------------Feedback styling------------------------------------*/

		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Feedback Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs(
			'style_tabs2'
		);


		$this->start_controls_tab(
			'style_normal_tab2',
			[
				'label' => esc_html__( 'Nmae', 'Konta' ),
			]
		);
        $this->add_control(
			'overview_title_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h3'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_title_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'overview_title_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_title_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_tab();

		//--------------------secound--------------------//

		$this->start_controls_tab(
			'style_hover_tab2',
			[
				'label' => esc_html__( 'Designation', 'Konta' ),
			]
		);
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} span'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} span',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

		$this->end_controls_tab();

		//--------------------three--------------------//

		$this->start_controls_tab(
			'style_hover_tab3',
			[
				'label' => esc_html__( 'Feedback', 'Konta' ),
			]
		);
		$this->add_control(
			'testi_feedback_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'testi_feedback_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} p',
			]
		);

        $this->add_responsive_control(
			'testi_feedback_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testi_feedback_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();




	}

	protected function render() {

		$settings = $this->get_settings_for_display();


		
		echo '<!-----------------------Start Testimonials Area----------------------->';
		if( $settings['testimonial_style'] == 'one' ){
			echo '<div class="row slider-shadow" id="testiSlide2">';
				foreach( $settings['slides'] as $singleslide ) {
	                echo '<div class="col-lg-6">';
	                    echo '<div class="testi-card2">';
	                    	if( ! empty( $singleslide['client_image']['url'] ) ){
		                        echo '<div class="testi-card2_img">';
		                            echo Konta_img_tag( array(
										'url'	=> esc_url( $singleslide['client_image']['url'] ),
									) );
		                            echo '<div class="testi-card2_quote">';
		                                echo '<img src="'.KONTA_PLUGDIRURI . 'assets/img/quote_1.svg" alt="icon">';
		                            echo '</div>';
		                        echo '</div>';
		                    }
	                        if( ! empty( $singleslide['client_feedback'] ) ) {
                                echo '<p class="testi-card2_text">'.wp_kses_post( $singleslide['client_feedback'] ).'</p>';
                            }
	                        if( ! empty( $singleslide['client_name'] ) ) {
	                            echo '<h3 class="testi-card2_name">'.esc_html( $singleslide['client_name'] ).'</h3>';
	                        }
	                        if( ! empty( $singleslide['client_designation'] ) ) {
	                            echo '<span class="testi-card2_desig">'.esc_html( $singleslide['client_designation'] ).'</span>';
	                        }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['testimonial_style'] == 'two' ){
			echo '<div class="row testi-carousel" id="'.esc_attr( $settings['slider_id'] ).'">';
				foreach( $settings['slides'] as $singleslide ) {
	                echo '<div class="col-lg-6">';
	                    echo '<div class="testi-box">';
	                    	if( ! empty( $singleslide['client_image']['url'] ) ){
		                        echo '<div class="testi-box_img">';
		                            echo Konta_img_tag( array(
										'url'	=> esc_url( $singleslide['client_image']['url'] ),
									) );
		                        echo '</div>';
		                    }
	                        echo '<div class="testi-box_content">';
	                        	if( ! empty( $singleslide['client_name'] ) ) {
		                            echo '<h3 class="testi-box_name">'.esc_html( $singleslide['client_name'] ).'</h3>';
		                        }
		                        if( ! empty( $singleslide['client_designation'] ) ) {
		                            echo '<span class="testi-box_desig">'.esc_html( $singleslide['client_designation'] ).'</span>';
		                        }
		                        if( ! empty( $singleslide['client_feedback'] ) ) {
		                            echo '<p class="testi-box_text">'.wp_kses_post( $singleslide['client_feedback'] ).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }  
            echo '</div>';
		}else{
			echo '<div class="row testi-carousel2" id="'.esc_attr( $settings['slider_id'] ).'">';
				foreach( $settings['slides2'] as $singleslide ) {
	                echo '<div class="col-lg-6">';
	                    echo '<div class="testi-grid">';
	                    	if( ! empty( $singleslide['client_feedback'] ) ) {
	                            echo '<p class="testi-grid_text">'.wp_kses_post( $singleslide['client_feedback'] ).'</p>';
	                        }
	                         echo '<div class="testi-grid_author">';
		                    	if( ! empty( $singleslide['client_image']['url'] ) ){
			                        echo '<div class="testi-grid_avater">';
			                            echo Konta_img_tag( array(
											'url'	=> esc_url( $singleslide['client_image']['url'] ),
										) );
			                        echo '</div>';
			                    }

		                        echo '<div>';
		                        	echo '<div class="testi-grid_review">';
		                        		if( $singleslide['client_rating'] == 'one' ){
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $singleslide['client_rating'] == 'two' ){
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $singleslide['client_rating'] == 'three' ){
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $singleslide['client_rating'] == 'four' ){
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }else{
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                	echo '<i class="fa-solid fa-star-sharp"></i>';
						                }
		                        	echo '</div>';
		                        	if( ! empty( $singleslide['client_name'] ) ) {
			                            echo '<h3 class="testi-grid_name">'.esc_html( $singleslide['client_name'] ).'</h3>';
			                        }
			                        if( ! empty( $singleslide['client_designation'] ) ) {
			                            echo '<span class="testi-grid_desig">'.esc_html( $singleslide['client_designation'] ).'</span>';
			                        }
			                        
		                        echo '</div>';
		                    echo '</div>';
		                     echo '<div class="testi-grid_quote">';
	                             echo '<img src="'.KONTA_PLUGDIRURI . 'assets/img/quote_2.svg" alt="icon">';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }  
            echo '</div>';
		}
		echo '<!-----------------------End Testimonials Area----------------------->';
	}

}