<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * WorkProcess Box Widget .
 *
 */
class Konta_WorkProcess_Box_2 extends Widget_Base {

	public function get_name() {
		return 'drillerfeaturebox';
	}

	public function get_title() {
		return __( 'WorkProcess v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'WorkProcess', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'process_style',
			[
				'label' 		=> __( 'Process Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
				],
			]
		);
        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
		$repeater->add_control(
			'class',
			[
				'label'     => __( 'Icon Class', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 	=> __( 'Image', 'Konta' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'steps',
			[
				'label' 		=> __( 'Work Process', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'Konta' ),
					],
				],
			]
		);

        $this->end_controls_section();


        /*-----------------------------------------features styling------------------------------------*/

		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h3'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*-----------------------------------------features content styling------------------------------------*/

		$this->start_controls_section(
			'content_section',
			[
				'label' 	=> __( 'Content Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} p',
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if($settings['process_style'] == '1' ){

	    	echo '<div class="row gy-40 justify-content-between">';
	    		foreach( $settings['steps'] as $data ) {  
	                echo '<div class="col-sm-6 col-lg-auto process-card2-wrap">';
	                    echo '<div class="process-card2">';
	                    	if( ! empty( $data['class'] ) ){
		                        echo '<div class="process-card2_icon">'.wp_kses_post($data['class']).'</div>';
		                    }
	                        if( ! empty( $data['title'] ) ){
			                    echo '<h3 class="process-card2_title">'.esc_html( $data['title'] ).'</h3>';
			                }
	                        if( ! empty( $data['content'] ) ){
			                    echo '<p class="process-card2_text">'.esc_html( $data['content'] ).'</p>';
			                }
	                    echo '</div>';
	                echo '</div>';
	            }   
	        echo '</div>';
	    }else{
	    	echo '<div class="row gy-40">';
                foreach( $settings['steps'] as $data ) { 
	                echo '<div class="col-md-6 col-xl-4">';
	                    echo '<div class="process-box">';
	                        echo '<div class="process-box_content">';
	                        	if( ! empty( $data['class'] ) ){
		                            echo '<div class="process-box_icon">'.wp_kses_post($data['class']).'</div>';
		                        }
		                        if( ! empty( $data['title'] ) ){
		                            echo '<h2 class="process-box_title">'.esc_html( $data['title'] ).'</h2>';
		                        }
		                        if( ! empty( $data['content'] ) ){
		                            echo '<p class="process-box_text">'.esc_html( $data['content'] ).'</p>';
		                        }
	                        echo '</div>';
	                        echo '<div class="process-box_img">';
	                            echo Konta_img_tag( array(
		                            'url'   => esc_url( $data['image']['url'] ),
		                        ) );
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }  
            echo '</div>';
	    }
	}

}