<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Newslater Widget .
 *
 */
class Konta_Newslatter_Form extends Widget_Base {

	public function get_name() {
		return 'kontanewslatterform';
	}

	public function get_title() {
		return __( 'Konta Newslater', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta_footer_elements' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'newslatter_section',
			[
				'label' 	=> __( 'Newslatter', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Blog Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options'		=> [
					'one'  			=> __( 'Style One', 'konta' ),
					// 'two' 			=> __( 'Style Two', 'konta' ),
				],
			]
		);

		
		
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'one' ){
        	echo '<div class="widget newsletter-widget footer-widget">';
                echo '<form class="newsletter-form form-group">';
                    echo '<input class="form-control" type="email" placeholder="'.esc_attr__('Enter Email Address', 'konta').'" required="">';
                    echo '<button type="submit" class="th-btn style3">'.esc_html__('SUBSCRIBE', 'konta').' </button>';
                echo '</form>';
            echo '</div>';
	    }
	}

}