<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Pricing Box Widget .
 *
 */
class Konta_Pricing extends Widget_Base {

	public function get_name() {
		return 'kontapricing';
	}

	public function get_title() {
		return __( 'Konta Pricing', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Pricing', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Project Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
				]
			]
		);

        $this->add_control(
			'make_it_active',
			[
				'label' 		=> __( 'Make It Active?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'konta' ),
				'label_off' 	=> __( 'No', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'plan',
			[
				'label'     => __( 'Plan', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 	=> __( 'Basic Plan', 'konta' ),
			]
        );
        $this->add_control(
			'priceing_plan',
			[
				'label'     => __( 'Price', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 	=> __( '<span class="h1 price">$299 <span class="currency">$</span></span><span class="package-duration">Per Month</span>', 'konta' ),
			]
        );
        $this->add_control(
			'features',
			[
				'label'     => __( 'Features', 'konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );
        $this->add_control(
			'bg',
			[
				'label' 		=> __( 'Choose image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'btn_txt',
			[
				'label'     => __( 'Butto Text', 'konta' ),
                'type'      => Controls_Manager::TEXT,
                'default' 	=> __( 'CHOOSE PLAN', 'konta' ),
			]
        );
        $this->add_control(
			'btn_url',
			[
				'label'     => __( 'Button Url', 'konta' ),
                'type'      => Controls_Manager::TEXT,
                'rows' 		=> 2,
                'default' 	=> __( '#', 'konta' ),
			]
        );

        $this->end_controls_section();

        /*-----------------------------------------GENERAL styling------------------------------------*/

        $this->start_controls_section(
			'basic_styling',
			[
				'label' 	=> __( 'General Styling', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'general_color',
			[
				'label' 		=> __( 'Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-box, {{WRAPPER}} .price-card'	=> 'background-color: {{VALUE}}!important;',
				]
			]
        );    

        $this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Box Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .price-box, {{WRAPPER}} .price-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);    
        $this->add_control(
			'plan_bg_color',
			[
				'label' 		=> __( 'Plan BG Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-card_title'	=> 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .price-box_title'	=> 'border-color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_control(
			'price_color',
			[
				'label' 		=> __( 'Price Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-card_price .price, {{WRAPPER}} .price-box_price'	=> '--theme-color: {{VALUE}}!important;',
				]
			]
        );
        $this->end_controls_section();

        $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn:before, {{WRAPPER}} .as-btn:after' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .as-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Border Hover', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .as-btn:hover',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .as-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'konta' ),
				'selector' => '{{WRAPPER}} .as-btn',
			]
		);
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if($settings['make_it_active'] == 'yes'){
        	$active_class = 'active';
        }else{
        	$active_class = 'normal';
        }

        if($settings['layout_style'] == 'layout_one' ){

        	echo '<div class="price-card '.esc_attr($active_class).'">';
        		if( ! empty( $settings['bg']['url'] ) ){
	                echo '<div class="price-card-bg-shape">';
	                    echo konta_img_tag( array(
							'url'   => esc_url( $settings['bg']['url'] ),
						) );
	                echo '</div>';
	            }
                echo '<div class="price-card_top">';
                    echo '<h3 class="price-card_title">'.esc_html( $settings['plan'] ).'</h3>';
                    echo '<h4 class="price-card_price">'.wp_kses_post( $settings['priceing_plan'] ).'</h4>';
                echo '</div>';
                echo '<div class="price-card_content">';
                    if( ! empty( $settings['features'] ) ){
					    echo '<div class="checklist style7">';
					      echo wp_kses_post( $settings['features'] );  
					    echo '</div>';
					}
                    if( ! empty( $settings['btn_txt'] ) ){
	                    echo '<a href="'.esc_url( $settings['btn_url'] ).'" class="th-btn style3">'.esc_html( $settings['btn_txt'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
	                }
                echo '</div>';
            echo '</div>';
        }

	}
}