<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Konta_Section_Title_Widget extends Widget_Base {

	public function get_name() {
		return 'kontasectiontitle';
	}

	public function get_title() {
		return __( 'Section Title', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Section Title', 'konta' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
            'layout_style',
            [
                'label' => __('Select Layout', 'konta'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' 	=> __('Layout One', 'konta'),
                    'layout_two' 	=> __('Layout Two', 'konta'),
                    'layout_three' 	=> __('Layout Three', 'konta'),
                    'layout_four' 	=> __('Layout Four', 'konta'),
                    'layout_five' 	=> __('Layout Five', 'konta'),
                ]
            ]
        );
		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        
        $this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'konta' ),
			]
        );

        $this->add_control(
			'section_subtitle_tag',
			[
				'label' 	=> __( 'Subitle Tag', 'konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'p'  => 'P',
					'span'  => 'span',
				],
				'default' 	=> 'span',
				'condition'	=> ['section_subtitle!' => '']
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'konta' )
			]
        );
        $this->add_control(
			'section_title_tag',
			[
				'label' 	=> __( 'Title Tag', 'konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'span'  => 'span',
				],
				'default' => 'h2',
			]
        );
		$this->add_control(
			'section_description',
			[
				'label' 	=> __( 'Section Description', 'konta' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Description', 'konta' )
			]
        );
        $this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Alignment', 'konta' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'konta' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'konta' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'konta' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'left',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'text-align: {{VALUE}};',
                ]
			]
		);

        $this->end_controls_section();

       

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Section Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                    'section_title!'    => ''
                ]
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one' ,'layout_two' ,'layout_three', 'layout_four', 'layout_five'] );

        $this->end_controls_section();


        //-------------------------------------subtitle styling-------------------------------------//

        $this->start_controls_section(
			'section_subtitle_style_section',
			[
				'label' => __( 'Section Subtitle Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition' => [
                    'section_subtitle!'    => ''
                ],
			]
		);
		konta_all_elementor_style($this, 'Subtitle', '{{WRAPPER}} .subtitle-selector',['layout_one' ,'layout_two' ,'layout_three', 'layout_four', 'layout_five'] );

		
        $this->end_controls_section();

        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Section Description Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                    'section_description!'    => ''
                ]
			]
		);
		konta_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_one' ,'layout_two' ,'layout_three', 'layout_four', 'layout_five'] );

		
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( ! empty( $settings['section_description'] ) ){
        	$this->add_render_attribute( 'wrapper', 'class', 'title-area mb-30' );
        }else{
        	$this->add_render_attribute( 'wrapper', 'class', 'title-area mb-md-0' );
        }

        if( $settings['layout_style'] == 'layout_one' ){
        	$sub_title = 'sub-title';
        	$sec_title = '';
        }elseif( $settings['layout_style'] == 'layout_two' ){
        	$sub_title = 'sub-title2';
        	$sec_title = '';
        }elseif( $settings['layout_style'] == 'layout_three' ){
        	$sub_title = 'sub-title3';
        	$sec_title = '';
        }elseif( $settings['layout_style'] == 'layout_four' ){
        	$sub_title = 'sub-title4';
        	$sec_title = 'fw-semibold';
        }else{
        	$sub_title = 'sub-title5';
        	$sec_title = 'fw-semibold';
        }

        echo '<div '.$this->get_render_attribute_string( 'wrapper' ).' >';
        	if( !empty( $settings['section_subtitle'] ) ) {
	            echo '<'.esc_attr($settings['section_subtitle_tag']).' class=" '.esc_attr( $sub_title ).' subtitle-selector">';
	            	if( !empty( $settings['image']['url'] ) ) {
		                echo konta_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
							'class' => 'icon',
						) );
		            }
	                echo wp_kses_post( $settings['section_subtitle'] );
	            echo '</'.esc_attr($settings['section_subtitle_tag']).'>';
	        }
	        if( ! empty( $settings['section_title'] ) ) {
	            echo '<'.esc_attr($settings['section_title_tag']).' class="sec-title '.esc_attr( $sec_title ).' title-selector">'.wp_kses_post( $settings['section_title'] ).'</'.esc_attr($settings['section_title_tag']).'>';
	        }
	    echo '</div>';
        if( ! empty( $settings['section_description'] ) ){
			echo konta_paragraph_tag( array(
				'text'	=> wp_kses_post( $settings['section_description'] ),
				'class'	=> 'desc-selector'
			) );
		}
        
        	
	}
}