<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Service Widget .
 *
 */
class Konta_Service extends Widget_Base {

	public function get_name() {
		return 'kontaservice';
	}

	public function get_title() {
		return __( 'Konta Service', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Service Slider', 'konta' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Service Style', 'konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'layout_one',
				'options' 	=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
					'layout_five'  		=> __( 'Style Five', 'konta' ),
					'layout_six'  		=> __( 'Style Six', 'konta' ),
				],
			]
		);
		
		$repeater = new Repeater();

        $repeater->add_control(
			'service_slider_image',
			[
				'label'     => __( 'Service Slider Image', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Neurology Specialist' , 'konta' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'konta' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
            'button_url',
            [
                'label'         => __( 'Details Url', 'konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'rows' 			=> 2,
				'default'		=> '#'
            ]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Service Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['layout_style' => ['layout_one']]
			]
		);

		//-------------------------------------------style 2-------------------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Neurology Specialist' , 'konta' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'konta' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'konta_tab_builder_option',
			[
				'label'     => __( 'Tab Name', 'konta' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->konta_service_choose_option(),
				'default'	=> ''
			]
		);
		$repeater->add_control(
            'button_text',
            [
                'label'         => __( 'Button Text', 'driller' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'rows' 			=> 2,
				'default'		=> __( 'View Details','driller' )
            ]
        );
        $repeater->add_control(
            'button_url',
            [
                'label'         => __( 'Details Url', 'konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'rows' 			=> 2,
                'label_block'   => true,
				'default'		=> '#'
            ]
        );

		$this->add_control(
			'slides2',
			[
				'label' 		=> __( 'Service Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['layout_style' => ['layout_two', 'layout_four', 'layout_six']]
			]
		);

		
		//-------------------------------------------style 3-------------------------------------------//

		$repeater = new Repeater();

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Neurology Specialist' , 'konta' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'konta_tab_builder_option',
			[
				'label'     => __( 'Tab Name', 'konta' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->konta_service_choose_option(),
				'default'	=> ''
			]
		);
		$repeater->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'service_slider_image',
			[
				'label'     => __( 'Service Image', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'konta' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
            'button_text',
            [
                'label'         => __( 'Button Text', 'driller' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'rows' 			=> 2,
				'default'		=> __( 'View Details','driller' )
            ]
        );


		$this->add_control(
			'slides3',
			[
				'label' 		=> __( 'Service Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['layout_style' => ['layout_three']]
			]
		);
		//-------------------------------------------style 4-------------------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'service_slider_image',
			[
				'label'     => __( 'Service Image', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Neurology Specialist' , 'konta' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'konta' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'konta' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
            'button_text',
            [
                'label'         => __( 'Button Text', 'driller' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'rows' 			=> 2,
				'default'		=> __( 'View Details','driller' )
            ]
        );
        $repeater->add_control(
            'button_url',
            [
                'label'         => __( 'Details Url', 'konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'rows' 			=> 2,
                'label_block'   => true,
				'default'		=> '#'
            ]
        );

		$this->add_control(
			'slides4',
			[
				'label' 		=> __( 'Service Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['layout_style' => ['layout_five']]
			]
		);
		$this->add_control(
			'service_shape',
			[
				'label'     => __( 'Service Shape', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['layout_one', 'layout_two']]
			]
		);
		$this->add_control(
			'service_shape2',
			[
				'label'     => __( 'Service Shape 2', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);
		$this->add_control(
			'make_slider',
			[
				'label' 		=> __( 'Make it slider?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);

        $this->end_controls_section();


        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one','layout_two' , 'layout_three', 'layout_four','layout_six'] );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Description Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_one','layout_two' , 'layout_three', 'layout_four','layout_six'] );

        $this->end_controls_section();

        //-------------------------------------------button-------------------------------------------//

        $this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		        'condition'	=> ['layout_style' => ['layout_two']]
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn.style10', ['layout_two']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn.style10', ['layout_two']);
					konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .th-btn.style10', ['layout_two'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn.style10', ['layout_two']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn.style10:hover', ['layout_two']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn.style10:before, {{WRAPPER}} .th-btn.style10:after', ['layout_two'], 'background-color');
					konta_elementor_border_style($this, 'Button Hover', '{{WRAPPER}} .th-btn.style10:hover', ['layout_two']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function konta_service_choose_option(){

		$konta_post_query = new WP_Query( array(
			'post_type'				=> 'konta_service',
			'posts_per_page'	    => -1,
		) );

		$konta_service_title = array();
		$konta_service_title[''] = __( 'Select a Service','Ventix');

		while( $konta_post_query->have_posts() ) {
			$konta_post_query->the_post();
			$konta_service_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();

		return $konta_service_title;

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
   
		if( $settings['layout_style'] == 'layout_one' ){

			echo '<div class="row th-carousel" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2">';

				$shape = $settings['service_shape']['url'] ? $settings['service_shape']['url'] : '#';
				foreach( $settings['slides'] as $service_slider ){
	                echo '<div class="col-md-6 col-xl-4">';
	                    echo '<div class="service-card">';
	                        echo '<div class="service-card-content" data-bg-src="'.esc_url( $shape ).'">';
	                        	if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
			                        echo '<div class="service-card-icon">';
			                            echo konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
										) );
			                        echo '</div>';
			                    }
			                    if( ! empty( $service_slider['service_title'] ) ){
		                            echo '<h3 class="box-title title-selector"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
		                        }
		                        if( ! empty( $service_slider['service_description'] ) ){
		                            echo '<p class="service-card-text desc-selector">'.esc_html( $service_slider['service_description'] ).'</p>';
		                        }
	                        echo '</div>';
	                        if( ! empty( $service_slider['service_slider_image']['url'] ) ){
		                        echo '<div class="service-card-img">';
		                           	echo konta_img_tag( array(
										'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
									) );
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_two' ){
			if(!empty( $settings['make_slider'])) {
				echo '<div class="row gy-4 th-carousel arrow-style3 arrow-wrap" data-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-arrows="true">';
				$anim = 'jump-reverse';
			}else{
				echo '<div class="row gy-4">';
				$anim = '';
			}
                $shape = $settings['service_shape']['url'] ? $settings['service_shape']['url'] : '#';

                $i = 0;
				foreach( $settings['slides2'] as $service_slider ){
					$i++;
					$k = str_pad($i, 2, '0', STR_PAD_LEFT);
	                echo '<div class="col-md-6 col-lg-4">';
	                    echo '<div class="service-card style2">';
	                        echo '<div class="service-card-bg-img" data-bg-src="'.esc_url( $shape ).'"></div>';
	                        echo '<div class="service-content">';
	                            if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
			                        echo '<div class="service-card-icon">';
			                            echo konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
										) );
			                        echo '</div>';
			                    }
	                            if( ! empty( $service_slider['service_title'] ) ){
		                            echo '<h3 class="box-title title-selector"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
		                        }
	                            echo '<div class="service-card-number"> '.esc_html($k).' </div>';
	                        echo '</div>';
	                        if( ! empty( $service_slider['service_description'] ) ){
	                            echo '<p class="service-card-text desc-selector">'.esc_html( $service_slider['service_description'] ).'</p>';
	                        }
	                        if( ! empty( $service_slider['button_text'] ) ){
		                        echo '<a class="th-btn style10" href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['button_text'] ).' <i class="fas fa-arrow-right ms-1"></i></a>';
		                    }
	                        if( ! empty( $settings['service_shape2']['url'] ) ){
		                        echo '<div class="service-card-shape '.esc_attr( $anim ).'">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $settings['service_shape2']['url'] ),
									) );
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }

            echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_three' ){
			echo '<div class="row gy-4 justify-content-center">';
                foreach( $settings['slides3'] as $service_slider ){

                	$elementor = \Elementor\Plugin::instance();
					if( ! empty( $service_slider['konta_tab_builder_option'] ) ){
						$title      = $service_slider['konta_tab_builder_option'];
               

	                    $replace        = array(' ');
	                    $with           = array('-');

	                    
	                    $value       = str_replace( $replace, $with, $title ); 

					}
	                echo '<div class="col-xl-6">';
	                    echo '<div class="service-card style3">';
	                    	if( ! empty( $service_slider['service_slider_image']['url'] ) ){
		                        echo '<div class="service-card-thumb">';
		                            echo konta_img_tag( array(
										'url'   => esc_url(  $service_slider['service_slider_image']['url'] ),
									) );
									if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
			                            echo '<div class="service-card-icon">';
			                                echo konta_img_tag( array(
												'url'   => esc_url(  $service_slider['service_slider_icon_image']['url'] ),
											) );
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                    }
	                        echo '<div class="service-card-content">';

	                            echo '<h3 class="box-title title-selector" data-bs-toggle="modal" data-bs-target="#servic-'.esc_attr($value).'">'.esc_html($service_slider['service_title']).'</h3>';
	                            if( ! empty( $service_slider['service_description'] ) ){
		                            echo '<p class="service-card-text desc-selector">'.esc_html( $service_slider['service_description'] ).'</p>';
		                        }
		                        if( ! empty( $service_slider['button_text'] ) ){
		                            echo '<a class="link-btn style2" href="#" data-bs-toggle="modal" data-bs-target="#servic-'.esc_attr($value).'">'.esc_html( $service_slider['button_text'] ).'<i class="far fa-arrow-right"></i></a>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';

            foreach( $settings['slides3'] as $service_slider ){

            	
				if( ! empty( $service_slider['konta_tab_builder_option'] ) ){
					$title      = $service_slider['konta_tab_builder_option'];
           

                    $replace        = array(' ');
                    $with           = array('-');

                    
                    $value       = str_replace( $replace, $with, $title ); 

				}
	            echo '<div class="th-modal modal fade" id="servic-'.esc_attr($value).'" tabindex="-1" aria-labelledby="serviceModalLabel" aria-hidden="true">';
			        echo '<div class="modal-dialog modal-xl">';
			            echo '<div class="modal-content">';
			                echo '<button type="button" class="icon-btn btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-regular fa-xmark"></i></button>';
			                echo '<div class="page-single">';

			                    $elementor = \Elementor\Plugin::instance();
								if( ! empty( $service_slider['konta_tab_builder_option'] ) ){
								    echo $elementor->frontend->get_builder_content_for_display( $service_slider['konta_tab_builder_option'] );
								}
			                    
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    echo '</div>';
			}
		}elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="feature-area-2 ">';
	            echo '<div class="row th-carousel g-0 justify-content-center" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2">';
	            	$i = 0;
	                foreach( $settings['slides2'] as $service_slider ){
	                	$i++;
	                	$active = $i == 2 ? 'feature-card2-active' : '';

		                echo '<!-- Single Item -->';
		                echo '<div class="col-lg-4 col-md-6">';
		                    echo '<div class="feature-card2 '.esc_attr( $active ).'">';
		                    	if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
			                        echo '<div class="feature-card2-icon">';
			                            echo konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
										) );
			                        echo '</div>';
			                    }
		                        echo '<div class="media-body">';
		                        	if( ! empty( $service_slider['service_title'] ) ){
			                            echo '<h3 class="box-title title-selector"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
			                        }
			                        if( ! empty( $service_slider['service_description'] ) ){
			                            echo '<p class="feature-card2-text desc-selector">'.esc_html( $service_slider['service_description'] ).'</p>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
	        echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="service-tab-1 th-carousel row arrow-style4 g-0" data-slide-show="4" data-ml-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true" id="serviceTab-1" data-asnavfor="#service-tab-content">';

				foreach( $settings['slides4'] as $service_slider ){
	                echo '<div class="col-lg-3">';
	                    echo '<a class="tab-btn">';
	                    	if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
		                        echo '<span class="icon"><img src="'.esc_url( $service_slider['service_slider_icon_image']['url'] ).'" alt="img"></span>';
		                    }

	                        echo '<span class="details">';
	                        	if( ! empty( $service_slider['service_title'] ) ){
		                            echo '<span class="box-title">'.esc_html( $service_slider['service_title'] ).'</span>';
		                        }
	                        echo '</span>';
	                    echo '</a>';
	                echo '</div>';
	            }
                
            echo '</div>';
            echo '<div class="th-carousel" data-fade="true" id="service-tab-content" data-adaptive-height="true" data-asnavfor="#serviceTab-1">';

                foreach( $settings['slides4'] as $service_slider ){
	                echo '<div>';
	                    echo '<div class="service4-content-wrap">';
	                        echo '<div class="row">';
	                            echo '<div class="col-lg-6">';
	                                echo '<div class="service-content">';
	                                	if( ! empty( $service_slider['service_title'] ) ){
				                            echo '<h3 class="service-title">'.esc_html( $service_slider['service_title'] ).'</h3>';
				                        }
				                        if( ! empty( $service_slider['service_description'] ) ){
				                            echo wp_kses_post( $service_slider['service_description'] );
				                        }
				                        if( ! empty( $service_slider['button_text'] ) ){
					                        echo '<a href="'.esc_url( $service_slider['button_url'] ).'" class="th-btn style2" tabindex="0">'.esc_html( $service_slider['button_text'] ).' <i class="fas fa-arrow-right ms-2"></i></a>';
					                    }
	                                echo '</div>';
	                            echo '</div>';
	                            echo '<div class="col-lg-6">';
	                            	if( ! empty( $service_slider['service_slider_image']['url'] ) ){
				                        echo '<div class="service-img">';
				                            echo konta_img_tag( array(
												'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
											) );
				                        echo '</div>';
				                    }
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            } 
            echo '</div>';
		}else{
			echo '<div class="row gy-4">';
				foreach( $settings['slides2'] as $service_slider ){
					$elementor = \Elementor\Plugin::instance();
					if( ! empty( $service_slider['konta_tab_builder_option'] ) ){
						$title      = $service_slider['konta_tab_builder_option'];
	                    $replace        = array(' ');
	                    $with           = array('-');
	                    $value       = str_replace( $replace, $with, $title ); 
					}
	                        
	                echo '<div class="col-md-6">';
	                    echo '<div class="service-card style5">';
	                    	if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
		                        echo '<div class="service-card-icon">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
									) );
		                        echo '</div>';
		                    }

	                        echo '<div class="service-card-content">';
	                            echo '<h3 class="box-title title-selector" data-bs-toggle="modal" data-bs-target="#servic-'.esc_attr($value).'">'.esc_html($service_slider['service_title']).'</h3>';
	                            if( ! empty( $service_slider['service_description'] ) ){
		                            echo '<p class="service-card-text desc-selector">'.esc_html( $service_slider['service_description'] ).'</p>';
		                        }
		                        if( ! empty( $service_slider['button_text'] ) ){
		                            echo '<a class="link-btn style2" href="#" data-bs-toggle="modal" data-bs-target="#servic-'.esc_attr($value).'">'.esc_html( $service_slider['button_text'] ).'<i class="far fa-arrow-right"></i></a>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }

            echo '</div>';

            foreach( $settings['slides2'] as $service_slider ){

            	
				if( ! empty( $service_slider['konta_tab_builder_option'] ) ){
					$title      = $service_slider['konta_tab_builder_option'];
           

                    $replace        = array(' ');
                    $with           = array('-');

                    
                    $value       = str_replace( $replace, $with, $title ); 

				}
	            echo '<div class="th-modal modal fade" id="servic-'.esc_attr($value).'" tabindex="-1" aria-labelledby="serviceModalLabel" aria-hidden="true">';
			        echo '<div class="modal-dialog modal-xl">';
			            echo '<div class="modal-content">';
			                echo '<button type="button" class="icon-btn btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-regular fa-xmark"></i></button>';
			                echo '<div class="page-single">';

			                    $elementor = \Elementor\Plugin::instance();
								if( ! empty( $service_slider['konta_tab_builder_option'] ) ){
								    echo $elementor->frontend->get_builder_content_for_display( $service_slider['konta_tab_builder_option'] );
								}
			                    
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    echo '</div>';
			}


		}
	}

}

