<?php
    /**
     * Class For Builder
     */
    class KontaBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'konta_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'konta-core',KONTA_PLUGDIRURI.'assets/js/konta-core.js',array( 'jquery' ),'1.0',true );
		}


        public function konta_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'konta_header_option',
                [
                    'label'     => __( 'Header Option', 'konta' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'konta_header_style',
                [
                    'label'     => __( 'Header Option', 'konta' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'konta' ),
    					'header_builder'       => __( 'Header Builder', 'konta' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'konta_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'konta' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->konta_header_choose_option(),
                    'condition' => [ 'konta_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'konta_footer_option',
                [
                    'label'     => __( 'Footer Option', 'konta' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'konta_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'konta' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'konta' ),
    				'label_off'     => __( 'No', 'konta' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'konta_footer_style',
                [
                    'label'     => __( 'Footer Style', 'konta' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'konta' ),
    					'footer_builder'       => __( 'Footer Builder', 'konta' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'konta_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'konta_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'konta' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->konta_footer_build_choose_option(),
                    'condition' => [ 'konta_footer_style' => 'footer_builder','konta_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Konta Builder', 'konta' ),
            	esc_html__( 'Konta Builder', 'konta' ),
				'manage_options',
				'konta',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('konta', esc_html__('Footer Builder', 'konta'), esc_html__('Footer Builder', 'konta'), 'manage_options', 'edit.php?post_type=konta_footerbuild');
			add_submenu_page('konta', esc_html__('Header Builder', 'konta'), esc_html__('Header Builder', 'konta'), 'manage_options', 'edit.php?post_type=konta_header');
			add_submenu_page('konta', esc_html__('Tab Builder', 'konta'), esc_html__('Tab Builder', 'konta'), 'manage_options', 'edit.php?post_type=konta_tab_builder');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','konta' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'konta' ),
				'singular_name'      => __( 'Footer', 'konta' ),
				'menu_name'          => __( 'Konta Footer Builder', 'konta' ),
				'name_admin_bar'     => __( 'Footer', 'konta' ),
				'add_new'            => __( 'Add New', 'konta' ),
				'add_new_item'       => __( 'Add New Footer', 'konta' ),
				'new_item'           => __( 'New Footer', 'konta' ),
				'edit_item'          => __( 'Edit Footer', 'konta' ),
				'view_item'          => __( 'View Footer', 'konta' ),
				'all_items'          => __( 'All Footer', 'konta' ),
				'search_items'       => __( 'Search Footer', 'konta' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'konta' ),
				'not_found'          => __( 'No Footer found.', 'konta' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'konta' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'konta_footerbuild', $args );

			$labels = array(
				'name'               => __( 'Header', 'konta' ),
				'singular_name'      => __( 'Header', 'konta' ),
				'menu_name'          => __( 'Konta Header Builder', 'konta' ),
				'name_admin_bar'     => __( 'Header', 'konta' ),
				'add_new'            => __( 'Add New', 'konta' ),
				'add_new_item'       => __( 'Add New Header', 'konta' ),
				'new_item'           => __( 'New Header', 'konta' ),
				'edit_item'          => __( 'Edit Header', 'konta' ),
				'view_item'          => __( 'View Header', 'konta' ),
				'all_items'          => __( 'All Header', 'konta' ),
				'search_items'       => __( 'Search Header', 'konta' ),
				'parent_item_colon'  => __( 'Parent Header:', 'konta' ),
				'not_found'          => __( 'No Header found.', 'konta' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'konta' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'konta_header', $args );

			$labels = array(
				'name'               => __( 'Tab Builder', 'konta' ),
				'singular_name'      => __( 'Tab Builder', 'konta' ),
				'menu_name'          => __( 'Gesund Tab Builder', 'konta' ),
				'name_admin_bar'     => __( 'Tab Builder', 'konta' ),
				'add_new'            => __( 'Add New', 'konta' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'konta' ),
				'new_item'           => __( 'New Tab Builder', 'konta' ),
				'edit_item'          => __( 'Edit Tab Builder', 'konta' ),
				'view_item'          => __( 'View Tab Builder', 'konta' ),
				'all_items'          => __( 'All Tab Builder', 'konta' ),
				'search_items'       => __( 'Search Tab Builder', 'konta' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'konta' ),
				'not_found'          => __( 'No Tab Builder found.', 'konta' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'konta' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'konta_tab_builder', $args );
		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'konta_footerbuild' == $post->post_type || 'konta_header' == $post->post_type || 'konta_tab_builder' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function konta_footer_build_choose_option(){

			$konta_post_query = new WP_Query( array(
				'post_type'			=> 'konta_footerbuild',
				'posts_per_page'	    => -1,
			) );

			$konta_builder_post_title = array();
			$konta_builder_post_title[''] = __('Select a Footer','konta');

			while( $konta_post_query->have_posts() ) {
				$konta_post_query->the_post();
				$konta_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $konta_builder_post_title;

		}

		public function konta_header_choose_option(){

			$konta_post_query = new WP_Query( array(
				'post_type'			=> 'konta_header',
				'posts_per_page'	    => -1,
			) );

			$konta_builder_post_title = array();
			$konta_builder_post_title[''] = __('Select a Header','konta');

			while( $konta_post_query->have_posts() ) {
				$konta_post_query->the_post();
				$konta_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $konta_builder_post_title;

        }

    }

    $builder_execute = new KontaBuilder();