<?php
/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( !defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) ) {
        $konta404title     = konta_opt( 'konta_error_title' );
        $konta404description  = konta_opt( 'konta_error_description' );
        $konta404btntext      = konta_opt( 'konta_error_btn_text' );
    } else {
        $konta404title     = __( '<span class="text-theme">OooPs!</span> Page Not Found', 'konta' );
        $konta404description  = __( 'The page you are looking for does not exist. It might have been moved or deleted.', 'konta' );
        $konta404btntext      = __( ' Back To Home', 'konta');

    }

    // get header //
    get_header(); ?>

    <section class="space">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="error-page text-center">
                        <div class="error-content">
                            <div class="error-img mb-50">
                                <?php if(!empty(konta_opt('konta_error_img', 'url' ) )): ?>
                                    <img src="<?php echo esc_url( konta_opt('konta_error_img', 'url' ) ) ?>" alt="<?php echo esc_attr__('404 image', 'konta'); ?>">
                                <?php else: ?>
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/error.png" alt="<?php echo esc_attr__('404 image', 'konta'); ?>">
                                <?php endif; ?>
                            </div>
                            <h2 class="error-title mb-20"><?php echo wp_kses_post( $konta404title ); ?></h2>
                            <p class="error-text mb-30"><?php echo esc_html( $konta404description ); ?></p>
                            <a href="<?php echo esc_url( home_url('/') ); ?>" class="th-btn"><i class="fal fa-home me-2"></i><?php echo esc_html( $konta404btntext ); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <?php
    //footer
    get_footer();