<?php
/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }


    // preloader hook function
    if( ! function_exists( 'konta_preloader_wrap_cb' ) ) {
        function konta_preloader_wrap_cb() {
            $preloader_display              =  konta_opt('konta_display_preloader');
            ?>
            <div class="th-cursor"></div>
            <?php
            if( class_exists('ReduxFramework') ){
                if( $preloader_display ){?>
                    <div class="preloader ">
                        <button class="th-btn style3 preloaderCls"><?php echo esc_html__( 'Cancel Preloader', 'konta' ) ?></button>
                        <div class="preloader-inner">
                            <?php

                            if( ! empty( konta_opt( 'konta_preloader_img','url' ) ) ){
                                echo konta_img_tag( array(
                                    'url'   => esc_url( konta_opt( 'konta_preloader_img','url' ) ),
                                ) );  
                               
                            }
							 echo '<span class="loader"></span>';
                            ?>
                        </div>
                    </div>
                <?php }
            }else{ ?>
                <div class="preloader ">
                    <button class="th-btn style3 preloaderCls"><?php echo esc_html__( 'Cancel Preloader', 'konta' ) ?></button>
                    <div class="preloader-inner">
                        <span class="loader"></span>
                    </div>
                </div>
            <?php }
        }
    }

    // Header Hook function
    if( !function_exists('konta_header_cb') ) { 
        function konta_header_cb( ) {
            get_template_part('templates/header');
            get_template_part('templates/header-menu-bottom');
        }
    }

    // back top top hook function
    if( ! function_exists( 'konta_back_to_top_cb' ) ) {
        function konta_back_to_top_cb( ) {
            $backtotop_trigger = konta_opt('konta_display_bcktotop');
            if( class_exists( 'ReduxFramework' ) ) {
                if( $backtotop_trigger ) {
            	?>
                    <div class="scroll-top">
                        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
                            </path>
                        </svg>
                    </div>
                <?php 
                }
            }

        }
    }

    // Blog Start Wrapper Function
    if( !function_exists('konta_blog_start_wrap_cb') ) {
        function konta_blog_start_wrap_cb() { ?>
            <section class="th-blog-wrapper space-top space-extra-bottom arrow-wrap">
                <div class="container">
                    <div class="row gx-40">
        <?php }
    }

    // Blog End Wrapper Function
    if( !function_exists('konta_blog_end_wrap_cb') ) {
        function konta_blog_end_wrap_cb() {?>
                    </div>
                </div>
            </section>
        <?php }
    }

    // Blog Column Start Wrapper Function
    if( !function_exists('konta_blog_col_start_wrap_cb') ) {
        function konta_blog_col_start_wrap_cb() {
            if( class_exists('ReduxFramework') ) {
                $konta_blog_sidebar = konta_opt('konta_blog_sidebar');
                if( $konta_blog_sidebar == '2' && is_active_sidebar('konta-blog-sidebar') ) {
                    echo '<div class="col-xl-8 col-lg-7 order-lg-last">';
                } elseif( $konta_blog_sidebar == '3' && is_active_sidebar('konta-blog-sidebar') ) {
                    echo '<div class="col-xl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('konta-blog-sidebar') ) {
                    echo '<div class="col-xl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }
    // Blog Column End Wrapper Function
    if( !function_exists('konta_blog_col_end_wrap_cb') ) {
        function konta_blog_col_end_wrap_cb() {
            echo '</div>';
        }
    }

    // Blog Sidebar
    if( !function_exists('konta_blog_sidebar_cb') ) {
        function konta_blog_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_blog_sidebar = konta_opt('konta_blog_sidebar');
            } else {
                $konta_blog_sidebar = 2;
                
            }
            if( $konta_blog_sidebar != 1 && is_active_sidebar('konta-blog-sidebar') ) {
                // Sidebar
                get_sidebar();
            }
        }
    }


    if( !function_exists('konta_blog_details_sidebar_cb') ) {
        function konta_blog_details_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_blog_single_sidebar = konta_opt('konta_blog_single_sidebar');
            } else {
                $konta_blog_single_sidebar = 4;
            }
            if( $konta_blog_single_sidebar != 1 ) {
                // Sidebar
                get_sidebar();
            }

        }
    }

    // Blog Pagination Function
    if( !function_exists('konta_blog_pagination_cb') ) {
        function konta_blog_pagination_cb( ) {
            get_template_part('templates/pagination');
        }
    }

    // Blog Content Function
    if( !function_exists('konta_blog_content_cb') ) {
        function konta_blog_content_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_blog_grid = konta_opt('konta_blog_grid');
            } else {
                $konta_blog_grid = '1';
            }

            if( $konta_blog_grid == '1' ) {
                $konta_blog_grid_class = 'col-lg-12';
            } elseif( $konta_blog_grid == '2' ) {
                $konta_blog_grid_class = 'col-sm-6';
            } else {
                $konta_blog_grid_class = 'col-lg-4 col-sm-6';
            }

            echo '<div class="row">';
                if( have_posts() ) {
                    while( have_posts() ) {
                        the_post();
                        echo '<div class="'.esc_attr($konta_blog_grid_class).'">';
                            get_template_part('templates/content',get_post_format());
                        echo '</div>';
                    }
                    wp_reset_postdata();
                } else{
                    get_template_part('templates/content','none');
                }
            echo '</div>';
        }
    }

    // footer content Function
    if( !function_exists('konta_footer_content_cb') ) {
        function konta_footer_content_cb( ) {

            if( class_exists('ReduxFramework') && did_action( 'elementor/loaded' )  ){
                if( is_page() || is_page_template('template-builder.php') ) {
                    $post_id = get_the_ID();

                    // Get the page settings manager
                    $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

                    // Get the settings model for current post
                    $page_settings_model = $page_settings_manager->get_model( $post_id );

                    // Retrieve the Footer Style
                    $footer_settings = $page_settings_model->get_settings( 'konta_footer_style' );

                    // Footer Local
                    $footer_local = $page_settings_model->get_settings( 'konta_footer_builder_option' );

                    // Footer Enable Disable
                    $footer_enable_disable = $page_settings_model->get_settings( 'konta_footer_choice' );

                    if( $footer_enable_disable == 'yes' ){
                        if( $footer_settings == 'footer_builder' ) {
                            // local options
                            $konta_local_footer = get_post( $footer_local );
                            echo '<footer>';
                            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $konta_local_footer->ID );
                            echo '</footer>';
                        } else {
                            // global options
                            $konta_footer_builder_trigger = konta_opt('konta_footer_builder_trigger');
                            if( $konta_footer_builder_trigger == 'footer_builder' ) {
                                echo '<footer>';
                                $konta_global_footer_select = get_post( konta_opt( 'konta_footer_builder_select' ) );
                                $footer_post = get_post( $konta_global_footer_select );
                                echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                                echo '</footer>';
                            } else {
                                // wordpress widgets
                                konta_footer_global_option();
                            }
                        }
                    }
                } else {
                    // global options
                    $konta_footer_builder_trigger = konta_opt('konta_footer_builder_trigger');
                    if( $konta_footer_builder_trigger == 'footer_builder' ) {
                        echo '<footer>';
                        $konta_global_footer_select = get_post( konta_opt( 'konta_footer_builder_select' ) );
                        $footer_post = get_post( $konta_global_footer_select );
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                        echo '</footer>';
                    } else {
                        // wordpress widgets
                        konta_footer_global_option();
                    }
                }
            } else { ?>
                <div class="footer-layout4">
                    <div class="copyright-wrap bg-black">
                        <div class="container">
                            <p class="copyright-text text-center"><?php echo sprintf( 'Copyright <i class="fal fa-copyright"></i> %s <a href="%s">%s</a> All Rights Reserved by <a href="%s">%s</a>',date('Y'),esc_url('#'),__( 'Konta.','konta' ),esc_url('#'),__( 'Themeholy', 'konta' ) ) ?></p>
                        </div>
                    </div>
                </div>
            <?php }

        }
    }

    // blog details wrapper start hook function
    if( !function_exists('konta_blog_details_wrapper_start_cb') ) {
        function konta_blog_details_wrapper_start_cb( ) {
            echo '<section class="th-blog-wrapper blog-details space-top space-extra-bottom">';
                echo '<div class="container">';
                    if( is_active_sidebar( 'konta-blog-sidebar' ) ){
                        $konta_gutter_class = 'gx-60';
                    }else{
                        $konta_gutter_class = '';
                    }
                    // echo '<div class="row './/esc_attr( $konta_gutter_class ).'">';
                    echo '<div class="row gx-40">';
        }
    }

    // blog details column wrapper start hook function
    if( !function_exists('konta_blog_details_col_start_cb') ) {
        function konta_blog_details_col_start_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_blog_single_sidebar = konta_opt('konta_blog_single_sidebar');
                if( $konta_blog_single_sidebar == '2' && is_active_sidebar('konta-blog-sidebar') ) {
                    echo '<div class="col-xl-8 col-lg-7 order-last">';
                } elseif( $konta_blog_single_sidebar == '3' && is_active_sidebar('konta-blog-sidebar') ) {
                    echo '<div class="col-xl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('konta-blog-sidebar') ) {
                    echo '<div class="col-xl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }

    // blog details post meta hook function
    if( !function_exists('konta_blog_post_meta_cb') ) {
        function konta_blog_post_meta_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_display_post_author      =  konta_opt('konta_display_post_author');
                $konta_display_post_date      =  konta_opt('konta_display_post_date');
                $konta_display_post_cate   =  konta_opt('konta_display_post_cate');
                $konta_display_post_comments      =  konta_opt('konta_display_post_comments');
            } else {
                $konta_display_post_author      = '1';
                $konta_display_post_date      = '1';
                $konta_display_post_cate   = '1';
                $konta_display_post_comments      = '';
            }

                echo '<div class="blog-meta">';
                    if( $konta_display_post_author ){
                        echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fas fa-user"></i>'.esc_html__('By', 'konta').esc_html( ucwords( get_the_author() ) ).'</a>';
                    }
                    if( $konta_display_post_date ){
                        echo '<a href="'.esc_url( konta_blog_date_permalink() ).'"><i class="fa-solid fa-calendar-days"></i>'.esc_html( get_the_date() ).'</a>';
                    }
                    if( $konta_display_post_cate ){
                        $categories = get_the_category(); 
                        if(!empty($categories)){
                        echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'"><i class="fa-solid fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>';
                        }
                    }
                    if( $konta_display_post_comments ){
                        ?>
                        <a href="#"><i class="fas fa-comments"></i>
                            <?php 
                                if(get_comments_number() == 1){
                                    echo esc_html__('Comment (', 'konta'); 
                                }else{
                                    echo esc_html__('Comments (', 'konta'); 
                                }
                                echo get_comments_number(); ?>)</a>
                        <?php
                    }
                echo '</div>';
        }
    }

    // blog details share options hook function
    if( !function_exists('konta_blog_details_share_options_cb') ) {
        function konta_blog_details_share_options_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_post_details_share_options = konta_opt('konta_post_details_share_options');
            } else {
                $konta_post_details_share_options = false;
            }
            if( function_exists( 'konta_social_sharing_buttons' ) && $konta_post_details_share_options ) { ?>
                <div class="col-md-auto text-xl-end">
                    <span class="share-links-title"><?php echo esc_html__('Share:', 'konta') ?></span>
                    <div class="th-social style3">
                        <?php echo konta_social_sharing_buttons(); ?>
                    </div>
                </div>
            <?php }
        }
    }
    
    // blog details author bio hook function
    if( !function_exists('konta_blog_details_author_bio_cb') ) {
        function konta_blog_details_author_bio_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $postauthorbox =  konta_opt( 'konta_post_details_author_desc_trigger' );
            } else {
                $postauthorbox = '1';
            }
            if(  $postauthorbox == '1' ) {

                echo '<div class="blog-author">';
                        echo '<div class="auhtor-img">';
                            echo '<img src="'.esc_url( get_avatar_url( get_the_author_meta('ID') ) ).'" alt="img">';
                        echo '</div>';
                        echo '<div class="media-body">';
                            echo '<h3 class="author-name"><a href="#">'.esc_html( ucwords( get_the_author() )).'</a></h3>';
                            echo '<span class="author-desig">'.get_user_meta( get_the_author_meta('ID'), '_konta_author_desig',true ).'</span>';
                            echo '<p class="author-text">'.get_the_author_meta( 'user_description', get_the_author_meta('ID') ).'</p>';
                            echo '<div class="th-social style2 align-items-center">';
                                    $konta_social_icons = get_user_meta( get_the_author_meta('ID'), '_konta_social_profile_group',true );
                                    if(!empty($konta_social_icons)){
                                        foreach( $konta_social_icons as $singleicon ) {
                                            if( ! empty( $singleicon['_konta_social_profile_icon'] ) ) {
                                                echo '<a href="'.esc_url( $singleicon['_konta_lawyer_social_profile_link'] ).'"><i class="'.esc_attr( $singleicon['_konta_social_profile_icon'] ).'"></i></a>';
                                            }
                                        }
                                    }
                            echo '</div>';
                        echo '</div>';
             echo '</div>';

               
            }

        }
    }

     // Blog Details Post Navigation hook function
     if( !function_exists( 'konta_blog_details_post_navigation_cb' ) ) {
        function konta_blog_details_post_navigation_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_post_navigation = konta_opt('konta_post_details_post_navigation');
            } else {
                $konta_post_navigation = false;
            }

            $prevpost = get_previous_post();
            $nextpost = get_next_post();

            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );

            if( ($konta_post_navigation == '1') && (!empty($prevpost) || !empty($nextpost)) ) {
                echo '<div class="blog-navigation">';
                    if( ! empty( $prevpost ) ) {
                    echo '<div class="blog-prev">';
                        echo '<a href="'.esc_url( get_permalink( $prevpost->ID ) ).'" class="nav-btn prev">';
                                if (has_post_thumbnail( $prevpost->ID )) {
                                    echo '<div class="blog-image">';
                                        echo get_the_post_thumbnail( $prevpost->ID, 'konta_80X80' );
                                        echo '<i class="fa-regular fa-arrow-left"></i>';
                                    echo '</div>';
                                };
                            echo ' <span class="nav-text">'.get_the_title($prevpost->ID).'</span>';
                        echo '</a>';
                    echo '</div>';
                    }

                    if( ! empty( $nextpost ) ) {
                    echo '<div class="blog-next">';
                            echo '<a href="'.esc_url( get_permalink( $nextpost->ID ) ).'" class="nav-btn prev">';
                                echo ' <span class="nav-text">'.get_the_title($nextpost->ID).'</span>';
                                    if (has_post_thumbnail( $nextpost->ID )) {
                                        echo '<div class="blog-image">';
                                            echo get_the_post_thumbnail( $nextpost->ID, 'konta_80X80' );
                                            echo '<i class="fa-regular fa-arrow-right"></i>';
                                        echo '</div>';
                                    };
                            echo '</a>';
                    echo '</div>';
                    }
                echo '</div>';
            }
        }
    }

    // Blog Details Comments hook function
    if( !function_exists('konta_blog_details_comments_cb') ) {
        function konta_blog_details_comments_cb( ) {
            if ( ! comments_open() ) {
                echo '<div class="blog-comment-area">';
                    echo konta_heading_tag( array(
                        "tag"   => "h3",
                        "text"  => esc_html__( 'Comments are closed', 'konta' ),
                        "class" => "inner-title"
                    ) );
                echo '</div>';
            }

            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
        }
    }

    // Blog Details Column end hook function
    if( !function_exists('konta_blog_details_col_end_cb') ) {
        function konta_blog_details_col_end_cb( ) {
            echo '</div>';
        }
    }

    // Blog Details Wrapper end hook function
    if( !function_exists('konta_blog_details_wrapper_end_cb') ) {
        function konta_blog_details_wrapper_end_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page start wrapper hook function
    if( !function_exists('konta_page_start_wrap_cb') ) {
        function konta_page_start_wrap_cb( ) {
            
            if( is_page( 'cart' ) ){
                $section_class = "th-cart-wrapper space-top space-extra-bottom";
            }elseif( is_page( 'checkout' ) ){
                $section_class = "th-checkout-wrapper space-top space-extra-bottom";
            }elseif( is_page('wishlist') ){
                $section_class = "wishlist-area space-top space-extra-bottom";
            }else{
                $section_class = "space-top space-extra-bottom";  
            }
            echo '<section class="'.esc_attr( $section_class ).'">';
                echo '<div class="container">';
                    echo '<div class="row">';
        }
    }

    // page wrapper end hook function
    if( !function_exists('konta_page_end_wrap_cb') ) {
        function konta_page_end_wrap_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page column wrapper start hook function
    if( !function_exists('konta_page_col_start_wrap_cb') ) {
        function konta_page_col_start_wrap_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_page_sidebar = konta_opt('konta_page_sidebar');
            }else {
                $konta_page_sidebar = '1';
            }
            
            if( $konta_page_sidebar == '2' && is_active_sidebar('konta-page-sidebar') ) {
                echo '<div class="col-xl-8 col-lg-7 order-last">';
            } elseif( $konta_page_sidebar == '3' && is_active_sidebar('konta-page-sidebar') ) {
                echo '<div class="col-xl-8 col-lg-7">';
            } else {
                echo '<div class="col-lg-12">';
            }

        }
    }

    // page column wrapper end hook function
    if( !function_exists('konta_page_col_end_wrap_cb') ) {
        function konta_page_col_end_wrap_cb( ) {
            echo '</div>';
        }
    }

    // page sidebar hook function
    if( !function_exists('konta_page_sidebar_cb') ) {
        function konta_page_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $konta_page_sidebar = konta_opt('konta_page_sidebar');
            }else {
                $konta_page_sidebar = '1';
            }

            if( class_exists('ReduxFramework') ) {
                $konta_page_layoutopt = konta_opt('konta_page_layoutopt');
            }else {
                $konta_page_layoutopt = '3';
            }

            if( $konta_page_layoutopt == '1' && $konta_page_sidebar != 1 ) {
                get_sidebar('page');
            } elseif( $konta_page_layoutopt == '2' && $konta_page_sidebar != 1 ) {
                get_sidebar();
            }
        }
    }

    // page content hook function
    if( !function_exists('konta_page_content_cb') ) {
        function konta_page_content_cb( ) {
            if(  class_exists('woocommerce') && ( is_woocommerce() || is_cart() || is_checkout() || is_page('wishlist') || is_account_page() )  ) {
                echo '<div class="woocommerce--content">';
            } else {
                echo '<div class="page--content clearfix">';
            }

                the_content();

                // Link Pages
                konta_link_pages();

            echo '</div>';
            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }

        }
    }

    if( !function_exists('konta_blog_post_thumb_cb') ) {
        function konta_blog_post_thumb_cb( ) {
            if( get_post_format() ) {
                $format = get_post_format();
            }else{
                $format = 'standard';
            }

       

            $konta_post_slider_thumbnail = konta_meta( 'post_format_slider' );

            if( !empty( $konta_post_slider_thumbnail ) ){
                echo '<div class="blog-img">';
                    echo '<div class="th-blog-carousel arrow-wrap" data-overlay="black" data-opacity="5">';
                        foreach( $konta_post_slider_thumbnail as $single_image ){
                            echo konta_img_tag( array(
                                'url'   => esc_url( $single_image )
                            ) );
                        }
                    echo '</div>';
                echo '</div>';
            }elseif( has_post_thumbnail() && $format == 'standard' ) {
                echo '<!-- Post Thumbnail -->';
                echo '<div class="blog-img">';
                    if( ! is_single() ){
                        echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                    }

                    the_post_thumbnail();

                    if( ! is_single() ){
                        echo '</a>';
                    }
                echo '</div>';
                echo '<!-- End Post Thumbnail -->';
            }elseif( $format == 'video' ){
                if( has_post_thumbnail() && ! empty ( konta_meta( 'post_format_video' ) ) ){
                    echo '<div class="blog-img blog-video" data-overlay="black" data-opacity="5">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            the_post_thumbnail();

                        if( ! is_single() ){
                            echo '</a>';
                        }
                        echo '<a href="'.esc_url( konta_meta( 'post_format_video' ) ).'" class="play-btn popup-video style6">';
                            echo '<i class="fas fa-play"></i>';
                        echo '</a>';
                    echo '</div>';
                }elseif( ! has_post_thumbnail() && ! is_single() ){
                    echo '<div class="blog-video">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            echo konta_embedded_media( array( 'video', 'iframe' ) );
                        if( ! is_single() ){
                            echo '</a>';
                        }
                    echo '</div>';
                }
            }elseif( $format == 'audio' ){
                $konta_audio = konta_meta( 'post_format_audio' );
                if( ! empty( $konta_audio ) ){
                    echo '<div class="blog-audio">';
                        echo wp_oembed_get( $konta_audio );
                    echo '</div>';
                }elseif( ! is_single() ){
                    echo '<div class="blog-audio">';
                        echo wp_oembed_get( $konta_audio );
                    echo '</div>';
                }
            }

        }
    }

    if( !function_exists('konta_blog_post_content_cb') ) {
        function konta_blog_post_content_cb( ) {
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );
            if( class_exists( 'ReduxFramework' ) ) {
                $konta_excerpt_length          = konta_opt( 'konta_blog_postExcerpt' );
                $konta_display_post_category   = konta_opt( 'konta_display_post_category' );
            } else {
                $konta_excerpt_length          = '48';
                $konta_display_post_category   = '1';
            }

            if( class_exists( 'ReduxFramework' ) ) {
                $konta_blog_admin = konta_opt( 'konta_blog_post_author' );
                $konta_blog_readmore_setting_val = konta_opt('konta_blog_readmore_setting');
                if( $konta_blog_readmore_setting_val == 'custom' ) {
                    $konta_blog_readmore_setting = konta_opt('konta_blog_custom_readmore');
                } else {
                    $konta_blog_readmore_setting = __( 'Read More', 'konta' );
                }
            } else {
                $konta_blog_readmore_setting = __( 'Read More', 'konta' );
                $konta_blog_admin = true;
            }
            echo '<!-- blog-content -->';
                do_action( 'konta_blog_post_thumb' );
                
                echo '<div class="blog-content">';

                    // Blog Post Meta
                    do_action( 'konta_blog_post_meta' );

                    echo '<h2 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.wp_kses( get_the_title( ), $allowhtml ).'</a></h2>';

                    echo konta_paragraph_tag( array(
                        "text"  => wp_kses( wp_trim_words( get_the_excerpt(), $konta_excerpt_length, '' ), $allowhtml ),
                        "class" => 'blog-text',
                    ) );
  
                    if( !empty( $konta_blog_readmore_setting ) ){
                        echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn">'.esc_html( $konta_blog_readmore_setting ).'<i class="fa-solid fa-right-long ms-2"></i></a>';
                    }

                echo '</div>';
            echo '<!-- End Post Content -->';
        }
    }
