<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

// enqueue css
function konta_common_custom_css(){
    wp_enqueue_style( 'konta-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = konta_opt( 'konta_css_editor' );
    if( $CustomCssOpt ){
        $CustomCssOpt = $CustomCssOpt;
    }else{
        $CustomCssOpt = '';
    }

    $customcss = "";
    
    if( get_header_image() ){
        $konta_header_bg =  get_header_image();
    }else{
        if( konta_meta( 'page_breadcrumb_settings' ) == 'page' ){
            if( ! empty( konta_meta( 'breadcumb_image' ) ) ){
                $konta_header_bg = konta_meta( 'breadcumb_image' );
            }
        }
    }
    
    if( !empty( $konta_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$konta_header_bg}')!important;
        }";
    }
    
    // theme color
    $kontathemecolor = konta_opt('konta_theme_color');

    if( !empty( $kontathemecolor ) ){

        list($r, $g, $b) = sscanf( $kontathemecolor, "#%02x%02x%02x");

        $konta_real_color = $r.','.$g.','.$b;
        if( !empty( $kontathemecolor ) ) {
            $customcss .= ":root {
              --theme-color: rgb({$konta_real_color});
            }";
            $customcss .= ".theme-green {
              --theme-color: rgb({$konta_real_color});
            }";
            $customcss .= ".theme-yellow {
              --theme-color: rgb({$konta_real_color});
            }";
        }

        // Heading  color
        $kontaheadingcolor = konta_opt('konta_heading_color');
        if( !empty( $kontaheadingcolor ) ){
            list($r, $g, $b) = sscanf( $kontaheadingcolor, "#%02x%02x%02x");

            $konta_real_color = $r.','.$g.','.$b;
            if( !empty( $kontaheadingcolor ) ) {
                $customcss .= ":root {
                    --title-color: rgb({$konta_real_color});
                }";
            }
        }
        // Body color
        $kontabodycolor = konta_opt('konta_body_color');
        if( !empty( $kontabodycolor ) ){
            list($r, $g, $b) = sscanf( $kontabodycolor, "#%02x%02x%02x");

            $konta_real_color = $r.','.$g.','.$b;
            if( !empty( $kontabodycolor ) ) {
                $customcss .= ":root {
                    --body-color: rgb({$konta_real_color});
                }";
            }
        }

        // Body font
        $kontabodyfont = konta_opt('konta_theme_body_font', 'font-family');
        if( !empty( $kontabodyfont ) ) {
            $customcss .= ":root {
                --body-font: $kontabodyfont ;
            }";
        }

        // Heading font
        $kontaheadingfont = konta_opt('konta_theme_heading_font', 'font-family');
        if( !empty( $kontaheadingfont ) ) {
            $customcss .= ":root {
                --title-font: $kontaheadingfont ;
            }";
        }
        
        // Style font
        $kontastylefont = konta_opt('konta_theme_style_font', 'font-family');
        if( !empty( $kontastylefont ) ) {
            $customcss .= ":root {
                --style-font: $kontastylefont ;
            }";
        }


        if(konta_opt('konta_menu_icon_class')){
            $menu_icon_class = konta_opt( 'konta_menu_icon_class' );
        }else{
            $menu_icon_class = 'e00d';
        }

        if( !empty( $menu_icon_class ) ) {
            $customcss .= ".main-menu ul.sub-menu li a:before {
                    content: \"\\$menu_icon_class\" !important;
                }";
        }

        if( !empty( $CustomCssOpt ) ){
            $customcss .= $CustomCssOpt;
        }
    }

    wp_add_inline_style( 'konta-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'konta_common_custom_css', 100 );