<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "konta_opt";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }


    $alowhtml = array(
        'p' => array(
            'class' => array()
        ),
        'span' => array()
    );


    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        // 'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Konta Options', 'konta' ),
        'page_title'           => esc_html__( 'Konta Options', 'konta' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );


    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'konta' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'konta' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'konta' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'konta' )
        )
    );
    Redux::set_help_tab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'konta' );
    Redux::set_help_sidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */


    // -> START General Fields

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'General', 'konta' ),
        'id'               => 'konta_general',
        'customizer_width' => '450px',
        'icon'             => 'el el-cog',
        'fields'           => array(
            array(
                'id'       => 'konta_theme_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Theme Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Theme Color', 'konta' )
            ),
            array(
                'id'       => 'konta_map_apikey',
                'type'     => 'text',
                'title'    => esc_html__( 'Map Api Key', 'konta' ),
                'subtitle' => esc_html__( 'Set Map Api Key', 'konta' ),
            ),
        )

    ) );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Typography', 'konta' ),
        'id'               => 'konta_typography',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_theme_body_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'Body Font Family', 'konta' ),
                'google'      => true, 
                'font-size' => false,
                'line-height' => false,
                'subsets' => false,
                'text-align' => false,
                'color' => false,
                'font-style' => false,
                'font-weight' => false,
                'output'      => array(''),
            ),
            array(
                'id'       => 'konta_theme_heading_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'Heading Font Family', 'konta' ),
                'google'      => true, 
                'font-size' => false,
                'line-height' => false,
                'subsets' => false,
                'text-align' => false,
                'color' => false,
                'font-style' => false,
                'font-weight' => false,
                'output'      => array(''),
            ),
            array(
                'id'    => 'info_1',
                'type'  => 'info',
                'style' => 'success',
                'title' => __('Heading Fonts', 'konta'),
            ),
            array(
                'id'       => 'konta_theme_h1_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'H1 Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('h1'),
            ),
            array(
                'id'       => 'konta_theme_h2_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'H2 Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('h2'),
            ),
            array(
                'id'       => 'konta_theme_h3_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'H3 Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('h3'),
            ),
            array(
                'id'       => 'konta_theme_h4_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'H4 Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('h4'),
            ),
            array(
                'id'       => 'konta_theme_h5_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'H5 Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('h5'),
            ),
            array(
                'id'       => 'konta_theme_h6_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'H6 Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('h6'),
            ),
            array(
                'id'    => 'info_2',
                'type'  => 'info',
                'style' => 'success',
                'title' => __('Paragraph Fonts', 'konta'),
            ),
            array(
                'id'       => 'konta_theme_p_font',
                'type'     => 'typography',
                'title'    => esc_html__( 'P Font', 'konta' ),
                'google'      => true, 
                'font-style' => true,
                'text-transform' => true,
                'subsets' => false,
                'text-align' => false,
                'color' => true,
                'output'      => array('p'),
            ),
           
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Back To Top', 'konta' ),
        'id'               => 'konta_backtotop',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_display_bcktotop',
                'type'     => 'switch',
                'title'    => esc_html__( 'Back To Top Button', 'konta' ),
                'subtitle' => esc_html__( 'Switch On to Display back to top button.', 'konta' ),
                'default'  => true,
                'on'       => esc_html__( 'Enabled', 'konta' ),
                'off'      => esc_html__( 'Disabled', 'konta' ),
            ),
            array(
                'id'       => 'konta_bcktotop_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Back to top button Background Color.', 'konta' ),
                'required' => array('konta_display_bcktotop','equals','1'),
                'output'   => array( 'background-color' =>'.scroll-top svg' ),
            ),
            array(
                'id'       => 'konta_bcktotop_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Back to top Icon Color.', 'konta' ),
                'required' => array('konta_display_bcktotop','equals','1'),
                'output'   => array( '--theme-color' =>'.scroll-top:after' ),
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Preloader', 'konta' ),
        'id'               => 'konta_preloader',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_display_preloader', 
                'type'     => 'switch',
                'title'    => esc_html__( 'Preloader', 'konta' ),
                'subtitle' => esc_html__( 'Switch Enabled to Display Preloader.', 'konta' ),
                'default'  => true,
                'on'       => esc_html__('Enabled','konta'),
                'off'      => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_preloader_img',
                'type'     => 'media',
                'title'    => esc_html__( 'Preloader Image', 'konta' ),
                'subtitle' => esc_html__( 'Set Preloader Image.', 'konta' ),
                'required' => array( "konta_display_preloader","equals",true )
            ),
        )
    ));

    /* End General Fields */

    /* Admin Lebel Fields */
    Redux::setSection( $opt_name, array(
        'title'             => esc_html__( 'Admin Label', 'konta' ),
        'id'                => 'konta_admin_label',
        'customizer_width'  => '450px',
        'subsection'        => true,
        'fields'            => array(
            array(
                'title'     => esc_html__( 'Admin Login Logo', 'konta' ),
                'subtitle'  => esc_html__( 'It belongs to the back-end of your website to log-in to admin panel.', 'konta' ),
                'id'        => 'konta_admin_login_logo',
                'type'      => 'media',
            ),
            array(
                'title'     => esc_html__( 'Custom CSS For admin', 'konta' ),
                'subtitle'  => esc_html__( 'Any CSS your write here will run in admin.', 'konta' ),
                'id'        => 'konta_theme_admin_custom_css',
                'type'      => 'ace_editor',
                'mode'      => 'css',
                'theme'     => 'chrome',
                'full_width'=> true,
            ),
        ),
    ) );

    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header', 'konta' ),
        'id'               => 'konta_header',
        'customizer_width' => '400px',
        'icon'             => 'el el-credit-card',
        'fields'           => array(
            array(
                'id'       => 'konta_header_options',
                'type'     => 'button_set',
                'default'  => '1',
                'options'  => array(
                    "1"   => esc_html__('Prebuilt','konta'),
                    "2"      => esc_html__('Header Builder','konta'),
                ),
                'title'    => esc_html__( 'Header Options', 'konta' ),
                'subtitle' => esc_html__( 'Select header options.', 'konta' ),
            ),
            array(
                'id'       => 'konta_header_select_options',
                'type'     => 'select',
                'data'     => 'posts',
                'args'     => array(
                    'post_type'     => 'konta_header'
                ),
                'title'    => esc_html__( 'Header', 'konta' ),
                'subtitle' => esc_html__( 'Select header.', 'konta' ),
                'required' => array( 'konta_header_options', 'equals', '2' )
            ),

            array(
                'id'       => 'konta_header_sticky_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Header Sticky?', 'konta' ),
                'subtitle' => esc_html__( 'Control Header Sticky By Show Or Hide System.', 'konta'),
            ),   

            array(
                'id'       => 'konta_header_topbar_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Header Topbar?', 'konta' ),
                'subtitle' => esc_html__( 'Control Header Topbar By Show Or Hide System.', 'konta'),
                'required' => array( 'konta_header_options', 'equals', '1' )
            ),    
            array(
                'id'       => 'konta_topbar_phone_icon',
                'type'     => 'text',
                'default'  => esc_html__( '<i class="far fa-phone"></i>', 'konta' ),
                'title'    => esc_html__( 'Phone Icon', 'konta' ),
                'subtitle' => esc_html__( 'Set Phone Icon', 'konta' ),
                'required' => array( 
                    array('konta_header_options','equals','1'), 
                    array('konta_header_topbar_switcher','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_topbar_phone',
                'type'     => 'text',
                'default'  => esc_html__( '(+468) 254 762 443', 'konta' ),
                'title'    => esc_html__( 'Phone Number', 'konta' ),
                'subtitle' => esc_html__( 'Set Phone Number', 'konta' ),
                'required' => array( 
                    array('konta_header_options','equals','1'), 
                    array('konta_header_topbar_switcher','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_topbar_email_icon',
                'type'     => 'text',
                'default'  => esc_html__( '<i class="far fa-envelope"></i>', 'konta' ),
                'title'    => esc_html__( 'Email Icon', 'konta' ),
                'subtitle' => esc_html__( 'Set Email Icon', 'konta' ),
                'required' => array( 
                    array('konta_header_options','equals','1'), 
                    array('konta_header_topbar_switcher','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_topbar_email',
                'type'     => 'text',
                'default'  => esc_html__( 'support@gmail.com', 'konta' ),
                'title'    => esc_html__( 'Email Address', 'konta' ),
                'subtitle' => esc_html__( 'Set Email Address', 'konta' ),
                'required' => array( 
                    array('konta_header_options','equals','1'), 
                    array('konta_header_topbar_switcher','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_topbar_office_icon',
                'type'     => 'text',
                'default'  => esc_html__( '<i class="far fa-location-dot"></i>', 'konta' ),
                'title'    => esc_html__( 'Office Icon', 'konta' ),
                'subtitle' => esc_html__( 'Set Office Icon', 'konta' ),
                'required' => array( 
                    array('konta_header_options','equals','1'), 
                    array('konta_header_topbar_switcher','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_topbar_office',
                'type'     => 'text',
                'default'  => esc_html__( 'Mon - Sat: 8am - 15pm Sunday Off', 'konta' ),
                'title'    => esc_html__( 'Office Time', 'konta' ),
                'subtitle' => esc_html__( 'Set office time', 'konta' ),
                'required' => array( 
                    array('konta_header_options','equals','1'), 
                    array('konta_header_topbar_switcher','equals','1') 
                )
            ),

            array(
                'id'       => 'konta_header_social_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Header Social Icon?', 'konta' ),
                'subtitle' => esc_html__( 'Click Show To Display Social Icon?', 'konta'),
                'required' => array( 'konta_header_topbar_switcher', 'equals', '1' )
            ),  
            array(
                'id'       => 'konta_header_topbar_social_text',
                'type'     => 'text',
                'validate' => 'html',
                'default'  => esc_html__( 'Follow Us On:', 'konta' ),
                'title'    => esc_html__( 'Social Text', 'konta' ),
                'subtitle' => esc_html__( 'Set Social Text', 'konta' ),
                'required' => array( 'konta_header_topbar_switcher', 'equals', '1' )
            ),
            array(
                'id'    => 'info_1',
                'type'  => 'info',
                'style' => 'success',
                'title' => __('Header Bottom', 'konta'),
            ),

            array(
                'id'       => 'konta_header_search_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Show Search Icon?', 'konta' ),
                'subtitle' => esc_html__( 'Click Show To Display Search Icon?', 'konta'),
                'required' => array( 'konta_header_options', 'equals', '1' )
            ),
            array(
                'id'       => 'konta_header_cart_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Show Cart Icon?', 'konta' ),
                'subtitle' => esc_html__( 'Click Show To Display Cart Icon?', 'konta'),
                'required' => array( 'konta_header_options', 'equals', '1' ),
            ),
            array(
                'id'       => 'konta_header_offcanvas_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Show Offcanvas Icon?', 'konta' ),
                'subtitle' => esc_html__( 'Click Show To Display Offcanvas Icon?', 'konta'),
                'required' => array( 'konta_header_options', 'equals', '1' ),
            ),
            array(
                'id'       => 'konta_btn_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
                'title'    => esc_html__( 'Button Show?', 'konta' ),
                'subtitle' => esc_html__( 'Click Show To Display Buttion?', 'konta'),
                'required' => array( 'konta_header_options', 'equals', '1' ),
            ),
            array(
                'id'       => 'konta_btn_text',
                'type'     => 'text',
                'validate' => 'html',
                'default'  => esc_html__( 'Let’s Talk', 'konta' ),
                'title'    => esc_html__( 'Button Text', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Text', 'konta' ),
                'required' => array( 
                    array('konta_btn_switcher','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_btn_url',
                'type'     => 'text',
                'default'  => esc_html__( '#', 'konta' ),
                'title'    => esc_html__( 'Button URL?', 'konta' ),
                'subtitle' => esc_html__( 'Set Button URL Here', 'konta' ),
                'required' => array( 
                    array('konta_btn_switcher','equals','1') 
                )
            ),
          
        ),
    ) );
    // -> END Basic Fields

    // -> START Header Logo
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Logo', 'konta' ),
        'id'               => 'konta_header_logo_option',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_site_logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Logo', 'konta' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( 'Upload your site logo for header ( recommendation png format ).', 'konta' ),
            ),
            array(
                'id'       => 'konta_site_logo_dimensions',
                'type'     => 'dimensions',
                'units'    => array('px'),
                'title'    => esc_html__('Logo Dimensions (Width/Height).', 'konta'),
                'output'   => array('.header-logo .logo img'),
                'subtitle' => esc_html__('Set logo dimensions to choose width, height, and unit.', 'konta'),
            ),
            array(
                'id'       => 'konta_site_logomargin_dimensions',
                'type'     => 'spacing',
                'mode'     => 'margin',
                'output'   => array('.header-logo .logo img'),
                'units_extended' => 'false',
                'units'    => array('px'),
                'title'    => esc_html__('Logo Top and Bottom Margin.', 'konta'),
                'left'     => false,
                'right'    => false,
                'subtitle' => esc_html__('Set logo top and bottom margin.', 'konta'),
                'default'            => array(
                    'units'           => 'px'
                )
            ),
            array(
                'id'       => 'konta_text_title',
                'type'     => 'text',
                'validate' => 'html',
                'title'    => esc_html__( 'Text Logo', 'konta' ),
                'subtitle' => esc_html__( 'Write your logo text use as logo ( You can use span tag for text color ).', 'konta' ),
            )
        )
    ) );
    // -> End Header Logo

    // -> START Header Menu
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Style', 'konta' ),
        'id'               => 'konta_header_menu_option',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_menu_icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Navbar Sub-menu Icon Hide/Show', 'konta' ),
                'subtitle' => esc_html__( 'Hide / Show menu icon ( Default settings SHOW ).', 'konta' ),
                'default'  => '1',
                'on'       => 'Show',
                'off'      => 'Hide',
            ),
            array(
                'id'       => 'konta_menu_icon_class',
                'type'     => 'text',
                'validate' => 'html',
                'default'  => esc_html__( 'e00d', 'konta' ),
                'title'    => esc_html__( 'Sub Menu Icon', 'konta' ),
                'subtitle' => esc_html__( 'If you change icon need to use Font-Awesome Unicode icon ( Example: f0c9 | e00d ).', 'konta' ),
                'required' => array( 'konta_menu_icon', 'equals', '1' )
            ),
            array(
                'id'    => 'info_2',
                'type'  => 'info',
                'style' => 'success',
                'title' => __('Background', 'konta'),
            ),
            array(
                'id'       => 'konta_header_topbar_bg',
                'type'     => 'color',
                'title'    => esc_html__( 'Header Topbar Backgound', 'konta' ),
                'subtitle' => esc_html__( 'Set Topbar Background Color', 'konta' ),
                'output'   => array( 'background-color'    =>  '.prebuilt .header-top' ),
            ),
            array(
                'id'       => 'konta_header_menu_bg',
                'type'     => 'color',
                'title'    => esc_html__( 'Header Bottom Backgound', 'konta' ),
                'subtitle' => esc_html__( 'Set bottom background color', 'konta' ),
                'output'   => array( 'background-color'  =>  '.prebuilt .sticky-wrapper' ),
            ),
            array(
                'id'       => 'konta_header_logo_bg',
                'type'     => 'color',
                'title'    => esc_html__( 'Header Logo Backgound', 'konta' ),
                'subtitle' => esc_html__( 'Set logo background color', 'konta' ),
                'output'   => array( 'background-color'  =>  '.prebuilt .logo-bg:before' ),
            ),
            array(
                'id'    => 'info_3',
                'type'  => 'info',
                'style' => 'success',
                'title' => __('Menu Style', 'konta'),
            ),
            array(
                'id'       => 'konta_header_menu_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Menu Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .main-menu>ul>li>a' ),
            ),
            array(
                'id'       => 'konta_header_menu_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Menu Hover Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .main-menu>ul>li>a:hover' ),
            ),
            array(
                'id'       => 'konta_header_submenu_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Submenu Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .main-menu ul.sub-menu li a' ),
            ),
            array(
                'id'       => 'konta_header_submenu_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Submenu Hover Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .main-menu ul.sub-menu li a:hover' ),
            ),
            array(
                'id'       => 'konta_header_submenu_icon_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Icon Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Icon Hover Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .main-menu ul.sub-menu li a:before' ),
            ),
            array(
                'id'    => 'info_4',
                'type'  => 'info',
                'style' => 'success',
                'title' => __('Button Style', 'konta'),
            ),
            array(
                'id'       => 'konta_btn_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Header Button Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .th_btn' ),
            ),
            array(
                'id'       => 'konta_btn_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Hover Color', 'konta' ),
                'output'   => array( 'color'    =>  '.prebuilt .th_btn:hover' ),
            ),
            array(
                'id'       => 'konta_btn_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Background', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Background Color', 'konta' ),
                'output'   => array( 'background-color'    =>  '.prebuilt .th_btn' ),
            ),
            array(
                'id'       => 'konta_btn_bg_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Hover Background', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Background Hover Color', 'konta' ),
                'output'   => array( 'background-color'  =>  '.prebuilt .th_btn:after, .prebuilt .th_btn:before'),
            ),


        )
    ) );
    // -> End Header Menu

     // -> START Mobile Menu
     Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Mobile Menu', 'konta' ), 
        'id'               => 'konta_mobile_menu_option',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_menu_menu_show',
                'type'     => 'switch',
                'title'    => esc_html__( 'Mobile Logo Hide/Show', 'konta' ),
                'subtitle' => esc_html__( 'Hide / Show mobile menu logo ( Default settings SHOW ).', 'konta' ),
                'default'  => '1',
                'on'       => 'Show',
                'off'      => 'Hide',
            ),
            array(
                'id'       => 'konta_mobile_logo', 
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Logo', 'konta' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( 'Upload your mobile logo for mobile menu ( recommendation png format ).', 'konta' ),
                'required' => array( 
                    array('konta_menu_menu_show','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_mobile_logo_dimensions',
                'type'     => 'dimensions',
                'units'    => array('px'),
                'title'    => esc_html__('Logo Dimensions (Width/Height).', 'konta'),
                'output'   => array('.th-menu-wrapper .mobile-logo img'),
                'subtitle' => esc_html__('Set logo dimensions to choose width, height, and unit.', 'konta'),
                'required' => array( 
                    array('konta_menu_menu_show','equals','1') 
                )
            ),
            array(
                'id'       => 'konta_mobile_menu_bg',
                'type'     => 'color',
                'title'    => esc_html__( 'Logo Background', 'konta' ),
                'subtitle' => esc_html__( 'Set logo backgorund', 'konta' ),
                'output'   => array( 'background-color'    =>  '.th-menu-wrapper .mobile-logo' ),
                'required' => array( 
                    array('konta_menu_menu_show','equals','1') 
                )
            ),
    
        )
    ) );
    // -> End Mobile Menu


     // -> START Offcanvas Menu
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Offcanvas', 'konta' ),
        'id'               => 'konta_offcanvas_panel',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'konta_offcanvas_panel_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Offcanvas Panel Background', 'konta' ),
                'output'   => array('.sidemenu-wrapper .sidemenu-content'),
                'subtitle' => esc_html__( 'Set Offcanvas Panel Background Color', 'konta' ),
            ),
            array(
                'id'       => 'konta_offcanvas_title_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Offcanvas Title Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Offcanvas Title color.', 'konta' ),
                'output'   => array( '.sidemenu-content .widget_title' )
            ),
        )
    ) );
    // -> End Offcanvas

    // -> START Blog Page
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog', 'konta' ),
        'id'         => 'konta_blog_page',
        'icon'  => 'el el-blogger',
        'fields'     => array(

            array(
                'id'       => 'konta_blog_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Layout', 'konta' ),
                'subtitle' => esc_html__( 'Choose blog layout from here. If you use this option then you will able to change three type of blog layout ( Default Left Sidebar Layour ). ', 'konta' ),
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '3'
            ),
            array(
                'id'       => 'konta_blog_grid',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Post Column', 'konta' ),
                'subtitle' => esc_html__( 'Select your blog post column from here. If you use this option then you will able to select three type of blog post layout ( Default Two Column ).', 'konta' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/1column.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/2column.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/3column.png' )
                    ),

                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'konta_blog_page_title_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__('Show','konta'),
                'off'      => esc_html__('Hide','konta'),
                'title'    => esc_html__('Blog Page Title', 'konta'),
                'subtitle' => esc_html__('Control blog page title show / hide. If you use this option then you will able to show / hide your blog page title ( Default Setting Show ).', 'konta'),
            ),
            array(
                'id'       => 'konta_blog_page_title_setting',
                'type'     => 'button_set',
                'title'    => esc_html__('Blog Page Title Setting', 'konta'),
                'subtitle' => esc_html__('Control blog page title setting. If you use this option then you can able to show default or custom blog page title ( Default Blog ).', 'konta'),
                'options'  => array(
                    "predefine"   => esc_html__('Default','konta'),
                    "custom"      => esc_html__('Custom','konta'),
                ),
                'default'  => 'predefine',
                'required' => array("konta_blog_page_title_switcher","equals","1")
            ),
            array(
                'id'       => 'konta_blog_page_custom_title',
                'type'     => 'text',
                'title'    => esc_html__('Blog Custom Title', 'konta'),
                'subtitle' => esc_html__('Set blog page custom title form here. If you use this option then you will able to set your won title text.', 'konta'),
                'required' => array('konta_blog_page_title_setting','equals','custom')
            ),
            array(
                'id'            => 'konta_blog_postExcerpt',
                'type'          => 'slider',
                'title'         => esc_html__('Blog Posts Excerpt', 'konta'),
                'subtitle'      => esc_html__('Control the number of characters you want to show in the blog page for each post.. If you use this option then you can able to control your blog post characters from here ( Default show 10 ).', 'konta'),
                "default"       => 46,
                "min"           => 0,
                "step"          => 1,
                "max"           => 100,
                'resolution'    => 1,
                'display_value' => 'text',
            ),
            array(
                'id'       => 'konta_blog_readmore_setting',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Read More Text Setting', 'konta' ),
                'subtitle' => esc_html__( 'Control read more text from here.', 'konta' ),
                'options'  => array(
                    "default"   => esc_html__('Default','konta'),
                    "custom"    => esc_html__('Custom','konta'),
                ),
                'default'  => 'default',
            ),
            array(
                'id'       => 'konta_blog_custom_readmore',
                'type'     => 'text',
                'title'    => esc_html__('Read More Text', 'konta'),
                'subtitle' => esc_html__('Set read moer text here. If you use this option then you will able to set your won text.', 'konta'),
                'required' => array('konta_blog_readmore_setting','equals','custom')
            ),
            array(
                'id'       => 'konta_blog_title_color',
                'output'   => array( '.Themeholy-blog .blog-title a'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Title Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Blog Title Color.', 'konta' ),
            ),
            array(
                'id'       => 'konta_blog_title_hover_color',
                'output'   => array( '.Themeholy-blog .blog-title a:hover'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Title Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Blog Title Hover Color.', 'konta' ),
            ),
            array(
                'id'       => 'konta_blog_contant_color',
                'output'   => array( '.blog-content p'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Excerpt / Content Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Blog Excerpt / Content Color.', 'konta' ),
            ),
            array(
                'id'       => 'konta_blog_read_more_button_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Read More Button Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Read More Button Color.', 'konta' ),
                'output'   => array( '--theme-color' => '.blog-single .blog-content .th-btn' ),
            ),
            array(
                'id'       => 'konta_blog_read_more_button_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Read More Button Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Read More Button Hover Color.', 'konta' ),
                'output'   => array( '--title-color' => '.blog-single .blog-content .th-btn:hover' ),
            ),
            array(
                'id'       => 'konta_blog_pagination_color',
                'output'   => array( '.th-pagination a'),
                'type'     => 'color',
                'title'    => esc_html__('Blog Pagination Color', 'konta'),
                'subtitle' => esc_html__('Set Blog Pagination Color.', 'konta'),
            ),
            array(
                'id'       => 'konta_blog_pagination_bg_color',
                'output'   => array( '--smoke-color' => '.th-pagination a'),
                'type'     => 'color',
                'title'    => esc_html__('Blog Pagination Background', 'konta'),
                'subtitle' => esc_html__('Set Blog Pagination Backgorund Color.', 'konta'),
            ),
            // array(
            //     'id'       => 'konta_blog_pagination_active_color',
            //     'output'   => array( '.pagination li span.current'),
            //     'type'     => 'color',
            //     'title'    => esc_html__('Blog Pagination Active Color', 'konta'),
            //     'subtitle' => esc_html__('Set Blog Pagination Active Color.', 'konta'),
            //     'required'  => array('konta_blog_pagination', '=', '1')
            // ),
            array(
                'id'       => 'konta_blog_pagination_hover_color',
                'output'   => array( '.th-pagination a:hover, .th-pagination a.active'),
                'type'     => 'color',
                'title'    => esc_html__('Blog Pagination Hover & Active Color', 'konta'),
                'subtitle' => esc_html__('Set Blog Pagination Hover & Active Color.', 'konta'),
            ),
            array(
                'id'       => 'konta_blog_pagination_bg_hover_color',
                'output'   => array( '--theme-color' => '.th-pagination a:hover, .th-pagination a.active'),
                'type'     => 'color',
                'title'    => esc_html__('Blog Pagination Hover & Active Background', 'konta'),
                'subtitle' => esc_html__('Set Blog Pagination Background Hover & Active Color.', 'konta'),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Blog Page', 'konta' ),
        'id'         => 'konta_post_detail_styles',
        'subsection' => true,
        'fields'     => array(

            array(
                'id'       => 'konta_blog_single_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Layout', 'konta' ),
                'subtitle' => esc_html__( 'Choose blog single page layout from here. If you use this option then you will able to change three type of blog single page layout ( Default Left Sidebar Layour ). ', 'konta' ),
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '3'
            ),
            array(
                'id'       => 'konta_post_details_title_position',
                'type'     => 'button_set',
                'default'  => 'header',
                'options'  => array(
                    'header'        => esc_html__('On Header','konta'),
                    'below'         => esc_html__('Below Thumbnail','konta'),
                ),
                'title'    => esc_html__('Blog Post Title Position', 'konta'),
                'subtitle' => esc_html__('Control blog post title position from here.', 'konta'),
            ),
            array(
                'id'       => 'konta_post_details_custom_title',
                'type'     => 'text',
                'title'    => esc_html__('Blog Details Custom Title', 'konta'),
                'subtitle' => esc_html__('This title will show in Breadcrumb title.', 'konta'),
                'required' => array('konta_post_details_title_position','equals','below')
            ),
            array(
                'id'       => 'konta_display_post_tags',
                'type'     => 'switch',
                'title'    => esc_html__( 'Tags', 'konta' ),
                'subtitle' => esc_html__( 'Switch On to Display Tags.', 'konta' ),
                'default'  => true,
                'on'        => esc_html__('Enabled','konta'),
                'off'       => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_post_details_share_options',
                'type'     => 'switch',
                'title'    => esc_html__('Share Options', 'konta'),
                'subtitle' => esc_html__('Control post share options from here. If you use this option then you will able to show or hide post share options.', 'konta'),
                'on'        => esc_html__('Show','konta'),
                'off'       => esc_html__('Hide','konta'),
                'default'   => '0',
            ),
           
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Meta Data', 'konta' ),
        'id'         => 'konta_common_meta_data',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'konta_display_post_author',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post author', 'konta' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Author.', 'konta' ),
                'default'  => true,
                'on'        => esc_html__('Enabled','konta'),
                'off'       => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_display_post_date',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Date', 'konta' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Date.', 'konta' ),
                'default'  => true,
                'on'        => esc_html__('Enabled','konta'),
                'off'       => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_display_post_comments',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Comment', 'konta' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Comment Number.', 'konta' ),
                'default'  => false,
                'on'        => esc_html__('Enabled','konta'),
                'off'       => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_display_post_cate',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Category', 'konta' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Category.', 'konta' ),
                'default'  => true,
                'on'        => esc_html__('Enabled','konta'),
                'off'       => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_blog_meta_icon_color',
                'output'   => array( '.blog-meta a i'),
                'type'     => 'color',
                'title'    => esc_html__('Blog Meta Icon Color', 'konta'),
                'subtitle' => esc_html__('Set Blog Meta Icon Color.', 'konta'),
            ),
            array(
                'id'       => 'konta_blog_meta_text_color',
                'output'   => array( '.blog-meta a,.blog-meta span'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Meta Text Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Blog Meta Text Color.', 'konta' ),
            ),
            array(
                'id'       => 'konta_blog_meta_text_hover_color',
                'output'   => array( '.blog-meta a:hover'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Meta Hover Text Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Blog Meta Hover Text Color.', 'konta' ),
            ),
        )
    ));

    /* End blog Page */

    // -> START Page Option
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page & Breadcrumb', 'konta' ),
        'id'         => 'konta_page_page',
        'icon'  => 'el el-file',
        'fields'     => array(
            array(
                'id'       => 'konta_page_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Select layout', 'konta' ),
                'subtitle' => esc_html__( 'Choose your page layout. If you use this option then you will able to choose three type of page layout ( Default no sidebar ). ', 'konta' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'konta_page_layoutopt',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Settings', 'konta'),
                'subtitle' => esc_html__('Set page sidebar. If you use this option then you will able to set three type of sidebar ( Default no sidebar ).', 'konta'),
                //Must provide key => value pairs for options
                'options' => array(
                    '1' => esc_html__( 'Page Sidebar', 'konta' ),
                    '2' => esc_html__( 'Blog Sidebar', 'konta' )
                 ),
                'default' => '1',
                'required'  => array('konta_page_sidebar','!=','1')
            ),
            array(
                'id'       => 'konta_page_title_switcher',
                'type'     => 'switch',
                'title'    => esc_html__('Title', 'konta'),
                'subtitle' => esc_html__('Switch enabled to display page title. Fot this option you will able to show / hide page title.  Default setting Enabled', 'konta'),
                'default'  => '1',
                'on'        => esc_html__('Enabled','konta'),
                'off'       => esc_html__('Disabled','konta'),
            ),
            array(
                'id'       => 'konta_page_title_tag',
                'type'     => 'select',
                'options'  => array(
                    'h1'        => esc_html__('H1','konta'),
                    'h2'        => esc_html__('H2','konta'),
                    'h3'        => esc_html__('H3','konta'),
                    'h4'        => esc_html__('H4','konta'),
                    'h5'        => esc_html__('H5','konta'),
                    'h6'        => esc_html__('H6','konta'),
                ),
                'default'  => 'h1',
                'title'    => esc_html__( 'Title Tag', 'konta' ),
                'subtitle' => esc_html__( 'Select page title tag. If you use this option then you can able to change title tag H1 - H6 ( Default tag H1 )', 'konta' ),
                'required' => array("konta_page_title_switcher","equals","1")
            ),
            array(
                'id'       => 'konta_allHeader_title_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Title Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Title Color', 'konta' ),
                'output'   => array( 'color' => '.breadcumb-title' ),
                'required' => array("konta_page_title_switcher","equals","1")
            ),
            array(
                'id'       => 'konta_allHeader_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Background', 'konta' ),
                'subtitle' => esc_html__( 'Setting page header background. If you use this option then you will able to set Background Color, Background Image, Background Repeat, Background Size, Background Attachment, Background Position.', 'konta' ),
                'output'   => array( 'background' => '.breadcumb-wrapper' ),
            ),
             array(
                'id'       => 'konta_shoppage_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Background For Shop Pages', 'konta' ),
                'output'   => array( 'background' => '.custom-woo-class' ),
            ),
            array(
                'id'       => 'konta_archivepage_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Background For Archive Pages', 'konta' ),
                'output'   => array( 'background' => '.custom-archive-class' ),
            ),
            array(
                'id'       => 'konta_searchpage_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Background For Search Pages', 'konta' ),
                'output'   => array( 'background' => '.custom-search-class' ),
            ),
            array(
                'id'       => 'konta_errorpage_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Background For Error Pages', 'konta' ),
                'output'   => array( 'background' => '.custom-error-class' ),
            ),
            array(
                'id'       => 'konta_enable_breadcrumb',
                'type'     => 'switch',
                'title'    => esc_html__( 'Breadcrumb Hide/Show', 'konta' ),
                'subtitle' => esc_html__( 'Hide / Show breadcrumb from all pages and posts ( Default settings hide ).', 'konta' ),
                'default'  => '1',
                'on'       => 'Show',
                'off'      => 'Hide',
            ),
            array(
                'id'       => 'konta_allHeader_breadcrumbtextcolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Breadcrumb Color', 'konta' ),
                'subtitle' => esc_html__( 'Choose page header breadcrumb text color here.If you user this option then you will able to set page breadcrumb color.', 'konta' ),
                'required' => array("konta_enable_breadcrumb","equals","1"),
                'output'   => array( 'color' => '.breadcumb-wrapper .breadcumb-content ul li a' ),
            ),
            array(
                'id'       => 'konta_allHeader_breadcrumbtextactivecolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Breadcrumb Active Color', 'konta' ),
                'subtitle' => esc_html__( 'Choose page header breadcrumb text active color here.If you user this option then you will able to set page breadcrumb active color.', 'konta' ),
                'required' => array( "konta_enable_breadcrumb", "equals", "1" ),
                'output'   => array( 'color' => '.breadcumb-wrapper .breadcumb-content ul li:last-child' ),
            ),
            array(
                'id'       => 'konta_allHeader_dividercolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Breadcrumb Divider Color', 'konta' ),
                'subtitle' => esc_html__( 'Choose breadcrumb divider color.', 'konta' ),
                'required' => array( "konta_enable_breadcrumb", "equals", "1" ),
                'output'   => array( 'color'=>'.breadcumb-wrapper .breadcumb-content ul li:after' ),
            ),
        ),
    ) );
    /* End Page option */

    // -> START 404 Page

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( '404 Page', 'konta' ),
        'id'         => 'konta_404_page',
        'icon'       => 'el el-ban-circle',
        'fields'     => array(
            array(
                'id'       => 'konta_error_img',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Error Image', 'konta' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( 'Upload your error image ( recommendation png format ).', 'konta' ),
            ),
            array(
                'id'       => 'konta_error_title',
                'type'     => 'text',
                'title'    => esc_html__( 'Page Title', 'konta' ),
                'subtitle' => esc_html__( 'Set Page title ', 'konta' ),
                'default'  => esc_html__( 'Sorry! Page did not found', 'konta' ),
            ),
            array(
                'id'       => 'konta_error_title_color',
                'type'     => 'color',
                'output'   => array( '.error-title' ),
                'title'    => esc_html__( 'Title Color', 'konta' ),
                'subtitle' => esc_html__( 'Pick a subtitle color', 'konta' ),
                'validate' => 'color'
            ), 
            array(
                'id'       => 'konta_error_description',
                'type'     => 'text',
                'title'    => esc_html__( 'Page Description', 'konta' ),
                'subtitle' => esc_html__( 'Set Page Subtitle ', 'konta' ),
                'default'  => esc_html__( 'Unfortunately, something went wrong and this page does not exist. Try using the search or return to the previous page.', 'konta' ),
            ),
            array(
                'id'       => 'konta_error_desc_color',
                'type'     => 'color',
                'output'   => array( '.error-text' ),
                'title'    => esc_html__( 'Description Color', 'konta' ),
                'subtitle' => esc_html__( 'Pick a description color', 'konta' ),
                'validate' => 'color'
            ),
            array(
                'id'       => 'konta_error_btn_text',
                'type'     => 'text',
                'title'    => esc_html__( 'Button Text', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Text ', 'konta' ),
                'default'  => esc_html__( 'Return To Home', 'konta' ),
            ),
            array(
                'id'       => 'konta_error_btn_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Color', 'konta' ),
                'subtitle' => esc_html__( 'Button Color.', 'konta' ),
                'output'   => array( 'color' => '.th-btn.error-btn' ),
            ),
            array(
                'id'       => 'konta_error_btn_bg',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Background', 'konta' ),
                'subtitle' => esc_html__( 'Button Color.', 'konta' ),
                'output'   => array( '--theme-color' => '.th-btn.error-btn' ),
            ),
            array(
                'id'       => 'konta_error_btn_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Hover Color.', 'konta' ),
                'output'   => array( 'color' => '.th-btn.error-btn:hover',  ),
            ),
            array(
                'id'       => 'konta_error_btn_hover_bg',
                'type'     => 'color',
                'title'    => esc_html__( 'Button Hover Background', 'konta' ),
                'subtitle' => esc_html__( 'Set Button Hover Color.', 'konta' ),
                'output'   => array( '--white-color' => '.th-btn.error-btn:hover' ),
            ),
        ),
    ) );

    /* End 404 Page */
    // -> START Woo Page Option

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Woocommerce Page', 'konta' ),
        'id'         => 'konta_woo_page_page',
        'icon'  => 'el el-shopping-cart',
        'fields'     => array(
            array(
                'id'       => 'konta_woo_shoppage_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Set Shop Page Sidebar.', 'konta' ),
                'subtitle' => esc_html__( 'Choose shop page sidebar', 'konta' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'konta_woo_product_col',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Product Column', 'konta' ),
                'subtitle' => esc_html__( 'Set your woocommerce product column.', 'konta' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '2' => array(
                        'alt' => esc_attr__('2 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/2col.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('3 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/3col.png' )
                    ),
                    '4' => array(
                        'alt' => esc_attr__('4 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/4col.png')
                    ),
                    '5' => array(
                        'alt' => esc_attr__('5 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/5col.png')
                    ),
                    '6' => array(
                        'alt' => esc_attr__('6 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/6col.png' )
                    ),
                    '5' => array(
                        'alt' => esc_attr__('5 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/5col.png')
                    ),
                    '6' => array(
                        'alt' => esc_attr__('6 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/6col.png' )
                    ),),
                'default'  => '4'
            ),
            array(
                'id'       => 'konta_woo_product_perpage',
                'type'     => 'text',
                'title'    => esc_html__( 'Product Per Page', 'konta' ),
                'default' => '10'
            ),
            array(
                'id'       => 'konta_woo_singlepage_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Product Single Page sidebar', 'konta' ),
                'subtitle' => esc_html__( 'Choose product single page sidebar.', 'konta' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'konta_product_details_title_position',
                'type'     => 'button_set',
                'default'  => 'below',
                'options'  => array(
                    'header'        => esc_html__('On Header','konta'),
                    'below'         => esc_html__('Below Thumbnail','konta'),
                ),
                'title'    => esc_html__('Product Details Title Position', 'konta'),
                'subtitle' => esc_html__('Control product details title position from here.', 'konta'),
            ),
            array(
                'id'       => 'konta_product_details_custom_title',
                'type'     => 'text',
                'title'    => esc_html__( 'Product Details Title', 'konta' ),
                'default'  => esc_html__( 'Shop Details', 'konta' ),
                'required' => array('konta_product_details_title_position','equals','below'),
            ),
            array(
                'id'       => 'konta_product_details_custom_title',
                'type'     => 'text',
                'title'    => esc_html__( 'Product Details Title', 'konta' ),
                'default'  => esc_html__( 'Shop Details', 'konta' ),
                'required' => array('konta_product_details_title_position','equals','below'),
            ),
            array(
                'id'       => 'konta_woo_relproduct_display',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related product Hide/Show', 'konta' ),
                'subtitle' => esc_html__( 'Hide / Show related product in single page (Default Settings Show)', 'konta' ),
                'default'  => '1',
                'on'       => esc_html__('Show','konta'),
                'off'      => esc_html__('Hide','konta')
            ),
            array(
                'id'       => 'konta_woo_relproduct_subtitle',
                'type'     => 'text',
                'title'    => esc_html__( 'Related products Subtitle', 'konta' ),
                'default'  => esc_html__( 'Some Others Product', 'konta' ),
                'required' => array('konta_woo_relproduct_display','equals',true)
            ),
            array(
                'id'       => 'konta_woo_relproduct_title',
                'type'     => 'text',
                'title'    => esc_html__( 'Related products Title', 'konta' ),
                'default'  => esc_html__( 'Related products', 'konta' ),
                'required' => array('konta_woo_relproduct_display','equals',true)
            ),
            array(
                'id'       => 'konta_woo_relproduct_slider', 
                'type'     => 'switch',
                'title'    => esc_html__( 'Related product Sldier On/Off', 'konta' ),
                'subtitle' => esc_html__( 'Slider On/Off related product slider in single page (Default Settings Slider On)', 'konta' ),
                'default'  => '1',
                'on'       => esc_html__('Slider On','konta'),
                'off'      => esc_html__('Slider Off','konta')
            ),
            array(
                'id'       => 'konta_woo_relproduct_num',
                'type'     => 'text',
                'title'    => esc_html__( 'Related products number', 'konta' ),
                'subtitle' => esc_html__( 'Set how many related products you want to show in single product page.', 'konta' ),
                'default'  => 4,
                'required' => array('konta_woo_relproduct_display','equals',true)
            ),

            array(
                'id'       => 'konta_woo_related_product_col',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Related Product Column', 'konta' ),
                'subtitle' => esc_html__( 'Set your woocommerce related product column. it works if slider is off', 'konta' ),
                'required' => array('konta_woo_relproduct_display','equals',true),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '6' => array(
                        'alt' => esc_attr__('2 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/2col.png')
                    ),
                    '4' => array(
                        'alt' => esc_attr__('3 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/3col.png' )
                    ),
                    '3' => array(
                        'alt' => esc_attr__('4 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/4col.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('6 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/6col.png' )
                    ),

                ),
                'default'  => '4'
            ),
            array(
                'id'       => 'konta_woo_upsellproduct_display',
                'type'     => 'switch',
                'title'    => esc_html__( 'Upsell product Hide/Show', 'konta' ),
                'subtitle' => esc_html__( 'Hide / Show upsell product in single page (Default Settings Show)', 'konta' ),
                'default'  => '1',
                'on'       => esc_html__('Show','konta'),
                'off'      => esc_html__('Hide','konta'),
            ),
            array(
                'id'       => 'konta_woo_upsellproduct_num',
                'type'     => 'text',
                'title'    => esc_html__( 'Upsells products number', 'konta' ),
                'subtitle' => esc_html__( 'Set how many upsells products you want to show in single product page.', 'konta' ),
                'default'  => 3,
                'required' => array('konta_woo_upsellproduct_display','equals',true),
            ),

            array(
                'id'       => 'konta_woo_upsell_product_col',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Upsells Product Column', 'konta' ),
                'subtitle' => esc_html__( 'Set your woocommerce upsell product column.', 'konta' ),
                'required' => array('konta_woo_upsellproduct_display','equals',true),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '6' => array(
                        'alt' => esc_attr__('2 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/2col.png')
                    ),
                    '4' => array(
                        'alt' => esc_attr__('3 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/3col.png' )
                    ),
                    '3' => array(
                        'alt' => esc_attr__('4 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/4col.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('6 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/6col.png' )
                    ),

                ),
                'default'  => '4'
            ),
            array(
                'id'       => 'konta_woo_crosssellproduct_display',
                'type'     => 'switch',
                'title'    => esc_html__( 'Cross sell product Hide/Show', 'konta' ),
                'subtitle' => esc_html__( 'Hide / Show cross sell product in single page (Default Settings Show)', 'konta' ),
                'default'  => '1',
                'on'       => esc_html__( 'Show', 'konta' ),
                'off'      => esc_html__( 'Hide', 'konta' ),
            ),
            array(
                'id'       => 'konta_woo_crosssellproduct_num',
                'type'     => 'text',
                'title'    => esc_html__( 'Cross sell products number', 'konta' ),
                'subtitle' => esc_html__( 'Set how many cross sell products you want to show in single product page.', 'konta' ),
                'default'  => 3,
                'required' => array('konta_woo_crosssellproduct_display','equals',true),
            ),

            array(
                'id'       => 'konta_woo_crosssell_product_col',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Cross sell Product Column', 'konta' ),
                'subtitle' => esc_html__( 'Set your woocommerce cross sell product column.', 'konta' ),
                'required' => array( 'konta_woo_crosssellproduct_display', 'equals', true ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '6' => array(
                        'alt' => esc_attr__('2 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/2col.png')
                    ),
                    '4' => array(
                        'alt' => esc_attr__('3 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/3col.png' )
                    ),
                    '3' => array(
                        'alt' => esc_attr__('4 Columns','konta'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/4col.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('6 Columns','konta'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/6col.png' )
                    ),

                ),
                'default'  => '4'
            ),
        ),
    ) );

    /* End Woo Page option */
    // -> START Gallery
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Gallery', 'konta' ),
        'id'         => 'konta_gallery_widget',
        'icon'       => 'el el-gift',
        'fields'     => array(
            array(
                'id'          => 'konta_gallery_image_widget',
                'type'        => 'slides',
                'title'       => esc_html__('Add Gallery Image', 'konta'),
                'subtitle'    => esc_html__('Add gallery Image and url.', 'konta'),
                'show'        => array(
                    'title'          => false,
                    'description'    => false,
                    'progress'       => false,
                    'icon'           => false,
                    'facts-number'   => false,
                    'facts-title1'   => false,
                    'facts-title2'   => false,
                    'facts-number-2' => false,
                    'facts-title3'   => false,
                    'facts-number-3' => false,
                    'url'            => true,
                    'project-button' => false,
                    'image_upload'   => true,
                ),
            ),
        ),
    ) );
    // -> START Subscribe
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Subscribe', 'konta' ),
        'id'         => 'konta_subscribe_page',
        'icon'       => 'el el-eject',
        'fields'     => array(

            array(
                'id'       => 'konta_subscribe_apikey',
                'type'     => 'text',
                'title'    => esc_html__( 'Mailchimp API Key', 'konta' ),
                'subtitle' => esc_html__( 'Set mailchimp api key.', 'konta' ),
            ),
            array(
                'id'       => 'konta_subscribe_listid',
                'type'     => 'text',
                'title'    => esc_html__( 'Mailchimp List ID', 'konta' ),
                'subtitle' => esc_html__( 'Set mailchimp list id.', 'konta' ),
            ),
        ),
    ) );

    /* End Subscribe */

    // -> START Social Media

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social', 'konta' ),
        'id'         => 'konta_social_media',
        'icon'      => 'el el-globe',
        'desc'      => esc_html__( 'Social', 'konta' ),
        'fields'     => array(
            array(
                'id'          => 'konta_social_links',
                'type'        => 'slides',
                'title'       => esc_html__('Social Profile Links', 'konta'),
                'subtitle'    => esc_html__('Add social icon and url.', 'konta'),
                'show'        => array(
                    'title'          => true,
                    'description'    => true,
                    'progress'       => false,
                    'facts-number'   => false,
                    'facts-title1'   => false,
                    'facts-title2'   => false,
                    'facts-number-2' => false,
                    'facts-title3'   => false,
                    'facts-number-3' => false,
                    'url'            => true,
                    'project-button' => false,
                    'image_upload'   => false,
                ),
                'placeholder'   => array(
                    'icon'          => esc_html__( 'Icon (example: fa fa-facebook) ','konta'),
                    'title'         => esc_html__( 'Social Icon Class', 'konta' ),
                    'description'   => esc_html__( 'Social Icon Title', 'konta' ),
                ),
            ),
        ),
    ) );
    /* End social Media */


    // -> START Footer Media
    Redux::setSection( $opt_name , array(
       'title'            => esc_html__( 'Footer', 'konta' ),
       'id'               => 'konta_footer',
       'desc'             => esc_html__( 'konta Footer', 'konta' ),
       'customizer_width' => '400px',
       'icon'              => 'el el-photo',
   ) );

   Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Pre-built Footer / Footer Builder', 'konta' ),
        'id'         => 'konta_footer_section',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'konta_footer_builder_trigger',
                'type'     => 'button_set',
                'default'  => 'prebuilt',
                'options'  => array(
                    'footer_builder'        => esc_html__('Footer Builder','konta'),
                    'prebuilt'              => esc_html__('Pre-built Footer','konta'),
                ),
                'title'    => esc_html__( 'Footer Builder', 'konta' ),
            ),
            array(
                'id'       => 'konta_footer_builder_select',
                'type'     => 'select',
                'required' => array( 'konta_footer_builder_trigger','equals','footer_builder'),
                'data'     => 'posts',
                'args'     => array(
                    'post_type'     => 'konta_footerbuild'
                ),
                'on'       => esc_html__( 'Enabled', 'konta' ),
                'off'      => esc_html__( 'Disable', 'konta' ),
                'title'    => esc_html__( 'Select Footer', 'konta' ),
                'subtitle' => esc_html__( 'First make your footer from footer custom types then select it from here.', 'konta' ),
            ),
            array(
                'id'       => 'konta_footerwidget_enable',
                'type'     => 'switch',
                'title'    => esc_html__( 'Footer Widget', 'konta' ),
                'default'  => 1,
                'on'       => esc_html__( 'Enabled', 'konta' ),
                'off'      => esc_html__( 'Disable', 'konta' ),
                'required' => array( 'konta_footer_builder_trigger','equals','prebuilt'),
            ),
            array(
                'id'       => 'konta_footer_background',
                'type'     => 'background',
                'title'    => esc_html__( 'Footer Widget Background', 'konta' ),
                'subtitle' => esc_html__( 'Set footer background.', 'konta' ),
                'output'   => array( '.prebuilt-footer' ),
                'required' => array( 'konta_footerwidget_enable','=','1' ),
            ),
            array(
                'id'       => 'konta_footer_widget_title_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Widget Title Color', 'konta' ),
                'required' => array('konta_footerwidget_enable','=','1'),
                'output'   => array( '.footer-widget .widget_title' ),
            ),
            array(
                'id'       => 'konta_footer_widget_anchor_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Widget Anchor Color', 'konta' ),
                'required' => array('konta_footerwidget_enable','=','1'),
                'output'   => array( '.footer-widget.widget_nav_menu a' ),
            ),
            array(
                'id'       => 'konta_footer_widget_anchor_hov_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Widget Anchor Hover Color', 'konta' ),
                'required' => array('konta_footerwidget_enable','=','1'),
                'output'   => array( '--theme-color'    =>  '.footer-widget.widget_nav_menu a:hover' ),
            ),

        ),
    ) );


    // -> START Footer Bottom
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer Bottom', 'konta' ),
        'id'         => 'konta_footer_bottom',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'konta_disable_footer_bottom',
                'type'     => 'switch',
                'title'    => esc_html__( 'Footer Bottom?', 'konta' ),
                'default'  => 1,
                'on'       => esc_html__('Enabled','konta'),
                'off'      => esc_html__('Disable','konta'),
                'required' => array('konta_footer_builder_trigger','equals','prebuilt'),
            ),
            array(
                'id'       => 'konta_footer_bottom_background2',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Bottom Background Color', 'konta' ),
                'required' => array( 'konta_disable_footer_bottom','=','1' ),
                'output'   => array( 'background-color'   =>  '.prebuilt-footer  .copyright-wrap' ),
            ),
            array(
                'id'       => 'konta_copyright_text',
                'type'     => 'text',
                'title'    => esc_html__( 'Copyright Text', 'konta' ),
                'subtitle' => esc_html__( 'Add Copyright Text', 'konta' ),
                'default'  => sprintf( 'Copyright <i class="fal fa-copyright"></i> %s By <a href="%s">%s</a>. All Rights Reserved.',date('Y'),esc_url('#'),__( 'Konta.','konta' ) ),
                'required' => array( 'konta_disable_footer_bottom','equals','1' ),
            ),
            array(
                'id'       => 'konta_footer_copyright_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Copyright Text Color', 'konta' ),
                'subtitle' => esc_html__( 'Set footer copyright text color', 'konta' ),
                'required' => array( 'konta_disable_footer_bottom','equals','1'),
                'output'   => array( '.prebuilt-footer .copyright-wrap .copyright-text' ),
            ),
            array(
                'id'       => 'konta_footer_copyright_acolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Copyright Ancor Color', 'konta' ),
                'subtitle' => esc_html__( 'Set footer copyright ancor color', 'konta' ),
                'required' => array( 'konta_disable_footer_bottom','equals','1'),
                'output'    => array('color' => '.prebuilt-footer .copyright-wrap a, .prebuilt-footer  .copyright-wrap .footer-links a')
            ),
            array(
                'id'       => 'konta_footer_copyright_a_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Footer Copyright Ancor Hover Color', 'konta' ),
                'subtitle' => esc_html__( 'Set footer copyright ancor Hover color', 'konta' ),
                'required' => array( 'konta_disable_footer_bottom','equals','1'),
                'output'    => array('color' => '.prebuilt-footer .copyright-wrap a:hover, .prebuilt-footer  .copyright-wrap .footer-links a:hover')
            ), 

        )
    ));

    /* End Footer Media */

    // -> START Custom Css
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Custom Css', 'konta' ),
        'id'         => 'konta_custom_css_section',
        'icon'  => 'el el-css',
        'fields'     => array(
            array(
                'id'       => 'konta_css_editor',
                'type'     => 'ace_editor',
                'title'    => esc_html__('CSS Code', 'konta'),
                'subtitle' => esc_html__('Paste your CSS code here.', 'konta'),
                'mode'     => 'css',
                'theme'    => 'monokai',
            )
        ),
    ) );

    /* End custom css */



    if ( file_exists( dirname( __FILE__ ) . '/../README.md' ) ) {
        $section = array(
            'icon'   => 'el el-list-alt',
            'title'  => __( 'Documentation', 'konta' ),
            'fields' => array(
                array(
                    'id'       => '17',
                    'type'     => 'raw',
                    'markdown' => true,
                    'content_path' => dirname( __FILE__ ) . '/../README.md', // FULL PATH, not relative please
                    //'content' => 'Raw content here',
                ),
            ),
        );
        Redux::setSection( $opt_name, $section );
    }
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'konta' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'konta' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }