<?php
/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */


// Block direct access
if( ! defined( 'ABSPATH' ) ){
    exit;
}

 // theme option callback
function konta_opt( $id = null, $url = null ){
    global $konta_opt;

    if( $id && $url ){

        if( isset( $konta_opt[$id][$url] ) && $konta_opt[$id][$url] ){
            return $konta_opt[$id][$url];
        }
    }else{
        if( isset( $konta_opt[$id] )  && $konta_opt[$id] ){
            return $konta_opt[$id];
        }
    }
}


// theme logo
function konta_theme_logo() {
    // escaping allow html
    $allowhtml = array(
        'a'    => array(
            'href' => array()
        ),
        'span' => array(),
        'i'    => array(
            'class' => array()
        )
    );
    $siteUrl = home_url('/');
    if( has_custom_logo() ) {
        $custom_logo_id = get_theme_mod( 'custom_logo' );
        $siteLogo = '';
        $siteLogo .= '<a class="logo" href="'.esc_url( $siteUrl ).'">';
        $siteLogo .= konta_img_tag( array(
            "class" => "img-fluid",
            "url"   => esc_url( wp_get_attachment_image_url( $custom_logo_id, 'full') )
        ) );
        $siteLogo .= '</a>';

        return $siteLogo;
    } elseif( !konta_opt('konta_text_title') && konta_opt('konta_site_logo', 'url' )  ){

        $siteLogo = '<img class="img-fluid" src="'.esc_url( konta_opt('konta_site_logo', 'url' ) ).'" alt="'.esc_attr__( 'logo', 'konta' ).'" />';
        return '<a class="logo" href="'.esc_url( $siteUrl ).'">'.$siteLogo.'</a>';


    }elseif( konta_opt('konta_text_title') ){
        return '<h2 class="mb-0"><a class="logo" href="'.esc_url( $siteUrl ).'">'.wp_kses( konta_opt('konta_text_title'), $allowhtml ).'</a></h2>';
    }else{
        return '<h2 class="mb-0"><a class="logo" href="'.esc_url( $siteUrl ).'">'.esc_html( get_bloginfo('name') ).'</a></h2>';
    }
}

// custom meta id callback
function konta_meta( $id = '' ){
    $value = get_post_meta( get_the_ID(), '_konta_'.$id, true );
    return $value;
}


// Blog Date Permalink
function konta_blog_date_permalink() {
    $year  = get_the_time('Y');
    $month_link = get_the_time('m');
    $day   = get_the_time('d');
    $link = get_day_link( $year, $month_link, $day);
    return $link;
}

//audio format iframe match
function konta_iframe_match() {
    $audio_content = konta_embedded_media( array('audio', 'iframe') );
    $iframe_match = preg_match("/\iframe\b/i",$audio_content, $match);
    return $iframe_match;
}


//Post embedded media
function konta_embedded_media( $type = array() ){
    $content = do_shortcode( apply_filters( 'the_content', get_the_content() ) );
    $embed   = get_media_embedded_in_content( $content, $type );


    if( in_array( 'audio' , $type) ){
        if( count( $embed ) > 0 ){
            $output = str_replace( '?visual=true', '?visual=false', $embed[0] );
        }else{
           $output = '';
        }

    }else{
        if( count( $embed ) > 0 ){
            $output = $embed[0];
        }else{
           $output = '';
        }
    }
    return $output;
}


// WP post link pages
function konta_link_pages(){
    wp_link_pages( array(
        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'konta' ) . '</span>',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
        'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'konta' ) . ' </span>%',
        'separator'   => '<span class="screen-reader-text">, </span>',
    ) );
}


// Data Background image attr
function konta_data_bg_attr( $imgUrl = '' ){
    return 'data-bg-img="'.esc_url( $imgUrl ).'"';
}

// image alt tag
function konta_image_alt( $url = '' ){
    if( $url != '' ){
        // attachment id by url
        $attachmentid = attachment_url_to_postid( esc_url( $url ) );
       // attachment alt tag
        $image_alt = get_post_meta( esc_html( $attachmentid ) , '_wp_attachment_image_alt', true );
        if( $image_alt ){
            return $image_alt ;
        }else{
            $filename = pathinfo( esc_url( $url ) );
            $alt = str_replace( '-', ' ', $filename['filename'] );
            return $alt;
        }
    }else{
       return;
    }
}


// Flat Content wysiwyg output with meta key and post id

function konta_get_textareahtml_output( $content ) {
    global $wp_embed;

    $content = $wp_embed->autoembed( $content );
    $content = $wp_embed->run_shortcode( $content );
    $content = wpautop( $content );
    $content = do_shortcode( $content );

    return $content;
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */

function konta_pingback_header() {
    if ( is_singular() && pings_open() ) {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'konta_pingback_header' );


// Excerpt More
function konta_excerpt_more( $more ) {
    return '...';
}

add_filter( 'excerpt_more', 'konta_excerpt_more' );


// konta comment template callback
function konta_comment_callback( $comment, $args, $depth ) {
        $add_below = 'comment';
    ?>
    <li <?php comment_class( array('th-comment-item') ); ?>>
        <div id="comment-<?php comment_ID() ?>" class="th-post-comment">
            <?php
                if( get_avatar( $comment, 100 )  ) :
            ?>
            <!-- Author Image -->
            <div class="comment-avater">
                <?php
                    if ( $args['avatar_size'] != 0 ) {
                        echo get_avatar( $comment, 110 );
                    }
                ?>
            </div>
            <!-- Author Image -->
            <?php endif; ?>
            <!-- Comment Content -->
            <div class="comment-content">
                <div class="">
                    <h3 class="name"><?php echo esc_html( ucwords( get_comment_author() ) ); ?></h3>
                    <span class="commented-on"><?php printf( esc_html__('%1$s %2$s', 'konta'), get_comment_date(), get_the_time() ); ?></span>
                </div>
                <p class="text"><?php echo get_comment_text(); ?></p>
                <div class="reply_and_edit">
                    <?php
                        $reply_text = wp_kses_post( '<i class="fas fa-reply"></i> Reply', 'konta' );

                        $edit_reply_text = wp_kses_post( '<i class="fas fa-pencil-alt"></i> Edit', 'konta' );

                        comment_reply_link(array_merge( $args, array( 'add_below' => $add_below, 'depth' => 3, 'max_depth' => 5, 'reply_text' => $reply_text ) ) );
                    ?>  
                </div>
                <?php if ( $comment->comment_approved == '0' ) : ?>
                <p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'konta' ); ?></p>
                <?php endif; ?>
            </div>
        </div>
        <!-- Comment Content -->
<?php
}

//body class
add_filter( 'body_class', 'konta_body_class' );
function konta_body_class( $classes ) {
    if( class_exists('ReduxFramework') ) {
        $konta_blog_single_sidebar = konta_opt('konta_blog_single_sidebar');
        if( ($konta_blog_single_sidebar != '2' && $konta_blog_single_sidebar != '3' ) || ! is_active_sidebar('konta-blog-sidebar') ) {
            $classes[] = 'no-sidebar';
        }
        $new_class = is_page() ? konta_meta('custom_body_class') : null;

        if ( $new_class ) {
            $classes[] = $new_class;
        }
    } else {
        if( !is_active_sidebar('konta-blog-sidebar') ) {
            $classes[] = 'no-sidebar';
        }
    }
    $classes[] = 'dark-theme';
    return $classes;
}

//Global Footer
function konta_footer_global_option(){
    // Konta Widget Enable Disable
    if( class_exists( 'ReduxFramework' ) ){
        $konta_footer_widget_enable = konta_opt( 'konta_footerwidget_enable' );
        $konta_footer_bottom_active = konta_opt( 'konta_disable_footer_bottom' );
    }else{
        $konta_footer_widget_enable = '';
        $konta_footer_bottom_active = '1';
    }
    $allowhtml = array(
        'p'         => array(
            'class'     => array()
        ),
        'i'         => array(
            'class'     => array()
        ),
        'span'      => array(
            'class'     => array(),
        ),
        'a'         => array(
            'href'      => array(),
            'title'     => array(),
            'class'     => array(),
        ),
        'br'        => array(),
        'em'        => array(),
        'strong'    => array(),
        'b'         => array(),
    );
    if( $konta_footer_widget_enable == '1' || $konta_footer_bottom_active == '1' ){
        echo '<!---footer-wrapper start-->';
        echo '<footer class="footer-wrapper footer-layout prebuilt-footer footer-layout-default">';
            // if( $konta_footer_widget_enable == '1' ){
                if( ( is_active_sidebar( 'konta-footer-1' ) || is_active_sidebar( 'konta-footer-2' ) || is_active_sidebar( 'konta-footer-3' ) )) {
                    echo '<div class="widget-area space-top">';
                        echo '<div class="container">';
                                echo '<div class="row justify-content-between">';
                                    if( is_active_sidebar( 'konta-footer-1' )){
                                    dynamic_sidebar( 'konta-footer-1' ); 
                                    }
                                    if( is_active_sidebar( 'konta-footer-2' )){
                                    dynamic_sidebar( 'konta-footer-2' ); 
                                    }
                                    if( is_active_sidebar( 'konta-footer-3' )){
                                    dynamic_sidebar( 'konta-footer-3' ); 
                                    } 
                                    if( is_active_sidebar( 'konta-footer-4' )){
                                    dynamic_sidebar( 'konta-footer-4' ); 
                                    }  
                                    if( is_active_sidebar( 'konta-footer-5' )){
                                    dynamic_sidebar( 'konta-footer-5' ); 
                                    }  
                                echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            // }

            if( $konta_footer_bottom_active == '1' ){
                echo '<div class="copyright-wrap">';
                    echo '<div class="container">';
                        echo '<div class="row justify-content-between align-items-center">';
                            echo '<div class="col-md-6">';
                                echo '<p class="copyright-text">'.wp_kses( konta_opt( 'konta_copyright_text' ), $allowhtml ).'</p>';
                            echo '</div>';
                            echo '<div class="col-md-6 text-end d-none d-md-block">';
                                echo '<div class="footer-links">';
                                    wp_nav_menu( array(
                                        "theme_location"    => 'footer-menu',
                                        "container"         => '',
                                        "menu_class"        => ''
                                    ) ); 
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                            
                    echo '</div>';
                echo '</div>';
            }
        echo '</footer>';
        echo '<!---footer-wrapper end-->';
    }
}

// Social link
function konta_social_icon(){
    $konta_social_icon = konta_opt( 'konta_social_links' );
    if( ! empty( $konta_social_icon ) && isset( $konta_social_icon ) ){
        foreach( $konta_social_icon as $social_icon ){
                echo '<a href="'.esc_url( $social_icon['url'] ).'"><i class="'.esc_attr( $social_icon['title'] ).'"></i>'.esc_attr( $social_icon['description'] ).'</a>';
        }
    }
}


// global header
function konta_global_header_option() {

    if( class_exists( 'ReduxFramework' ) ){ ?>
        <header class="th-header header-layout-default">
        <?php
        if(konta_opt( 'konta_header_sticky_switcher' )){
            $sticky_class  = 'yes-sticky';
        }else{
            $sticky_class  = 'no-sticky';
        }

        if(konta_opt('konta_menu_icon')){
            $menu_icon = '';
        }else{
            $menu_icon = 'hide-icon';
        }
        // echo konta_header_cart_offcanvas();
        echo konta_header_offcanvas();
        echo konta_mobile_menu();
        echo konta_search_box();

        echo konta_header_menu_topbar();

        echo '<div class="sticky-wrapper">';
            echo '<!-- Main Menu Area -->';
            echo '<div class="menu-area">';
                echo '<div class="container th-container">';
                    echo '<div class="row align-items-center justify-content-between">';
                        echo '<div class="col-auto">';
                            echo '<div class="header-logo">';
                                echo konta_theme_logo();
                            echo '</div>';
                        echo '</div>';
                        echo '<div class="col-auto">';
                            echo '<nav class="main-menu d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
                                wp_nav_menu( array(
                                    "theme_location"    => 'primary-menu',
                                    "container"         => '',
                                    "menu_class"        => ''
                                ) ); 
                            echo '</nav>';
                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
                       echo ' </div>';
                        echo '<div class="col-auto d-none d-xl-block">';
                            echo '<div class="row">';
                                echo '<div class="col-auto">';
                                    echo '<div class="header-button">';
                                        if(!empty(konta_opt( 'konta_header_search_switcher' )) ) {
                                            echo '<button type="button" class="icon-btn searchBoxToggler"><i class="far fa-search"></i></button>';
                                        }
                                        if(!empty(konta_opt( 'konta_header_offcanvas_switcher' )) ) {
                                            echo '<button type="button" class="icon-btn sideMenuToggler"><i class="fas fa-grid"></i></button>';
                                        }
                                        if(!empty(konta_opt( 'konta_btn_switcher' )) && !empty(konta_opt( 'konta_btn_text' )) ) {
                                            echo '<a href="'.esc_url(konta_opt( 'konta_btn_url' )).'" class="th-btn ml-20">'.wp_kses_post(konta_opt( 'konta_btn_text' )).' <i class="fas fa-arrow-right ms-1"></i></a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
                echo '<div class="logo-bg" data-bg-src="'.KONTA_DIR_ASSIST_URI.'img/logo-bg-2.png"></div>';
            echo '</div>';
        echo '</div>';
    echo '</header>';

    }else{
        echo konta_global_header();
    }
}

if( ! function_exists( 'konta_header_menu_topbar' ) ){
    function konta_header_menu_topbar(){
        if( class_exists( 'ReduxFramework' ) ){
            $konta_header_topbar_switcher  = konta_opt( 'konta_header_topbar_switcher' );
            $konta_show_social_switcher    = konta_opt( 'konta_header_social_switcher' );
        }else{
            $konta_header_topbar_switcher  = '';
            $konta_show_social_switcher    = '';
        }

        if( $konta_header_topbar_switcher ){

            $phone     = konta_opt( 'konta_topbar_phone' );
            $email     = konta_opt( 'konta_topbar_email' );

            $email          = is_email( $email );

            $replace        = array(' ','-',' - ');
            $replace_phoone = array(' ','-',' - ', '(', ')');
            $with           = array('','','');

            $phoneurl       = str_replace( $replace_phoone, $with, $phone );
            $emailurl       = str_replace( $replace, $with, $email );

            echo '<div class="header-top">';
                echo '<div class="container th-container">';
                    echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
                        echo '<div class="col-auto d-none d-lg-block">';
                            echo '<div class="header-links">';
                                echo '<ul>';
                                    if(!empty($phone )){
                                        echo '<li>'.wp_kses_post(konta_opt('konta_topbar_phone_icon')).'<a href="'.esc_attr( 'tel:'.$phoneurl ).'">'.esc_html($phone).'</a></li>';
                                    }
                                    if(!empty($email )){
                                        echo '<li class="d-none d-xl-inline-block">'.wp_kses_post(konta_opt('konta_topbar_email_icon')).'<a href="'.esc_attr( 'mailto:'.$emailurl ).'">'.esc_html($email).'</a></li>';
                                    }
                                    if(!empty(konta_opt( 'konta_topbar_office' )) ) {
                                        echo '<li>'.wp_kses_post(konta_opt('konta_topbar_office_icon')) .esc_html( konta_opt( 'konta_topbar_office' ) ).'</li>';
                                    }
                                echo '</ul>';
                            echo '</div>';
                        echo '</div>';
                        echo '<div class="col-auto">';
                            if( $konta_show_social_switcher ){
                                echo '<div class="header-links header-right">';
                                    echo '<ul>';
                                        echo '<li>';
                                            echo '<div class="header-social">';
                                                echo '<span class="social-title">'.esc_html__( 'Follow Us:', 'kunta' ).'</span>';
                                                konta_social_icon();

                                            echo '</div>';
                                        echo '</li>';
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
    }
}

// konta woocommerce breadcrumb
function konta_woo_breadcrumb( $args ) {
    return array(
        'delimiter'   => '',
        'wrap_before' => '<ul class="breadcumb-menu">',
        'wrap_after'  => '</ul>',
        'before'      => '<li>',
        'after'       => '</li>',
        'home'        => _x( 'Home', 'breadcrumb', 'konta' ),
    );
}

add_filter( 'woocommerce_breadcrumb_defaults', 'konta_woo_breadcrumb' );

function konta_custom_search_form( $class ) {
    echo '<!-- Search Form -->';

    echo '<form role="search" method="get" action="'.esc_url( home_url( '/' ) ).'" class="'.esc_attr( $class ).'">';
        echo '<label class="searchIcon">';
            echo konta_img_tag( array(
                "url"   => esc_url( get_theme_file_uri( '/assets/img/search-2.svg' ) ),
                "class" => "svg"
            ) );
            echo '<input value="'.esc_html( get_search_query() ).'" name="s" required type="search" placeholder="'.esc_attr__('What are you looking for?', 'konta').'">';
        echo '</label>';
    echo '</form>';
    echo '<!-- End Search Form -->';
}



//Fire the wp_body_open action.
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}

//Remove Tag-Clouds inline style
add_filter( 'wp_generate_tag_cloud', 'konta_remove_tagcloud_inline_style',10,1 );
function konta_remove_tagcloud_inline_style( $input ){
   return preg_replace('/ style=("|\')(.*?)("|\')/','',$input );
}

/* This code filters the Categories archive widget to include the post count inside the link */
add_filter( 'wp_list_categories', 'konta_cat_count_span' );
function konta_cat_count_span( $links ) {
    $links = str_replace('</a> (', '</a> <span class="category-number">', $links);
    $links = str_replace(')', '</span>', $links);
    return $links;
}

/* This code filters the Archive widget to include the post count inside the link */
add_filter( 'get_archives_link', 'konta_archive_count_span' );
function konta_archive_count_span( $links ) {
    $links = str_replace('</a>&nbsp;(', '</a> <span class="category-number">', $links);
    $links = str_replace(')', '</span>', $links);
    return $links;
}

//header search box
if(! function_exists('konta_search_box')){
    function konta_search_box(){
        echo '<div class="popup-search-box d-none d-lg-block">';
            echo '<button class="searchClose"><i class="fal fa-times"></i></button>';
            echo '<form role="search" method="get" action="'.esc_url( home_url( '/' ) ).'">';
                echo '<input value="'.esc_html( get_search_query() ).'" name="s" required type="search" placeholder="'.esc_attr__('What are you looking for?', 'konta').'">';
                echo '<button type="submit"><i class="fal fa-search"></i></button>';
            echo '</form>';
        echo '</div>';
    }
}


// Konta Default Header
if( ! function_exists( 'konta_global_header' ) ){
    function konta_global_header(){ ?>

        <!--Mobile menu & Search box-->
        <?php 
        echo konta_search_box(); 
        echo konta_mobile_menu(); 
        
        ?>

        <!--======== Header ========-->
        <header class="th-header unittest-header">
            <div class="sticky-wrapper">
                <div class="sticky-active">
                    <div class="menu-area">
                        <div class="container">
                            <div class="row gx-20 align-items-center justify-content-between">

                                <div class="col-auto">
                                    <div class="header-logo">
                                       <?php echo konta_theme_logo(); ?>
                                    </div>
                                </div>

                                <div class="col-auto">
                                    <?php
                                    if( has_nav_menu( 'primary-menu' ) ) { ?>
                                        <nav class="main-menu d-none d-lg-inline-block">
                                            <?php
                                            wp_nav_menu( array(
                                                "theme_location"    => 'primary-menu',
                                                "container"         => '',
                                                "menu_class"        => ''
                                            ) ); ?>
                                        </nav>
                                    <?php } ?>                                   
                                    </nav>
                                    <button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>
                                </div>
                                <div class="col-auto d-none d-xl-block">
                                    <div class="header-button">
                                        <button type="button" class="icon-btn searchBoxToggler"><i class="far fa-search"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="menu-bg"></div>
                </div>
            </div>
        </header>
    <?php
    }
}


//header Offcanvas
if( ! function_exists( 'konta_header_offcanvas' ) ){
    function konta_header_offcanvas(){
    ?>
    <div class="sidemenu-wrapper d-none d-lg-block ">
        <div class="sidemenu-content bg-black2 sidemenu-area">
            <button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>
            <?php 
                if(is_active_sidebar('konta-offcanvas')){
                    dynamic_sidebar( 'konta-offcanvas' );
                }else{
                    echo '<h4 class="widget_title text-white">No Widget Added </h4>';
                    echo '<p>Please add some widget in Offcanvs Sidebar</p>';
                }
            ?>
        </div>
    </div>
    
<?php
    }
}

//header Cart Offcanvas
if( ! function_exists( 'konta_header_cart_offcanvas' ) ){
    function konta_header_cart_offcanvas(){
        ?>
        <div class="sidemenu-wrapper shopping-cart d-none d-lg-block ">
            <div class="sidemenu-content">
                <button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>
                <div class="widget woocommerce widget_shopping_cart">
                    <h3 class="widget_title"><?php echo esc_html__( 'Shopping cart', 'konta' ); ?></h3>
                    <div class="widget_shopping_cart_content">
                    
                    </div>
                </div>
            </div>
        </div>

    <?php
    }
}

// mobile logo
function konta_mobile_logo() {
    $logo_url = konta_opt('konta_mobile_logo', 'url' );
    $mobile_menu = '';
    if( !empty($logo_url )){
        $mobile_menu = '<div class="mobile-logo"><a href="'.home_url('/').'"><img src="'.esc_url($logo_url).'" alt="'.esc_attr__( 'logo', 'konta' ).'"></a></div>';
    }else{
        $mobile_menu .= '<div class="mobile-logo">';
        $mobile_menu .= konta_theme_logo();
        $mobile_menu .= '</div>';
    }

    return $mobile_menu;
 }

//header Mobile Menu
if( ! function_exists( 'konta_mobile_menu' ) ){
    function konta_mobile_menu(){
    ?>
    <div class="th-menu-wrapper">
        <div class="th-menu-area text-center">
            <button class="th-menu-toggle"><i class="fal fa-times"></i></button>
            <?php  if( class_exists('ReduxFramework') ):?>
                <?php 
                    if(!empty(konta_opt('konta_menu_menu_show') )){
                        echo konta_mobile_logo(); 
                    }
                ?>
            <?php else: ?>
                <div class="mobile-logo">
                    <?php echo konta_theme_logo(); ?>
                </div>
            <?php endif; ?>
            <div class="th-mobile-menu">
                <?php 
                    if( has_nav_menu( 'primary-menu' ) ){
                        wp_nav_menu( array(
                            "theme_location"    => 'primary-menu',
                            "container"         => '',
                            "menu_class"        => ''
                        ) );
                    }
                ?>
            </div>
        </div>
    </div>

<?php
    }
}



// Blog post views function
function konta_setPostViews( $postID ) {
    $count_key  = 'post_views_count';
    $count      = get_post_meta( $postID, $count_key, true );
    if( $count == '' ){
        $count = 0;
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
    }else{
        $count++;
        update_post_meta( $postID, $count_key, $count );
    }
}

function konta_getPostViews( $postID ){
    $count_key  = 'post_views_count';
    $count      = get_post_meta( $postID, $count_key, true );
    if( $count == '' ){
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
        return __( '0', 'konta' );
    }
    return $count;
}


// Add Extra Class On Comment Reply Button
function konta_custom_comment_reply_link( $content ) {
    $extra_classes = 'reply-btn';
    return preg_replace( '/comment-reply-link/', 'comment-reply-link ' . $extra_classes, $content);
}

add_filter('comment_reply_link', 'konta_custom_comment_reply_link', 99);

// Add Extra Class On Edit Comment Link
function konta_custom_edit_comment_link( $content ) {
    $extra_classes = 'reply-btn';
    return preg_replace( '/comment-edit-link/', 'comment-edit-link ' . $extra_classes, $content);
}

add_filter('edit_comment_link', 'konta_custom_edit_comment_link', 99);


function konta_post_classes( $classes, $class, $post_id ) {
    if ( get_post_type() === 'post' ) {
        $classes[] = "th-blog blog-single has-post-thumbnail";
    }elseif( get_post_type() === 'product' ){
        // Return Class
    }elseif( get_post_type() === 'page' ){
        $classes[] = "page--item";
    }
    
    return $classes;
}
add_filter( 'post_class', 'konta_post_classes', 10, 3 );

// Contact form 7
add_filter('wpcf7_autop_or_not', '__return_false');