<?php
/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    konta_setPostViews( get_the_ID() );

    ?>
    <div <?php post_class(); ?>>
    <?php
        if( class_exists('ReduxFramework') ) {
            $konta_post_details_title_position = konta_opt('konta_post_details_title_position');
        } else {
            $konta_post_details_title_position = 'header';
        }

        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array()
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );
        // Blog Post Thumbnail
        do_action( 'konta_blog_post_thumb' );
        
        echo '<div class="blog-content">';

            // Blog Post Meta
            do_action( 'konta_blog_post_meta' );

            if( $konta_post_details_title_position != 'header' ) {
                echo '<h2 class="blog-title">'.wp_kses( get_the_title(), $allowhtml ).'</h2>';
            }

            if( get_the_content() ){

                the_content();
                // Link Pages
                konta_link_pages();
            }  

        

            if( class_exists('ReduxFramework') ) {
                $konta_post_details_share_options = konta_opt('konta_post_details_share_options');
                $konta_display_post_tags = konta_opt('konta_display_post_tags');
                $konta_author_options = konta_opt('konta_post_details_author_desc_trigger');
            } else {
                $konta_post_details_share_options = false;
                $konta_display_post_tags = false;
                $konta_author_options = false;
            }
            
            $konta_post_tag = get_the_tags();
            
            if( ! empty( $konta_display_post_tags ) || ( ! empty($konta_post_details_share_options )) ){
                echo '<div class="share-links clearfix">';
                    echo '<div class="row justify-content-between">';
                        if( is_array( $konta_post_tag ) && ! empty( $konta_post_tag ) ){
                            if( count( $konta_post_tag ) > 1 ){
                                $tag_text = __( 'Tags:', 'konta' );
                            }else{
                                $tag_text = __( 'Tag:', 'konta' );
                            }
                            if($konta_display_post_tags){
                                echo '<div class="col-md-auto">';
                                    echo '<span class="share-links-title">'.esc_html( $tag_text ).'</span>';
                                    echo '<div class="tagcloud dg">';
                                        foreach( $konta_post_tag as $tags ){
                                            echo '<a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            }
                        }

                        /**
                        *
                        * Hook for Blog Details Share Options
                        *
                        * Hook konta_blog_details_share_options
                        *
                        * @Hooked konta_blog_details_share_options_cb 10
                        *
                        */
                        do_action( 'konta_blog_details_share_options' );

                    echo '</div>';

                echo '</div>';

                    
            }  
        echo '</div>';

       

    echo '</div>'; 

     /**
        *
        * Hook for Blog Navigation
        *
        * Hook konta_blog_details_post_navigation
        *
        * @Hooked konta_blog_details_post_navigation_cb 10
        *
        */
        do_action( 'konta_blog_details_post_navigation' );

        /**
        *
        * Hook for Blog Details Comments
        *
        * Hook konta_blog_details_comments
        *
        * @Hooked konta_blog_details_comments_cb 10
        *
        */
        do_action( 'konta_blog_details_comments' );
