<?php
/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $konta_post_id = get_the_ID();

            // Get the page settings manager
            $konta_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $konta_page_settings_model = $konta_page_settings_manager->get_model( $konta_post_id );

            // Retrieve the color we added before
            $konta_header_style = $konta_page_settings_model->get_settings( 'konta_header_style' );
            $konta_header_builder_option = $konta_page_settings_model->get_settings( 'konta_header_builder_option' );

            if( $konta_header_style == 'header_builder'  ) {

                if( !empty( $konta_header_builder_option ) ) {
                    $kontaheader = get_post( $konta_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $kontaheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $konta_header_builder_trigger = konta_opt('konta_header_options');
                if( $konta_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $konta_global_header_select = get_post( konta_opt( 'konta_header_select_options' ) );
                    $header_post = get_post( $konta_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    konta_global_header_option();
                }
            }
        } else {
            $konta_header_options = konta_opt('konta_header_options');
            if( $konta_header_options == '1' ) {
                konta_global_header_option();
            } else {
                $konta_header_select_options = konta_opt('konta_header_select_options');
                $kontaheader = get_post( $konta_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $kontaheader->ID );
                echo '</header>';
            }
        }
    } else {
        konta_global_header_option();
    }