<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( class_exists('ReduxFramework') ) {
    $konta_woo_relproduct_display = konta_opt('konta_woo_relproduct_display');
    $konta_woo_relproduct_num = konta_opt('konta_woo_relproduct_num');
    $konta_woo_relproduct_slider = konta_opt('konta_woo_relproduct_slider');

    $subtitle = konta_opt('konta_woo_relproduct_subtitle');
    $title = konta_opt('konta_woo_relproduct_title');
}else{
    $konta_woo_relproduct_display ='';
    $konta_woo_relproduct_num = '';
    $konta_woo_relproduct_slider = '';

    $subtitle = esc_html__('','konta');
    $title = esc_html__('Related Shop','konta');
}
$slider_active = $konta_woo_relproduct_slider ? 'related-products-carousel' : '';

if ( $related_products && $konta_woo_relproduct_display) : ?>

    <div class="space-extra-top mb-30">
        <div class="title-area">
            <div class="row justify-content-between align-items-center">
                <div class="col-auto">
                    <h2 class="sec-title mb-0"><?php echo esc_html($title) ?></h2>
                </div>
                <div class="col d-none d-sm-block">
                    <hr class="title-line">
                </div>
                <div class="col-auto">
                    <div class="sec-btn mb-0">
                        <div class="icon-box">
                            <button data-slick-prev="#productCarousel" class="slick-arrow default"><i class="far fa-arrow-left"></i></button>
                            <button data-slick-next="#productCarousel" class="slick-arrow default"><i class="far fa-arrow-right"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row <?php echo esc_attr($slider_active); ?>" id="productCarousel">

        <?php
            if( class_exists('ReduxFramework') ) {
                $konta_woo_related_product_col = konta_opt('konta_woo_related_product_col');
                if( $konta_woo_related_product_col == '2' ) {
                    $konta_woo_product_col_val = 'col-xl-2 col-lg-4 col-sm-6 mb-30';
                } elseif( $konta_woo_related_product_col == '3' ) {
                    $konta_woo_product_col_val = 'col-xl-3 col-lg-4 col-sm-6';
                } elseif( $konta_woo_related_product_col == '4' ) {
                    $konta_woo_product_col_val = 'col-xl-4 col-lg-4 col-sm-6 mb-30';
                } elseif( $konta_woo_related_product_col == '6' ) {
                    $konta_woo_product_col_val = 'col-lg-6 col-sm-6 mb-30';
                }
            } else {
                $konta_woo_product_col_val = 'col-xl-3 col-lg-4 col-sm-6';
            }
        ?>

            <?php foreach ( $related_products as $related_product ) : ?>
                <div class="<?php echo esc_attr($konta_woo_product_col_val) ?>">
                    <?php
                        $post_object = get_post( $related_product->get_id() );

                        setup_postdata( $GLOBALS['post'] =& $post_object );

                        wc_get_template_part( 'content', 'product' );
                    ?>
                </div>

            <?php endforeach; ?>

        </div>

    </div>

<?php endif;

wp_reset_postdata();