<?php
$this->start_controls_section(
	'1_wcu',
	[
		'label'     => __( 'Content', 'konta' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style' => ['layout_one']]
	]
);
$this->add_control(
	'title', [
		'label' 		=> __( 'Title', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'rows' 			=> 2,
		'default' 		=> __( ' WHY CHOOSE US' , 'konta' ),
		'label_block' 	=> true,
	]
);
$this->add_control(
    'title_img',
    [
        'label'     => __( 'Title Image', 'konta' ),
        'type'      => \Elementor\Controls_Manager::MEDIA,
        'dynamic' 		=> [
			'active' 		=> true,
		],
		'default' 		=> [
			'url' 		=>  \Elementor\Utils::get_placeholder_image_src(),
		],
    ]
);
$this->add_control(
	'subtitle', [
		'label' 		=> __( 'Subtitle', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
		'rows' 			=> 2,
		'default' 		=> __( 'High Quality Construction Projects & Innovate Design!' , 'konta' ),
		'label_block' 	=> true,
	]
);

 $this->add_control(
	'button_text',
	[
		'label' 	=> esc_html__( 'Button Text', 'konta' ),
        'type' 		=> \Elementor\Controls_Manager::TEXT,
        'default'  	=> esc_html__( 'Get More Info', 'konta' ),
	]
);

$this->add_control(
	'button_link',
	[
		'label' 		=> esc_html__( 'Button Link', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
		'default' 		=> [
			'url' 			=> '#',
			'is_external' 	=> false,
			'nofollow' 		=> false,
		],
	]
);

$this->add_control(
	'button_text2',
	[
		'label' 	=> esc_html__( 'Button Text 2', 'konta' ),
        'type' 		=> \Elementor\Controls_Manager::TEXT,
        'default'  	=> esc_html__( 'Get More Info', 'konta' ),
	]
);

$this->add_control(
	'button_link2',
	[
		'label' 		=> esc_html__( 'Button url 2', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
		'default' 		=> [
			'url' 			=> '#',
			'is_external' 	=> false,
			'nofollow' 		=> false,
		],
	]
);
$this->add_control(
	'video_link',
	[
		'label' 		=> esc_html__( 'Video url', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::URL,
		'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
		'show_external' => true,
		'default' 		=> [
			'url' 			=> '#',
			'is_external' 	=> false,
			'nofollow' 		=> false,
		],
	]
);
$this->add_control(
    'banner_img',
    [
        'label'     => __( 'Thumb Image', 'konta' ),
        'type'      => \Elementor\Controls_Manager::MEDIA,
        'dynamic' 		=> [
			'active' 		=> true,
		],
		'default' 		=> [
			'url' 		=>  \Elementor\Utils::get_placeholder_image_src(),
		],
    ]
);

$repeater = new \Elementor\Repeater();

$repeater->add_control(
	'title',
	[
		'label'     => __( 'Title', 'konta' ),
        'type'      => \Elementor\Controls_Manager::TEXTAREA,
        'rows' 		=> 2,
	]
);
$repeater->add_control(
	'image',
	[
		'label' 		=> __( 'Choose Image', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
		'dynamic' 		=> [
			'active' 		=> true,
		],
		'default' 		=> [
			'url' 			=>  \Elementor\Utils::get_placeholder_image_src(),
		],
	]
);
$this->add_control(
	'wcus',
	[
		'label' 		=> __( 'Features', 'konta' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'title' 		=> __( 'title', 'konta' ),
			],
		],
		'condition' => [
			'layout_style' => ['layout_one']
		]
	]
);

$this->end_controls_section();