<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget .
 *
 */
class Konta_Header extends Widget_Base {

	public function get_name() {
		return 'kontaheader';
	}
	public function get_title() {
		return __( 'Header', 'konta' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'konta_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' 	=> __( 'Header', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'layout_one' => __( 'Style One', 'konta' ),
					'layout_two' => __( 'Style Two', 'konta' ),
					'layout_three' => __( 'Style Three', 'konta' ),
					'layout_four' => __( 'Style Four', 'konta' ),
				],
				'default' => 'layout_one',
			]
        );

        

		$this->add_control(
			'show_top_bar',
			[
				'label' 		=> __( 'Show Top Bar?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'topbar_slogan',
			[
				'label' 		=> __( 'Topbar Slogan', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=>  __( 'Welcome to Konta Construction And Repairing Service', 'konta' ),
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one']
				],
			]
		);
		$this->add_control(
			'show_language_switcher',
			[
				'label' 		=> __( 'Show Language ?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'header_style' => ['layout_one'],
					'show_top_bar' => 'yes'
				]
			]
		);

		$this->add_control(
			'topbar_email_icon',
			[
				'label' 		=> __( 'Email Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-thin fa-envelope"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one','layout_two', 'layout_three', 'layout_four']
				],
			]
		);
		$this->add_control(
			'topbar_email_label',
			[
				'label' 		=> __( 'Email Label', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'Email',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one', 'layout_four']
				],
			]
		);

		$this->add_control(
			'topbar_email',
			[
				'label' 	=> __( 'Email Address', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'info@konta.com', 'konta' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one','layout_two', 'layout_three', 'layout_four']
				],
			]
		);

		$this->add_control(
			'topbar_phone_icon',
			[
				'label' 		=> __( 'Phone Icon', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-thin fa-phone"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one','layout_two', 'layout_three', 'layout_four']
				],
			]
		);
		$this->add_control(
			'topbar_phone_label',
			[
				'label' 		=> __( 'Phone Label', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'Phone',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one', 'layout_four']
				],
			]
		);

		$this->add_control(
			'topbar_phone',
			[
				'label' 	=> __( 'Phone Number', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '(+468) 254 762 443', 'konta' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'], 
					'layout_style' => ['layout_one','layout_two', 'layout_three', 'layout_four']
				],
			]
		);

		$this->add_control(
			'office_hours_icon',
			[
				'label' 		=> __( 'Office Hours Iocn', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-light fa-clock"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one']
					// 'layout_style' => ['layout_two', 'layout_three']
				],
			]
		);
		$this->add_control(
			'office_hours_label',
			[
				'label' 		=> __( 'Office Hours Label', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'Office Hours',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one']
				],
			]
		);
		
		$this->add_control(
			'office_hours',
			[
				'label' 	=> __( 'Office Hours', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'Mon - Sat: 8am - 15pm Sunday Off', 'konta' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one']
					// 'layout_style' => ['layout_two', 'layout_three']
				],
			]
		);
		$this->add_control(
			'location_label',
			[
				'label' 		=> __( 'location Label', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'USA',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one', 'layout_four']
				],
			]
		);
		$this->add_control(
			'location',
			[
				'label' 	=> __( 'Location', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '25 Street, 145 City Town, USA', 'konta' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_two', 'layout_three', 'layout_four']
				],
			]
		);
		$this->add_control(
			'location_url',
			[
				'label' 	=> __( 'Location url', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '#', 'konta' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_four']
				],
			]
		);
		$this->add_control(
			'location_icon',
			[
				'label' 		=> __( 'Location Iocn', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fal fa-location-dot"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_two', 'layout_three', 'layout_four']
				],
			]
		);

		//Social 
		$this->add_control(
			'show_social',
			[
				'label' 		=> __( 'Show Social?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator'		=> 'before',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one','layout_two', 'layout_three']
				],
			]
		);

		$this->add_control(
			'social_text',
			[
				'label' 	=> __( 'Social Text', 'konta' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'Follow Us On:', 'konta' ),
				'label_block' => true,
				'condition'		=> [ 
					'show_social'  => 'yes',
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_two', 'layout_three']
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' 	=> __( 'Social Icon', 'konta' ),
				'type' 		=> Controls_Manager::ICONS,
				'default' 	=> [
					'value' 	=> 'fab fa-facebook-f',
					'library' 	=> 'solid',
				],
			]
		);

		$repeater->add_control(
			'icon_link',
			[
				'label' 		=> __( 'Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'social_icon_list',
			[
				'label' 		=> __( 'Social Icon', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'social_icon' => __( 'Add Social Icon','konta' ),
					],
				],
				'condition'		=> [ 
					'show_social'  => 'yes',
					'show_top_bar'  => ['yes'],
					'layout_style' => ['layout_one','layout_two', 'layout_three']
				],
			]
		);

		$this->add_control(
			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);		

		$menus = $this->konta_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'konta_menu_select',
				[
					'label'     	=> __( 'Select Konta Menu', 'konta' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'konta' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'konta' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'konta' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

		$this->add_control(
			'show_search_btn',
			[
				'label' 		=> __( 'Show Search Button?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);		

		// $this->add_control(
		// 	'show_cart_btn',
		// 	[
		// 		'label' 		=> __( 'Show Cart Button?', 'konta' ),
		// 		'type' 			=> Controls_Manager::SWITCHER,
		// 		'label_on' 		=> __( 'Show', 'konta' ),
		// 		'label_off' 	=> __( 'Hide', 'konta' ),
		// 		'return_value' 	=> 'yes',
		// 		'default' 		=> 'yes',
		// 		'separator'		=> 'before',
		// 	]
		// );

		$this->add_control(
			'show_offcanvas_btn',
			[
				'label' 		=> __( 'Show Offcanvas Button?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator'		=> 'before',
			]
		);

		$this->add_control(
			'show_btn',
			[
				'label' 		=> __( 'Show Button?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'REGISTER NOW', 'konta' ),
				'condition'		=> [
					'show_btn' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'		=> [
					'show_btn' => [ 'yes' ],
				],
			]
		);

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------General Style-----------------------//
		 $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Background Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		konta_elementor_color_style($this, 'Topbar Background', '{{WRAPPER}} .header-top', ['layout_one', 'layout_two', 'layout_three' ], 'background-color');


		$this->end_controls_section();

		//-------------------------Menu Bar Style-----------------------//
        $this->start_controls_section(
			'menubar_styling3',
			[
				'label'     => __( 'Menu Styling', 'konta' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );
        konta_elementor_color_style($this, 'Text', '{{WRAPPER}} .main-menu>ul>li>a',['layout_one','layout_two', 'layout_three']);
        konta_elementor_color_style($this, 'Text Hover', '{{WRAPPER}} .main-menu>ul>li>a:hover',['layout_one','layout_two', 'layout_three']);
        konta_elementor_color_style($this, 'Dropdown Text', '{{WRAPPER}} .main-menu ul.sub-menu li a',['layout_one','layout_two', 'layout_three']);
        konta_elementor_color_style($this, 'Dropdown Hover', '{{WRAPPER}} .main-menu ul.sub-menu li a:hover',['layout_one','layout_two', 'layout_three']);
        konta_elementor_color_style($this, 'Dropdown Icon', '{{WRAPPER}} .main-menu ul.sub-menu li a:before',['layout_one','layout_two', 'layout_three']);
        konta_elementor_typography_style($this, 'Menu', '{{WRAPPER}} .main-menu>ul>li>a, {{WRAPPER}} .main-menu ul.sub-menu li a',['layout_one','layout_two', 'layout_three']);
        konta_all_elementor_style($this, 'Menu', '{{WRAPPER}} .main-menu>ul>li>a',['layout_one','layout_two', 'layout_three'],'color',0,0,1,1);
      
		$this->end_controls_section();

		
        $this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn', ['layout_one' , 'layout_two', 'layout_three']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn', ['layout_one' , 'layout_two', 'layout_three']);
					konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .th-btn', ['layout_one' , 'layout_two', 'layout_three'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn', ['layout_one' , 'layout_two', 'layout_three']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn:hover', ['layout_one' , 'layout_two', 'layout_three']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn:before, {{WRAPPER}} .th-btn:after', ['layout_one' , 'layout_two', 'layout_three'], 'background-color');
					konta_elementor_border_style($this, 'Button-Hover', '{{WRAPPER}} .th-btn:hover', ['layout_one' , 'layout_two', 'layout_three']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();



    }

    public function konta_menu_select(){
	    $konta_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'konta' );
	    foreach( $konta_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		global $woocommerce;

        //Menu by menu select
        $konta_avaiable_menu   = $this->konta_menu_select();
		if( ! $konta_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['konta_menu_select'],
			'menu_class' 	=> 'konta-menu',
			'container' 	=> '',
		];
		
		//Sticky header on/off
		// if(konta_opt( 'konta_header_sticky_switcher' )){
  //           $sticky_class  = 'yes-sticky';
  //       }else{
  //           $sticky_class  = 'no-sticky';
  //       }

		

		//Mobile menu, Offcanvas, Search
        


		if( class_exists( 'woocommerce' ) ){
    		global $woocommerce;
            if( ! empty( $woocommerce->cart->cart_contents_count ) ){
              $count = $woocommerce->cart->cart_contents_count;
            }else{
              $count = "0";
            } 
    	}

    	echo konta_mobile_menu();
    	if ( $count > 0 ){
			// echo konta_header_cart_offcanvas();
		}
		echo konta_header_offcanvas();
		echo konta_search_box();

				// Header sub-menu icon
		if( class_exists( 'ReduxFramework' ) ){ 
			if(konta_opt('konta_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}


		if( $settings['layout_style'] == 'layout_one' ){

			$email    	= $settings['topbar_email'];
			$phone    	= $settings['topbar_phone'];        

			$email          = is_email( $email );

			$replace        = array(' ','-',' - ');
			$replace_phone  = array(' ','-',' - ', '(', ')');
			$with           = array('','','');

			$emailurl       = str_replace( $replace, $with, $email );
			$phoneurl       = str_replace( $replace_phone, $with, $phone );	

			echo '<div class="th-header header-layout1">';
				if(!empty( $settings['show_top_bar'])) {
			        echo '<div class="header-top" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/header-top1-bg.png">';
			            echo '<div class="container th-container2">';
			                echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
			                    echo '<div class="col-auto d-none d-lg-block">';
			                        echo '<div class="header-links">';
			                            echo '<ul>';
			                            	if( !empty( $settings['topbar_slogan'] )){
				                                echo '<li>'.esc_html( $settings['topbar_slogan'] ).'</li>';
				                            }
				                            if($settings['show_language_switcher']){
	                                        	echo '<li>';
				                                    echo '<div class="dropdown-link">';
				                                        echo '<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-globe"></i> '.esc_html__('Language', 'driller').'</a>';
				                                        echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">';
				                                            echo '<li>';
				                                                echo do_shortcode('[gtranslate]');
				                                            echo '</li>';
				                                        echo '</ul>';
				                                    echo '</div>';
				                                echo '</li>';
	                                    	}
			                            echo '</ul>';
			                        echo '</div>';
			                    echo '</div>';
			                    if(!empty( $settings['show_social'])){
				                    echo '<div class="col-auto">';
				                        echo '<div class="header-links header-right">';
				                            echo '<ul>';
				                                echo '<li>';
				                                    echo '<div class="header-social">';
				                                        foreach( $settings['social_icon_list'] as $social_icon ){
								                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
								                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

								                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

								                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

								                          	echo '</a> ';
								                      	} 
				                                    echo '</div>';
				                                echo '</li>';
				                            echo '</ul>';
				                        echo '</div>';
				                    echo '</div>';
				                }
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    }

		        echo '<div class="sticky-wrapper">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container th-container2">';
		                    echo '<div class="row align-items-center justify-content-between">';

		                        echo '<div class="col-auto">';
		                            if( ! empty( $settings['logo_image']['url'] ) ){
			                            echo '<div class="header-logo">';
			                                echo '<a href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="konta"></a>';
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block sticy-d-none">';
		                            echo '<div class="header-middle">';

		                                echo '<div class="header-link">';
		                                    echo wp_kses_post($settings['topbar_phone_icon']);
		                                    echo '<div>';
		                                        echo '<p>'.esc_html($settings['topbar_phone_label']).'</p>';
		                                        echo '<a class="header-single-link" href="'.esc_attr('tel:' . $phoneurl).'">'.esc_html($phone).'</a>';
		                                    echo '</div>';
		                                echo '</div>';

		                                echo '<div class="header-link">';
		                                    echo wp_kses_post($settings['topbar_email_icon']);
		                                    echo '<div>';
		                                        echo '<p>'.esc_html($settings['topbar_email_label']).'</p>';
		                                        echo '<a  class="header-single-link" href="'.esc_attr('mailto:' . $emailurl).'">'.esc_html($email).'</a>';
		                                    echo '</div>';
		                                echo '</div>';

		                                echo '<div class="header-link d-xl-inline-flex d-none">';
		                                    echo wp_kses_post($settings['office_hours_icon']);
		                                    echo '<div>';
		                                        echo '<p>'.esc_html($settings['office_hours_label']).'</p>';
		                                        echo '<span class="header-single-link">'.esc_html($settings['office_hours']).'</span>';
		                                    echo '</div>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';


		                        echo '<div class="col-auto sticy-d-block">';
		                            echo '<nav class="main-menu '.esc_attr($menu_icon).' d-none d-lg-inline-block">';
		                                if( ! empty( $settings['konta_menu_select'] ) ){
											wp_nav_menu( $args );
										} 
		                            echo '</nav>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-lg-none">';
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                    echo '</div>';



		                    echo '<div class="main-menu-area">';
		                        echo '<div class="row justify-content-between align-items-center">';
		                            echo '<div class="col-auto">';
		                                echo '<nav class="main-menu '.esc_attr($menu_icon).' d-none d-lg-inline-block">';
		                                    if( ! empty( $settings['konta_menu_select'] ) ){
												wp_nav_menu( $args );
											} 
		                                echo '</nav>';
		                            echo '</div>';
		                            echo '<div class="col-auto d-none d-lg-block">';
		                                echo '<div class="header-button">';
		                                	if( $settings['show_search_btn'] == 'yes' ){
			                                    echo '<button type="button" class="icon-btn style2 searchBoxToggler"><i class="far fa-search"></i></button>';
			                                }
			                                if( $settings['show_offcanvas_btn'] == 'yes' ){
			                                    echo '<button type="button" class="icon-btn style2 sideMenuToggler"><i class="fas fa-grid"></i></button>';
			                                }
		                                    if(!empty($settings['button_text'])){
				                                echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style8 ml-25">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-1"></i></a>';
				                            }
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="logo-bg"></div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_two' ){
			$email    	= $settings['topbar_email'];
			$phone    	= $settings['topbar_phone'];        

			$email          = is_email( $email );

			$replace        = array(' ','-',' - ');
			$replace_phone  = array(' ','-',' - ', '(', ')');
			$with           = array('','','');

			$emailurl       = str_replace( $replace, $with, $email );
			$phoneurl       = str_replace( $replace_phone, $with, $phone );	
			echo '<div class="th-header header-layout2">';
		        echo '<div class="container th-container3">';
		            echo '<div class="header-top">';
		                echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
		                    echo '<div class="col-auto d-none d-lg-block">';
		                        echo '<div class="header-links">';
		                            echo '<ul>';
		                                echo '<li>'.wp_kses_post($settings['topbar_phone_icon']).'<a href="'.esc_attr('tel:' . $phoneurl).'">'.esc_html($phone).'</a></li>';
		                                echo '<li class="d-none d-xl-inline-block">'.wp_kses_post($settings['location_icon']).''.esc_html($settings['location']).'</li>';
		                                echo '<li>'.wp_kses_post($settings['topbar_email_icon']).'<a href="'.esc_attr('mailto:' . $emailurl).'">'.esc_html($email).'</a></li>';
		                            echo '</ul>';
		                        echo '</div>';
		                    echo '</div>';
		                    if(!empty( $settings['show_social'])){
			                    echo '<div class="col-auto">';
			                        echo '<div class="header-links header-right">';
			                           echo ' <ul>';
			                                echo '<li>';
			                                    echo '<div class="header-social">';
			                                        echo '<span class="social-title">'.esc_html($settings['social_text']).'</span>';
			                                        foreach( $settings['social_icon_list'] as $social_icon ){
							                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

							                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

							                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

							                          	echo '</a> ';
							                      	}
			                                    echo '</div>';
			                                echo '</li>';
			                            echo '</ul>';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="sticky-wrapper">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container th-container3">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            if( ! empty( $settings['logo_image']['url'] ) ){
			                            echo '<div class="header-logo">';
			                                echo '<a href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="konta"></a>';
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                        echo '<div class="col-auto me-lg-auto">';
		                           	echo '<nav class="main-menu '.esc_attr($menu_icon).' d-none d-lg-inline-block">';
		                                if( ! empty( $settings['konta_menu_select'] ) ){
											wp_nav_menu( $args );
										} 
		                            echo '</nav>';
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-xl-block">';
		                            echo '<div class="header-button">';
		                            	if( $settings['show_search_btn'] == 'yes' ){
			                                echo '<button type="button" class="icon-btn style2 searchBoxToggler"><i class="far fa-search"></i></button>';
			                            }
			                            if( $settings['show_offcanvas_btn'] == 'yes' ){
			                                echo '<button type="button" class="icon-btn style2 sideMenuToggler"><i class="fas fa-grid"></i></button>';
			                            }
			                            if(!empty($settings['button_text'])){
			                                echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style3">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-1"></i></a>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		            echo '<div class="logo-bg" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/logo-bg-3.png">';
		           echo ' </div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_three' ){
			$email    	= $settings['topbar_email'];
			$phone    	= $settings['topbar_phone'];        

			$email          = is_email( $email );

			$replace        = array(' ','-',' - ');
			$replace_phone  = array(' ','-',' - ', '(', ')');
			$with           = array('','','');

			$emailurl       = str_replace( $replace, $with, $email );
			$phoneurl       = str_replace( $replace_phone, $with, $phone );	
			echo '<div class="th-header header-layout3">';
		        echo '<div class="container">';
		            echo '<div class="header-top">';
		                echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
		                    echo '<div class="col-auto d-none d-lg-block">';
		                        echo '<div class="header-links">';
		                            echo '<ul>';
		                                echo '<li>'.wp_kses_post($settings['topbar_phone_icon']).'<a href="'.esc_attr('tel:' . $phoneurl).'">'.esc_html($phone).'</a></li>';
		                                echo '<li class="d-none d-xl-inline-block">'.wp_kses_post($settings['location_icon']).''.esc_html($settings['location']).'</li>';
		                                echo '<li>'.wp_kses_post($settings['topbar_email_icon']).'<a href="'.esc_attr('mailto:' . $emailurl).'">'.esc_html($email).'</a></li>';
		                            echo '</ul>';
		                        echo '</div>';
		                    echo '</div>';
		                    if(!empty( $settings['show_social'])){
			                    echo '<div class="col-auto">';
			                        echo '<div class="header-links header-right">';
			                           echo ' <ul>';
			                                echo '<li>';
			                                    echo '<div class="header-social">';
			                                        echo '<span class="social-title">'.esc_html($settings['social_text']).'</span>';
			                                        foreach( $settings['social_icon_list'] as $social_icon ){
							                          	$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							                          	$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

							                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

							                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

							                          	echo '</a> ';
							                      	}
			                                    echo '</div>';
			                                echo '</li>';
			                            echo '</ul>';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="sticky-wrapper">';
		        	echo '<div class="container">';
			            echo '<!-- Main Menu Area -->';
			            echo '<div class="menu-area">';
			                    echo '<div class="row align-items-center justify-content-between">';
			                        echo '<div class="col-auto">';
			                            if( ! empty( $settings['logo_image']['url'] ) ){
				                            echo '<div class="header-logo">';
				                                echo '<a href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="konta"></a>';
				                            echo '</div>';
				                        }
			                        echo '</div>';
			                        echo '<div class="col-auto me-lg-auto">';
			                           	echo '<nav class="main-menu '.esc_attr($menu_icon).' d-none d-lg-inline-block">';
			                                if( ! empty( $settings['konta_menu_select'] ) ){
												wp_nav_menu( $args );
											} 
			                            echo '</nav>';
			                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
			                        echo '</div>';
			                        echo '<div class="col-auto d-none d-xl-block">';
			                            echo '<div class="header-button">';
			                            	if( $settings['show_search_btn'] == 'yes' ){
				                                echo '<button type="button" class="icon-btn style2 searchBoxToggler"><i class="far fa-search"></i></button>';
				                            }
				                            if( $settings['show_offcanvas_btn'] == 'yes' ){
				                                echo '<button type="button" class="icon-btn style2 sideMenuToggler"><i class="fas fa-grid"></i></button>';
				                            }
				                            if(!empty($settings['button_text'])){
				                                echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style3">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-1"></i></a>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			            	echo '</div>';
			           	echo ' </div>';
		           	echo ' </div>';
		        echo '</div>';
		    echo '</div>';
		}else{

			$email    	= $settings['topbar_email'];
			$phone    	= $settings['topbar_phone'];        

			$email          = is_email( $email );

			$replace        = array(' ','-',' - ');
			$replace_phone  = array(' ','-',' - ', '(', ')');
			$with           = array('','','');

			$emailurl       = str_replace( $replace, $with, $email );
			$phoneurl       = str_replace( $replace_phone, $with, $phone );	
			echo '<div class="th-header header-layout4">';
				if(!empty( $settings['show_top_bar'])) {
			        echo '<div class="container">';
			            echo '<div class="header-top">';
			                
			                echo '<div class="header-link">';
                                echo wp_kses_post($settings['topbar_phone_icon']);
                                echo '<div>';
                                    echo '<p>'.esc_html($settings['topbar_phone_label']).'</p>';
                                    echo '<a class="header-single-link" href="'.esc_attr('tel:' . $phoneurl).'">'.esc_html($phone).'</a>';
                                echo '</div>';
                            echo '</div>';

			                echo '<div class="header-link">';
                                echo wp_kses_post($settings['topbar_email_icon']);
                                echo '<div>';
                                    echo '<p>'.esc_html($settings['topbar_email_label']).'</p>';
                                    echo '<a  class="header-single-link" href="'.esc_attr('mailto:' . $emailurl).'">'.esc_html($email).'</a>';
                                echo '</div>';
                            echo '</div>';

			                echo '<div class="header-link">';
			                    echo wp_kses_post($settings['location_icon']);
			                    echo '<div>';
			                        echo '<p>'.esc_html($settings['location_label']).'</p>';
			                        echo '<a class="header-single-link" href="'.esc_url( $settings['location_url'] ).'">'.esc_html($settings['location']).'</a>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    }
		        echo '<div class="sticky-wrapper">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            if( ! empty( $settings['logo_image']['url'] ) ){
			                            echo '<div class="header-logo">';
			                                echo '<a href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="konta"></a>';
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                        echo '<div class="col-auto me-lg-auto">';
		                            echo '<nav class="main-menu '.esc_attr($menu_icon).' d-none d-lg-inline-block">';
		                                if( ! empty( $settings['konta_menu_select'] ) ){
											wp_nav_menu( $args );
										} 
		                            echo '</nav>';
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-xl-block">';
		                            echo '<div class="header-button">';
		                            	if( $settings['show_search_btn'] == 'yes' ){
			                                echo '<button type="button" class="simple-icon searchBoxToggler"><i class="far fa-search"></i></button>';
			                            }
			                            if( $settings['show_offcanvas_btn'] == 'yes' ){
			                                echo '<button type="button" class="simple-icon sideMenuToggler"><i class="fas fa-grid"></i></button>';
			                            }
			                            if(!empty($settings['button_text'])){
			                                echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-1"></i></a>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}