<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget .
 *
 */
class Konta_A_S_W extends Widget_Base {

	public function get_name() {
		return 'konta_a_u_w';
	}

	public function get_title() {
		return __( 'Konta About us', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta_footer_elements' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Feature', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( ' Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'desc',
			[
				'label'     => __( 'Short Description', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'custom_html',
			[
				'label' => esc_html__( 'information', 'konta' ),
				'type' => Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 10,
			]
		);

        
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="widget footer-widget">';
                echo '<div class="th-widget-about style2">';
                	if( ! empty( $settings['image']['url'] ) ){
	                    echo '<div class="about-logo">';
	                        echo '<a href="'.esc_url( home_url( ) ).'"><img src="'.esc_url( $settings['image']['url'] ).'" alt="Konta"></a>';
	                    echo '</div>';
	                }
	                if( ! empty( $settings['desc'] ) ){
	                    echo '<p class="about-text">'.esc_html( $settings['desc'] ).'</p>';
	                }
	                if( ! empty( $settings['custom_html'] ) ){
	                    echo '<div class="footer-info-grid">';
	                        echo $settings['custom_html'];
	                    echo '</div>';
	                }
                    echo '<form class="newsletter-form form-group">';
                        echo '<input class="form-control" type="email" placeholder="'.esc_attr( 'Enter your email', 'kunta' ).'" required="">';
                        echo '<button type="submit" class="th-btn style3">'.esc_html( 'Subscribe', 'kunta' ).'</button>';
                    echo '</form>';
                echo '</div>';
            echo '</div>';
	    }else{
	    	echo '<div class="widget footer-widget">';
                echo '<div class="th-widget-about">';
                    if( ! empty( $settings['image']['url'] ) ){
	                    echo '<div class="about-logo">';
	                        echo '<a href="'.esc_url( home_url( ) ).'"><img src="'.esc_url( $settings['image']['url'] ).'" alt="Konta"></a>';
	                    echo '</div>';
	                }
	                if( ! empty( $settings['desc'] ) ){
	                    echo '<p class="about-text mb-4">'.esc_html( $settings['desc'] ).'</p>';
	                }
	                if( ! empty( $settings['custom_html'] ) ){
	                    echo '<div class="th-widget-contact">';
	                    	echo $settings['custom_html'];
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
	    }
	}
}