<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Konta_Banner extends Widget_Base {

	public function get_name() {
		return 'kontabanner';
	}

	public function get_title() {
		return __( 'Banner', 'konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konta_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Konta Banner Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two' 		=> __( 'Style Two', 'konta' ),
					'layout_three' 		=> __( 'Style Three', 'konta' ),
					'layout_four' 		=> __( 'Style Four', 'konta' ),
					'layout_five' 		=> __( 'Style Five', 'konta' ),
				],
			]
		);

		/*-----------------------------------------style one ------------------------------------*/
		$repeater = new Repeater();
		$repeater->add_control(
			'banner_heading', [
				'label' 		=> __( 'Heading', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'GET DISCOUNT 25% DURING COVID - 19r' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Classical Education' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Grursus mal suada faci lisis Lorem ipsum dolarorit more that ametion fadolorit to the consectetur elit.' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$repeater->add_control(
			'button_text2',
			[
				'label' 	=> esc_html__( 'Button Text 2', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link2',
			[
				'label' 		=> esc_html__( 'Button url 2', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $repeater->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video url', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
            'heading_img',
            [
                'label'     => __( 'Heading Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(

			'banner_1',
			[
				'label' 		=> __( 'Banner Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_heading' => __( 'Add Social Icon','konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_heading.value }}}',
				'condition'	=> ['layout_style' => ['layout_one']]
			]
		);


		/*-----------------------------------------style two ------------------------------------*/
		$repeater = new Repeater();
		$repeater->add_control(
			'banner_heading', [
				'label' 		=> __( 'Heading', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'GET DISCOUNT 25% DURING COVID - 19r' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Classical Education' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Classical Education' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Grursus mal suada faci lisis Lorem ipsum dolarorit more that ametion fadolorit to the consectetur elit.' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$repeater->add_control(
			'button_text2',
			[
				'label' 	=> esc_html__( 'Button Text 2', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link2',
			[
				'label' 		=> esc_html__( 'Button url 2', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(

			'banner_2',
			[
				'label' 		=> __( 'Banner Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_heading' => __( 'Add Social Icon','konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_heading.value }}}',
				'condition'	=> ['layout_style' => ['layout_two', 'layout_three']]
			]
		);

		/*-----------------------------------------style three ------------------------------------*/
		$repeater = new Repeater();
		$repeater->add_control(
			'banner_heading', [
				'label' 		=> __( 'Heading', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'GET DISCOUNT 25% DURING COVID - 19r' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Classical Education' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$repeater->add_control(
			'button_text2',
			[
				'label' 	=> esc_html__( 'Button Text 2', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link2',
			[
				'label' 		=> esc_html__( 'Button url 2', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(
			'banner_3',
			[
				'label' 		=> __( 'Banner Slider', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_heading' => __( 'Add Social Icon','konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_heading.value }}}',
				'condition'	=> ['layout_style' => ['layout_four','layout_five']]
			]
		);

		$this->add_control(
            'overlay_img',
            [
                'label'     => __( 'Overlay Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );

		

		
        $this->end_controls_section();

  
        //---------------------------------------Subtitle Style---------------------------------------//

		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Heading', '{{WRAPPER}} .hero-subtitle',['layout_one', 'layout_four'] );
		konta_all_elementor_style($this, 'Tag', '{{WRAPPER}} .hero-style2 .hero-meta span',['layout_two'] );
		konta_all_elementor_style($this, 'Subtitle', '{{WRAPPER}} .hero-subtitle',['layout_three', 'layout_five'] );
		
		
		$this->end_controls_section();

        //---------------------------------------Title Style---------------------------------------//

		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} h1',['layout_one' ] );
		konta_all_elementor_style($this, 'Title 2', '{{WRAPPER}} .text-white',['layout_two', 'layout_three','layout_four','layout_five'], '--white-color' );
		
		$this->end_controls_section();

	
		//-------------------------Button Style-----------------------//
		
		$this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'First Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn.style3', ['layout_one', 'layout_two', 'layout_three', 'layout_four','layout_five']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn.style3', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
					konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .th-btn.style3', ['layout_one', 'layout_two', 'layout_three', 'layout_four'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn.style3', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn.style3:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn.style3:before, {{WRAPPER}} .th-btn.style3:after', ['layout_one', 'layout_two', 'layout_three', 'layout_four'], 'background-color');
					konta_elementor_border_style($this, 'Button-Hover', '{{WRAPPER}} .th-btn.style3:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();

		//-------------------------Button Style 2-----------------------//
		
		$this->start_controls_section(
		    'button_style_section2',
		    [
		        'label' => __( '2nd Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button 2', '{{WRAPPER}} .th-btn.style2', ['layout_one', 'layout_two', 'layout_three', 'layout_four','layout_five']);

			$this->start_controls_tabs(
			    'style_tabs2'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab2',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button 2 Text', '{{WRAPPER}} .th-btn.style2', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
					konta_elementor_color_style($this, 'Background 2', '{{WRAPPER}} .th-btn.style2', ['layout_one', 'layout_two', 'layout_three', 'layout_four'], 'background-color');
					konta_elementor_border_style($this, 'Button-2', '{{WRAPPER}} .th-btn.style2', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab2',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, '2nd Button Text Hover', '{{WRAPPER}} .th-btn.style2:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
					konta_elementor_color_style($this, '2nd Background Hover', '{{WRAPPER}} .th-btn.style2:before, {{WRAPPER}} .th-btn.style2:after', ['layout_one', 'layout_two', 'layout_three', 'layout_four'], 'background-color');
					konta_elementor_border_style($this, 'Button-2-Hover', '{{WRAPPER}} .th-btn.style2:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//

		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['layout_style' => ['layout_one', 'layout_two']]
			]
		);
		konta_all_elementor_style($this, 'Description', '{{WRAPPER}} .hero-text',['layout_one', 'layout_two'] );
		
		$this->end_controls_section();

     
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == 'layout_one' ){

			echo '<div class="th-hero-wrapper hero-1" id="hero">';
		        echo '<div class="hero-slider-1 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-dots="true" data-adaptive-height="true">';

		        	foreach( $settings['banner_1'] as $data ){
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'">';
				                	if(!empty($settings['overlay_img']['url'])){
					                    echo konta_img_tag( array(
				                        	'url' => esc_url( $settings['overlay_img']['url'] ),
				                        ) );
					                }
				                echo '</div>';
				            }

			                echo '<div class="container">';
			                    echo '<div class="row align-items-center">';
			                        echo '<div class="col-xxl-8 col-lg-7 col-md-8">';
			                            echo '<div class="hero-style1">';
			                            	if(!empty($data['banner_heading'])){
				                                echo '<span class="hero-subtitle" data-ani="slideinleft" data-ani-delay="0.1s">';
					                                if(!empty($data['heading_img']['url'])){
									                    echo konta_img_tag( array(
								                        	'url' => esc_url( $data['heading_img']['url'] ),
								                        ) );
									                }
					                                echo esc_html($data['banner_heading']);
				                                echo '</span>';
				                            }
				                            if(!empty($data['banner_title1'])){
				                                echo '<h1 class="hero-title text-white" data-ani="slideinleft" data-ani-delay="0.4s">'.wp_kses_post($data['banner_title1']).'</h1>';
				                            }
				                            if(!empty($data['banner_desc'])){
				                                echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.6s">'.esc_html($data['banner_desc']).'</p>';
				                            }
			                                echo '<div class="btn-group" data-ani="slideinleft" data-ani-delay="0.8s">';
			                                	if(!empty($data['button_text'])){
						                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
						                        if(!empty($data['button_text2'])){
						                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                        if(!empty( $data['video_link']['url'] )){
				                        echo '<div class="col-xxl-4 col-lg-5 col-md-4">';
				                            echo '<div class="hero-video-wrap text-center">';
				                                echo '<a href="'.esc_url( $data['video_link']['url'] ).'" class="play-btn style3 popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
				                            echo '</div>';
				                        echo '</div>';
				                    }
			                    echo '</div>';
			               echo ' </div>';
			            echo '</div>';
			        }
		        echo '</div>';
		        echo '<div class="hero-shape"></div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_two' ){
			echo '<div class="th-hero-wrapper hero-2" id="hero">';
		        echo '<div class="hero-slider-2 th-carousel" id="heroSlide6" data-slide-show="1" data-md-slide-show="1" data-fade="true">';

		        	foreach( $settings['banner_2'] as $data ){
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'">';
				                	if(!empty($settings['overlay_img']['url'])){
					                    echo konta_img_tag( array(
				                        	'url' => esc_url( $settings['overlay_img']['url'] ),
				                        ) );
					                }
				                echo '</div>';
				            }
				            echo '<div class="big-text" data-ani="slideindown" data-ani-delay="0.2s">'.esc_html( get_bloginfo('name') ).'</div>';
			                echo '<div class="container th-container">';
			                    echo '<div class="hero-style2">';
			                    	if(!empty($data['banner_heading'])){
				                        echo '<div class="hero-meta" data-ani="slideindown" data-ani-delay="0.5s">';
				                            echo wp_kses_post($data['banner_heading']);
				                        echo '</div>';
				                    }
				                    if(!empty($data['banner_title1'])){
		                                echo '<h1 class="hero-title text-white" data-ani="slideindown" data-ani-delay="0.4s">'.wp_kses_post($data['banner_title1']).'</h1>';
		                            }
		                            if(!empty($data['banner_title2'])){
		                                echo '<h1 class="hero-title text-white" data-ani="slideindown" data-ani-delay="0.1s">'.wp_kses_post($data['banner_title2']).'</h1>';
		                            }
		                            if(!empty($data['banner_desc'])){
		                                echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.1s">'.esc_html($data['banner_desc']).'</p>';
		                            }
			                        echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.5s">';
			                        	if(!empty($data['button_text'])){
				                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text2'])){
				                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }
		        echo '</div>';
		        echo '<div class="icon-box">';
		            echo '<button data-slick-prev="#heroSlide6" class="slick-arrow default"><i class="far fa-chevron-left"></i></button>';
		            echo '<button data-slick-next="#heroSlide6" class="slick-arrow default"><i class="far fa-chevron-right"></i></button>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_three' ){
			echo '<div class="th-hero-wrapper hero-3" id="hero">';
		        echo '<div class="hero-slider-3 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-arrows="true">';
		        	foreach( $settings['banner_2'] as $data ){
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['banner_img']['url'] ).'"></div>';
				            }
			                if(!empty($settings['overlay_img']['url'])){
			                	echo '<div class="banner-anime-img" data-bg-src="'.esc_url( $settings['overlay_img']['url'] ).'"></div>';
			                }
			                echo '<div class="container">';
			                    echo '<div class="row align-items-center">';
			                        echo '<div class="col-lg-7">';
			                            echo '<div class="hero-style3 text-center">';
			                            	if(!empty($data['banner_heading'])){
				                                echo '<span class="hero-subtitle" data-ani="slideinup" data-ani-delay="0.1s">'.esc_html($data['banner_heading']).'</span>';
				                            }
				                            if(!empty($data['banner_title1'])){
				                                echo '<h1 class="hero-title text-white" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['banner_title1']).'</h1>';
				                            }
				                            if(!empty($data['banner_title2'])){
				                                echo '<h1 class="hero-title text-white fw-normal" data-ani="slideinup" data-ani-delay="0.5s">'.esc_html($data['banner_title2']).'</h1>';
				                            }
			                                echo '<div class="btn-group justify-content-center" data-ani="slideinup" data-ani-delay="0.6s">';
			                                	if(!empty($data['button_text'])){
						                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
						                        if(!empty($data['button_text2'])){
						                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="th-hero-wrapper hero-4" id="hero">';
		        echo '<div class="hero-slider-4 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-dots="false" data-arrows="true" data-adaptive-height="true">';

		        	foreach( $settings['banner_3'] as $data ){
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['banner_img']['url'] ).'">';
				                	if(!empty($settings['overlay_img']['url'])){
					                    echo konta_img_tag( array(
				                        	'url' => esc_url( $settings['overlay_img']['url'] ),
				                        ) );
					                }
				                echo '</div>';
				            }

			                echo '<div class="container">';
			                    echo '<div class="row align-items-center justify-content-center">';
			                        echo '<div class="col-lg-10">';
			                            echo '<div class="hero-style4 text-center">';
			                            	if(!empty($data['banner_heading'])){
				                                echo '<span class="hero-subtitle" data-ani="slideinup" data-ani-delay="0.1s">'.esc_html($data['banner_heading']).'</span>';
				                            }
				                            if(!empty($data['banner_title1'])){
				                                echo '<h1 class="hero-title text-white" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['banner_title1']).'</h1>';
				                            }
			                                echo '<div class="btn-group justify-content-center" data-ani="slideinup" data-ani-delay="0.8s">';
			                                	if(!empty($data['button_text'])){
						                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
						                        if(!empty($data['button_text2'])){
						                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }
		        echo '</div>';
		    echo '</div>';
		}else{
			echo '<div class="th-hero-wrapper hero-5" id="hero">';
		        echo '<div class="hero-slider-5 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-dots="true" data-xl-dots="true" data-ml-dots="true" data-lg-dots="true" data-md-dots="true" data-arrows="false" data-adaptive-height="true">';

		        	foreach( $settings['banner_3'] as $data ){
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['banner_img']['url'] ).'"></div>';
				            }
			                echo '<div class="container">';
			                    echo '<div class="row align-items-center">';
			                        echo '<div class="col-xxl-8 col-xl-7 col-lg-7">';
			                            echo '<div class="hero-style5">';
			                            	if(!empty($data['banner_heading'])){
				                                echo '<span class="hero-subtitle" data-ani="slideinup" data-ani-delay="0.1s">'.esc_html($data['banner_heading']).'</span>';
				                            }
				                            if(!empty($data['banner_title1'])){
				                                echo '<h1 class="hero-title text-white" data-ani="slideinup" data-ani-delay="0.4s">'.wp_kses_post($data['banner_title1']).'</h1>';
				                            }
			                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.8s">';
			                                	if(!empty($data['button_text'])){
						                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
						                        if(!empty($data['button_text2'])){
						                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
						                        }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }


		            
		        echo '</div>';
		        echo '<div class="scroll-down">';
		            echo '<a href="#about-sec" class="hero-5-scroll-wrap"></a>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}