<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Brand Box Widget .
 *
 */
class Konta_Brand extends Widget_Base {

	public function get_name() {
		return 'kontabrand';
	}

	public function get_title() {
		return __( 'Konta Brand', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'brandd_section',
			[
				'label' 	=> __( 'Brand', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Brand Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style four', 'konta' ),
				]
			]
		);
		
		
        $this->end_controls_section();




	    include konta_get_elementor_option('brand-one-options.php');
	    include konta_get_elementor_option('brand-two-options.php');

	

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .text-white',['layout_one'], '--white-color' );
		konta_all_elementor_style($this, 'Subtitle', '{{WRAPPER}} .text-light',['layout_one'], '--light-color' );
		konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .bg-title', ['layout_three'], '--title-color');

        $this->end_controls_section();
       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="container">';
		        echo '<div class=" bg-title z-index-common">';
		            echo '<div class="client-area-1">';
		                echo '<div class="row align-items-center">';
		                    echo '<div class="col-lg-6">';
		                        echo '<div class="title-area mb-lg-0 text-lg-start text-center">';
		                        	if( ! empty( $settings['title']) ){
			                            echo '<h2 class="sec-title text-white title-selector">'.esc_html($settings['title']).'</h2>';
			                        }
			                        if( ! empty( $settings['subtitle']) ){
			                            echo '<p class="text-light sub-selector">'.esc_html($settings['subtitle']).'</p>';
			                        }
		                            echo '<div class="icon-box">';
		                                echo '<button data-slick-prev=".client-slider1" class="slick-arrow default"><i class="far fa-arrow-left"></i></button>';
		                                echo '<button data-slick-next=".client-slider1" class="slick-arrow default"><i class="far fa-arrow-right"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="col-lg-6">';
		                        echo '<div class="client-slider1 th-carousel">';
		                            echo '<div class="client-wrap text-center">';
		                                echo '<div class="row gy-5 justify-content-center">';

		                                	foreach ( $settings['gallery_1'] as $data ) {
			                                    echo '<div class="col-sm-3 col-6">';
			                                        echo '<div class="client-thumb">';
			                                            echo konta_img_tag( array(
								                            'url'       => esc_url( $data['url'] ),
								                        ) );
			                                        echo '</div>';
			                                    echo '</div>';
			                                }
		                                    

		                                echo '</div>';
		                            echo '</div>';
		                            echo '<div class="client-wrap text-center">';
		                                echo '<div class="row gy-5 justify-content-center">';

		                                    foreach ( $settings['gallery_2'] as $data ) {
			                                    echo '<div class="col-sm-3 col-6">';
			                                        echo '<div class="client-thumb">';
			                                            echo konta_img_tag( array(
								                            'url'       => esc_url( $data['url'] ),
								                        ) );
			                                        echo '</div>';
			                                    echo '</div>';
			                                } 
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="bg-title overflow-hidden client-area-2">';
		        echo '<div class="container-fluid">';
		            echo '<div class="row th-carousel" data-slide-show="8" data-md-slide-show="6" data-sm-slide-show="3" data-xs-slide-show="2">';
		                
		                foreach ( $settings['2_gallery'] as $data ) {
                            echo '<div class="col-lg-auto text-center">';
                                echo '<div class="client-thumb">';
                                    echo konta_img_tag( array(
			                            'url'       => esc_url( $data['url'] ),
			                        ) );
                                echo '</div>';
                            echo '</div>';
                        }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="client-area-3 bg-title">';
	            echo '<div class="container-fluid">';
	                echo '<div class="row th-carousel" data-slide-show="8" data-lg-slide-show="7" data-md-slide-show="6" data-sm-slide-show="3" data-xs-slide-show="2">';
	                    foreach ( $settings['2_gallery'] as $data ) {
		                    echo '<div class="col-lg-auto text-center">';
		                        echo '<div class="client-thumb">';
                                    echo konta_img_tag( array(
			                            'url'       => esc_url( $data['url'] ),
			                        ) );
                                echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';
	    }else{
	    	echo '<div class="client-area-5 ">';
		        echo '<div class="container th-container3">';
		            echo '<div class="row th-carousel client-slider5" data-slide-show="7" data-lg-slide-show="6" data-md-slide-show="4" data-sm-slide-show="3" data-xs-slide-show="2">';
		            	foreach ( $settings['2_gallery'] as $data ) {
			                echo '<div class="col-lg-auto text-center">';
			                    echo '<a href="blog.html" class="client-thumb">';
			                        echo konta_img_tag( array(
			                            'url'       => esc_url( $data['url'] ),
			                        ) );
			                    echo '</a>';
			                echo '</div>';
			            }

		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
	    }
	}
}