<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget .
 *
 */
class Konta_Feature extends Widget_Base {

	public function get_name() {
		return 'kontafeature';
	}

	public function get_title() {
		return __( 'Konta Feature', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Feature', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Feature Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
				],
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'details_page',
			[
				'label'     => __( 'Details Page', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'features',
			[
				'label' 		=> __( 'Features', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition' => [
					'layout_style' => ['layout_one' , 'layout_two', 'layout_four']
				]
			]
		);

        //--------------------------style three--------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $this->add_control(
			'features2',
			[
				'label' 		=> __( 'Features', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition' => [
					'layout_style' => ['layout_three']
				]
			]
		);
        
        $this->end_controls_section();


        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector, {{WRAPPER}} .title-selector a',['layout_one', 'layout_two' , 'layout_three', 'layout_four'] );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Description Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_one', 'layout_two' , 'layout_three', 'layout_four'] );

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if( $settings['layout_style'] == 'layout_one' ){
        	foreach( $settings['features'] as $data ) {    
	        	echo '<div class="about-grid2">';
	        		if( ! empty( $data['image']['url'] ) ){
		                echo '<div class="icon">';
		                    echo konta_img_tag( array(
								'url'   => esc_url( $data['image']['url'] ),
							) );
		                echo '</div>';
		            }
	                echo '<div class="about-grid-details">';
	                	if( ! empty( $data['title'] ) ){
		                    echo '<h3 class="about-grid_title title-selector h6">'.esc_html( $data['title'] ).'</h3>';
		                }
		                if( ! empty( $data['content'] ) ){
		                    echo '<p class="desc-selector">'.esc_html( $data['content'] ).'</p>';
		                }

	                echo '</div>';
	            echo '</div>';
	        }
	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="row g-4">';
       			foreach( $settings['features'] as $data ) {    
	                echo '<div class="col-sm-6">';
	                    echo '<div class="wcu-box style2">';
	                    	if( ! empty( $data['image']['url'] ) ){
				                echo '<div class="wcu-box_icon">';
				                    echo konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
				                echo '</div>';
				            }
	                        echo '<div class="wcu-box_details">';
	                        	if( ! empty( $data['title'] ) ){
		                            echo '<h3 class="h5 wcu-box_title title-selector"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h3>';
		                        }
		                        if( ! empty( $data['content'] ) ){
		                            echo '<p class="wcu-box_text desc-selector">'.esc_html( $data['content'] ).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	               	echo ' </div>';
               	} 
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="feature-area-1 overflow-hidden">';
		        echo '<div class="container-fluid p-0">';
		            echo '<ul class="feature-card-wrap">';
		            	$i = 0;
		                foreach( $settings['features2'] as $data ) {  
		                	$i++;
		                	$active = $i == 2 ? 'feature-card-active' : '';

		                	echo '<li class="feature-card  '.esc_attr( $active ).'">';
			                    if( ! empty( $data['image']['url'] ) ){
					                echo '<div class="feature-card_icon">';
					                    echo konta_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
					                echo '</div>';
					            }
			                    echo '<div class="feature-card_details">';
			                        echo '<h3 class="feature-card_title"><a href="service-details.html">New Public Attitude Tracker Towards Wind Turbine Energy.</a></h3>';
			                    echo '</div>';
			                    echo '<div class="feature-card-active-wrap">';
			                        if( ! empty( $data['image']['url'] ) ){
						                echo '<div class="feature-card_icon">';
						                    echo konta_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
						                echo '</div>';
						            }
			                        echo '<div class="feature-card_details">';
			                            if( ! empty( $data['title'] ) ){
				                            echo '<h3 class="feature-card_title title-selector"><a href="'.esc_url($data['button_link']['url']).'">'.esc_html( $data['title'] ).'</a></h3>';
				                        }
			                            if( ! empty( $data['content'] ) ){
				                            echo '<p class="feature-card_text desc-selector">'.esc_html( $data['content'] ).'</p>';
				                        }
			                            echo '<a href="'.esc_url($data['button_link']['url']).'" class="btn-wrap">';
			                                echo '<div class="icon-btn style2"><i class="far fa-arrow-up-right"></i></div>';
			                                echo '<span class="link-btn style2">'.esc_html($data['button_text']).'</span>';
			                            echo '</a>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</li>';
			            }
		           echo ' </ul>';
		       echo ' </div>';
		    echo '</div>';
	    }else{
	    	echo '<div class="wcu-grid-wrap">';
                foreach( $settings['features'] as $data ) {   
                	if( ! empty( $data['title'] ) ){            
		                echo '<h5 class="wcu-grid-title title-selector">'.wp_kses_post( $data['title'] ).'</h5>';
		            }
	                echo '<div class="wcu-grid mb-25">';
	                	if( ! empty( $data['image']['url'] ) ){
			                echo '<div class="wcu-grid-icon">';
			                    echo konta_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								) );
			                echo '</div>';
			            }
			            if( ! empty( $data['content'] ) ){
		                    echo '<p class="wcu-grid-content desc-selector">'.esc_html( $data['content'] ).'</p>';
		                }
	                echo '</div>';
	            }
            echo '</div>';
	    }
	}
}