<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Box Widget .
 *
 */
class Konta_Video_Thumb extends Widget_Base {

	public function get_name() {
		return 'kontavdothumb';
	}

	public function get_title() {
		return __( 'Konta Video Thumb', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Video Box', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( ' Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
				],
			]
		);
        $this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'video',
			[
				'label'     => __( 'Video URL', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 	=> 'https://www.youtube.com/watch?v=_sI_Ps7JSEk',
			]
        );

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
	        echo '<div class="img-box5">';
	        	if( ! empty( $settings['image']['url'] ) ){
		            echo '<div class="img1">';
		            	echo konta_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
							'class' => 'tilt-active'
						) );
		            echo '</div>';
		        }
	            echo '<a href="'.esc_url( $settings['video'] ).'" class="play-btn style5 popup-video" tabindex="-1"><i class="fa-sharp fa-solid fa-play"></i></a>';
	        echo '</div>';
	    }else{
	        	
	            echo '<a href="'.esc_url( $settings['video'] ).'" class="play-btn style3  popup-video" tabindex="-1"><i class="fa-sharp fa-solid fa-play"></i></a>';
	    }
	}

}