<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * About Us Widget .
 *
 */
class Konta_About_Us_2 extends Widget_Base {

	public function get_name() {
		return 'drilleraboutus';
	}

	public function get_title() {
		return __( 'Konta About Us v2', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'aboutus_section',
			[
				'label' 	=> __( 'Play Button', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'heading',
			[
				'label'     => __( 'Heding', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __('OUR STORY','konta'),
			]
        );
        $this->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __('OUR STORY','konta'),
			]
        );
        $this->add_control(
			'desc',
			[
				'label'     => __( 'Description', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 3,
                'default' 		=> __('OUR STORY','konta'),
			]
        );
        $this->add_control(
			'btn_text',
			[
				'label'     => __( 'Button Text 1', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __('OUR STORY','konta'),
			]
        );
        $this->add_control(
			'btn_url',
			[
				'label'     => __( 'Button Url 1', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __('OUR STORY','konta'),
			]
        );
        $this->add_control(
			'btn_text2',
			[
				'label'     => __( 'Button Text 2', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __('OUR STORY','konta'),
			]
        )
        ;$this->add_control(
			'btn_url2',
			[
				'label'     => __( 'Button Url 2', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __('OUR STORY','konta'),
			]
        );
        $this->add_control(
			'shape_image',
			[
				'label' 		=> __( 'Shape Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'thumb_image',
			[
				'label' 		=> __( 'Thumb Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'video_link',
			[
				'label' 		=> __( 'Video Url', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
                'default' 		=> __('#','konta'),
                'placeholder' 	=> __( 'https://your-link.com', 'konta' ),

			]
        );	
        $this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Section Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'section_title_color',
			[
				'label' 	=> __( 'Section Title Color', 'konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-selector' => 'color: {{VALUE}}!important;',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __( 'Section Title Typography', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .title-selector',
			]
		);

        $this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __( 'Section Title Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .title-selector' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __( 'Section Title Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .title-selector' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

        $this->end_controls_section();


        //-------------------------------------subtitle styling-------------------------------------//

        $this->start_controls_section(
			'section_subtitle_style_section',
			[
				'label' => __( 'Section Subtitle Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'section_subtitle_color',
			[
				'label' 		=> __( 'Section Subtitle Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .subtitle-selector' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_subtitle_typography',
				'label' 	=> __( 'Section Subtitle Typography', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .subtitle-selector',
			]
        );

        $this->add_responsive_control(
			'section_subtitle_margin',
			[
				'label' 		=> __( 'Section Subtitle Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .subtitle-selector' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

			]
        );
        $this->add_responsive_control(
			'section_subtitle_padding',
			[
				'label' 		=> __( 'Section Subtitle Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .subtitle-selector' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Section Description Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'section_desc_color',
			[
				'label' 		=> __( 'Section Description Color', 'konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .desc-selector' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_desc_typography',
				'label' 	=> __( 'Section Description Typography', 'konta' ),
                'selector' 	=> '{{WRAPPER}} .desc-selector',
			]
        );

        $this->add_responsive_control(
			'section_desc_margin',
			[
				'label' 		=> __( 'Section Description Margin', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .desc-selector' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'section_desc_padding',
			[
				'label' 		=> __( 'Section Description Padding', 'konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .desc-selector' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<div class="img-right th-video2">';
    		if(!empty($settings['thumb_image']['url'])){
	            echo '<img src="'.esc_url($settings['thumb_image']['url']).'" alt="mockup">';
	        }
            echo '<div class="play-bg">';
            	if(!empty($settings['shape_image']['url'])){
	                echo '<img src="'.esc_url($settings['shape_image']['url']).'" alt="shape">';
	            }
                echo '<a href="'.esc_url($settings['video_link']).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
            echo '</div>';
        echo '</div>';
        echo '<div class="container z-index-common">';
            echo '<div class="row">';
                echo '<div class="col-xl-6 space">';
                    echo '<div class="title-area mb-30">';
                    	if(!empty($settings['heading'])){
	                        echo '<span class="sub-title text-white title-selector">'.esc_html($settings['heading']).'<span class="shape right"><span class="dots"></span></span></span>';
	                    }
	                    if(!empty($settings['title'])){
	                        echo '<h2 class="sec-title text-white subtitle-selector">'.esc_html($settings['title']).'</h2>';
	                    }
                    echo '</div>';
                    if(!empty($settings['desc'])){
	                    echo '<p class="mt-n2 mb-30 text-white desc-selector">'.esc_html($settings['desc']).'</p>';
	                }
                    echo '<div class="btn-group">';
                    	if(!empty($settings['btn_text'])){
	                        echo '<a href="'.esc_url($settings['btn_url']).'" class="th-btn style3">'.esc_html($settings['btn_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
	                    }
	                    if(!empty($settings['btn_text2'])){
	                        echo '<a href="'.esc_url($settings['btn_url2']).'" class="th-btn style4">'.esc_html($settings['btn_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
	                    }
	                    
                        
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
	}

}