<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Konta_Banner_2 extends Widget_Base {

	public function get_name() {
		return 'drillerbanner';
	}

	public function get_title() {
		return __( 'Banner v5', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'banner_style',
			[
				'label' 		=> __( 'Banner Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
					'4' 		=> __( 'Style Four', 'Konta' ),
				],
			]
		);

		/*-----------------------------------------style one ------------------------------------*/

		$repeater = new Repeater();

        $repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
			'tag1', [
				'label' 		=> __( 'Tag 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Service' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'tag2', [
				'label' 		=> __( 'Tag 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Repair' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'tag3', [
				'label' 		=> __( 'Tag 3', 'Konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Estimation' , 'Konta' ),
				'label_block' 	=> true,
			]
        );


        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'WORLD BEST <span class="bg-theme">INDUSTRY</span>' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SOLUTIONS HERE' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Enthusiastically provide access to client-focused testing procedures through cooperative niches. Intrinsicly promote compelling methods of empowerment before.' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text_1',
			[
				'label' 	=> esc_html__( 'First Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link_1',
			[
				'label' 		=> esc_html__( 'First Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'button_text_2',
			[
				'label' 	=> esc_html__( 'Second Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Latest Projects', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link_2',
			[
				'label' 		=> esc_html__( 'Second Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		
		$this->add_control(
			'banners_one',
			[
				'label' 		=> __( 'Banners', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_title' 		=> __( 'Banner One', 'Konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_title }}}',
				'condition'	=> ['banner_style' => '1']
			]
		);

		/*-----------------------------------------style two ------------------------------------*/

		$repeater = new Repeater();

        $repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
            'shape_img',
            [
                'label'     => __( 'Shape Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
			'tag1', [
				'label' 		=> __( 'Tag 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Service' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'tag2', [
				'label' 		=> __( 'Tag 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Repair' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'shadow_text', [
				'label' 		=> __( 'Shadow Text', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'KONTA' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'WORLD BEST <span class="bg-theme">INDUSTRY</span>' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SOLUTIONS HERE' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Enthusiastically provide access to client-focused testing procedures through cooperative niches. Intrinsicly promote compelling methods of empowerment before.' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text_1',
			[
				'label' 	=> esc_html__( 'First Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link_1',
			[
				'label' 		=> esc_html__( 'First Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'button_text_2',
			[
				'label' 	=> esc_html__( 'Second Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Latest Projects', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link_2',
			[
				'label' 		=> esc_html__( 'Second Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $repeater->add_control(
			'video_url',
			[
				'label' 	=> esc_html__( 'Video url', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( '#', 'Konta' ),
			]
        );
		
		$this->add_control(
			'banners_two',
			[
				'label' 		=> __( 'Banners', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_title' 		=> __( 'Banner Two', 'Konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_title }}}',
				'condition'	=> ['banner_style' => '2']
			]
		);

		/*-----------------------------------------style two ------------------------------------*/

		$repeater = new Repeater();

        $repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
            'shape_img',
            [
                'label'     => __( 'Shape Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
			'heading', [
				'label' 		=> __( 'Heading', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'KONTA' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'WORLD BEST <span class="bg-theme">INDUSTRY</span>' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SOLUTIONS HERE' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Enthusiastically provide access to client-focused testing procedures through cooperative niches. Intrinsicly promote compelling methods of empowerment before.' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text_1',
			[
				'label' 	=> esc_html__( 'First Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link_1',
			[
				'label' 		=> esc_html__( 'First Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'button_text_2',
			[
				'label' 	=> esc_html__( 'Second Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Latest Projects', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link_2',
			[
				'label' 		=> esc_html__( 'Second Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
	
		$this->add_control(
			'banners_three',
			[
				'label' 		=> __( 'Banners', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_title' 		=> __( 'Banner Two', 'Konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_title }}}',
				'condition'	=> ['banner_style' => '3']
			]
		);

/*-----------------------------------------style Four ------------------------------------*/
		$this->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['banner_style' => '4']
            ]
        );
        $this->add_control(
            'banner_img2',
            [
                'label'     => __( 'Banner Image 2', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['banner_style' => '4']
            ]
        );        
        $this->add_control(
            'banner_img3',
            [
                'label'     => __( 'Banner Image 3', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['banner_style' => '4']
            ]
        );
		$this->add_control(
			'heading', [
				'label' 		=> __( 'Heading', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'KONTA' , 'Konta' ),
				'label_block' 	=> true,
				'condition'	=> ['banner_style' => '4']
			]
        );
        $this->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'WORLD BEST <span class="bg-theme">INDUSTRY</span>' , 'Konta' ),
				'label_block' 	=> true,
				'condition'	=> ['banner_style' => '4']
			]
        );
        $this->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 4,
				'default' 		=> __( 'Enthusiastically provide access to client-focused testing procedures through cooperative niches. Intrinsicly promote compelling methods of empowerment before.' , 'Konta' ),
				'label_block' 	=> true,
				'condition'	=> ['banner_style' => '4']
			]
        );
        $this->add_control(
			'button_text_1',
			[
				'label' 	=> esc_html__( 'First Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
                'condition'	=> ['banner_style' => '4']
			]
        );

        $this->add_control(
			'button_link_1',
			[
				'label' 		=> esc_html__( 'First Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['banner_style' => '4']
			]
		);
		$this->add_control(
			'button_text_2',
			[
				'label' 	=> esc_html__( 'Second Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Latest Projects', 'Konta' ),
                'condition'	=> ['banner_style' => '4']
			]
        );		

        $this->add_control(
			'button_text_22',
			[
				'label' 	=> esc_html__( 'Second Button Text 2', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( '', 'Konta' ),
                'condition'	=> ['banner_style' => '4']
			]
        );

        $this->add_control(
			'button_link_2',
			[
				'label' 		=> esc_html__( 'Second Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['banner_style' => '4']
			]
		);

		$this->end_controls_section();

		

        //---------------------------------------Title Style---------------------------------------//

		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h1' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} h1',
			]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Title Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Title Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

			//---------------------------------------subtitle Style---------------------------------------//

		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'banner_style' => '4',
				]
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( ' Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-subtitle' => '--theme-color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'subtitle_typography',
				'label' 	=> __( ' Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .hero-subtitle',
			]
        );
        $this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( ' Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'subtitle_padding',
			[
				'label' 		=> __( ' Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Desc Style---------------------------------------//

		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Description Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-text' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Description Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .hero-text',
			]
        );
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Description Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Description Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();
		//---------------------------------------tag Style---------------------------------------//

		$this->start_controls_section(
			'tag_style',
			[
				'label' 	=> __( 'Tag Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'banner_style!' => '4',
				]
			]
		);
		$this->add_control(
			'tag_color',
			[
				'label' 		=> __( 'Tag Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-meta span' => '--white-color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'tag_typography',
				'label' 	=> __( 'Tag Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .hero-meta span',
			]
        );
        $this->add_responsive_control(
			'tag_margin',
			[
				'label' 		=> __( 'Tag Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-meta span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'tag_padding',
			[
				'label' 		=> __( 'Tag Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-meta span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

		

		//---------------------------------------Button Style---------------------------------------//

		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:before, {{WRAPPER}} .th-btn:after' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Border Hover', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn:hover',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'Konta' ),
				'selector' => '{{WRAPPER}} .th-btn',
			]
		);
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['banner_style'] == '1' ){
			echo '<div class="th-hero-wrapper hero-10">';
		       	echo '<div class="hero-slider-10 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-dots="true" data-xl-dots="true" data-ml-dots="true" data-lg-dots="true" data-md-dots="true">';

		       		foreach( $settings['banners_one'] as $data ) {

			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'">';
				                    echo '<img src="'.KONTA_PLUGDIRURI . 'assets/img/hero_overlay.png" alt="overlay">';
				                echo '</div>';
				            }
			                echo '<div class="container th-container">';
			                    echo '<div class="hero-style10">';
			                        echo '<div class="hero-meta" data-ani="slideinup" data-ani-delay="0.2s">';
			                        	if(!empty($data['tag1'])){
			                                echo '<span>'.esc_html($data['tag1']).'</span>';
			                            }
			                            if(!empty($data['tag2'])){
			                                echo '<span>'.esc_html($data['tag2']).'</span>';
			                            }
			                            if(!empty($data['tag3'])){
			                                echo '<span>'.esc_html($data['tag3']).'</span>';
			                            }
			                        echo '</div>';
			                        if(!empty($data['banner_title1'])){
				                        echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.3s">'.wp_kses_post($data['banner_title1']).'</h1>';
				                    }
				                    if(!empty($data['banner_title2'])){
				                        echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.5s">'.wp_kses_post($data['banner_title2']).'</h1>';
				                    }
				                    if(!empty($data['banner_desc'])){
				                        echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['banner_desc']).'</p>';
				                    }
			                        echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
		                                if(!empty($data['button_text_1'])){
				                            echo '<a href="'.esc_url( $data['button_link_1']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text_1']).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text_2'])){
				                            echo '<a href="'.esc_url( $data['button_link_2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text_2']).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				                        }

			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }    
		       echo ' </div>';
		    echo '</div>';
		}elseif( $settings['banner_style'] == '2' ){
			echo '<div class="th-hero-wrapper hero-7" id="hero">';
		        echo '<div class="hero-slider-7 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1">';

		        	foreach( $settings['banners_two'] as $data ) {
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['banner_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'"></div>';
				            }
				            if(!empty($data['shape_img']['url'])){
				                echo '<div class="hero-img">';
				                    echo Konta_img_tag( array(
			                        	'url' => esc_url( $data['shape_img']['url'] ),
			                        ) );
				                echo '</div>';
				            }
				            if(!empty($data['shadow_text'])){
				                echo '<div class="big-text" data-ani="slideindown" data-ani-delay="0.2s">'.esc_html($data['shadow_text']).'</div>';
				            }
			                echo '<div class="container z-index-common">';
			                    echo '<div class="hero-style7">';
			                        echo '<div class="hero-meta" data-ani="slideindown" data-ani-delay="0.2s">';
			                            if(!empty($data['tag1'])){
			                                echo '<span>'.esc_html($data['tag1']).'</span>';
			                            }
			                            if(!empty($data['tag2'])){
			                                echo '<span>'.esc_html($data['tag2']).'</span>';
			                            }
			                        echo '</div>';
			                        if(!empty($data['banner_title1'])){
				                        echo '<h1 class="hero-title" data-ani="slideindown" data-ani-delay="0.3s">'.wp_kses_post($data['banner_title1']).'</h1>';
				                    }
				                    if(!empty($data['banner_title2'])){
				                        echo '<h1 class="hero-title" data-ani="slideindown" data-ani-delay="0.5s">'.wp_kses_post($data['banner_title2']).'</h1>';
				                    }
				                    if(!empty($data['banner_desc'])){
				                        echo '<p class="hero-text" data-ani="slideindown" data-ani-delay="0.6s">'.esc_html($data['banner_desc']).'</p>';
				                    }
			                        echo '<div class="btn-group" data-ani="slideindown" data-ani-delay="0.6s">';
			                        	if(!empty($data['button_text_1'])){
				                            echo '<a href="'.esc_url( $data['button_link_1']['url'] ).'" class="th-btn style5">'.esc_html($data['button_text_1']).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text_2'])){
				                            echo '<a href="'.esc_url( $data['button_link_2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text_2']).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                    if(!empty($data['video_url'])){
				                    echo '<a href="'.esc_url( $data['video_url'] ).'" class="play-btn style3 popup-video"><i class="fas fa-play"></i></a>';
				                }
			                echo '</div>';
			            echo '</div>';
			        }        
		        echo '</div>';
		        echo '<div class="icon-box">';
		            echo '<button data-slick-prev=".hero-slider-7" class="icon-btn"><i class="far fa-long-arrow-left"></i></button>';
		            echo '<button data-slick-next=".hero-slider-7" class="icon-btn"><i class="far fa-long-arrow-right"></i></button>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['banner_style'] == '3' ){
			echo '<div class="th-hero-wrapper hero-8">';
		        echo '<div class="hero-slider-8 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-adaptive-height="true">';
		            foreach( $settings['banners_three'] as $data ) {
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['shape_img']['url'])){
				                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['shape_img']['url']).'" data-overlay="overlay2" data-opacity="9"></div>';
				            }
			                echo '<div class="container">';
			                    echo '<div class="hero-style8">';
			                    if(!empty($data['heading'])){
			                        echo '<span class="hero-subtitle" data-ani="slideinleft" data-ani-delay="0.1s">'.esc_html($data['heading']).'</span>';
			                    }
			                    	if(!empty($data['banner_title1'])){
				                        echo '<h1 class="hero-title" data-ani="slideindown" data-ani-delay="0.3s">'.wp_kses_post($data['banner_title1']).'</h1>';
				                    }
				                    if(!empty($data['banner_title2'])){
				                        echo '<h1 class="hero-title" data-ani="slideindown" data-ani-delay="0.5s">'.wp_kses_post($data['banner_title2']).'</h1>';
				                    }
			                        if(!empty($data['banner_desc'])){
				                        echo '<p class="hero-text" data-ani="slideindown" data-ani-delay="0.6s">'.esc_html($data['banner_desc']).'</p>';
				                    }
			                        echo '<div class="btn-group" data-ani="slideinleft" data-ani-delay="0.7s">';
			                        	if(!empty($data['button_text_1'])){
				                            echo '<a href="'.esc_url( $data['button_link_1']['url'] ).'" class="th-btn">'.esc_html($data['button_text_1']).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text_2'])){
				                            echo '<a href="'.esc_url( $data['button_link_2']['url'] ).'" class="th-btn style5">'.esc_html($data['button_text_2']).'<i class="fas fa-long-arrow-right ms-2"></i></a>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			                if(!empty($data['banner_img'])){
				                echo '<div class="hero-img">';
				                	echo Konta_img_tag( array(
			                        	'url' => esc_url( $data['banner_img']['url'] ),
			                        ) );
				                    echo '<button data-slick-next=".hero-slider-8" class="icon-btn"><i class="far fa-long-arrow-right"></i></button>';
				                echo '</div>';
				            }
			            echo '</div>';
			        }
		        echo '</div>';
		   echo ' </div>';
		}else{
		?>
		 <div class="th-hero-wrapper hero-4">
	        <div class="th-hero-slide">
	            <div class="th-hero-bg" data-bg-src="<?php echo esc_url($settings['banner_img']['url']); ?>">
	                <?php echo Konta_img_tag( array(
                    	'url' => esc_url( $settings['banner_img3']['url'] ),
                    ) ); ?>
	            </div>
	            <div class="container z-index-common">
	                <div class="hero-style4">
	                	<?php if(!empty($settings['heading'])): ?>
	                    	<span class="hero-subtitle"><?php echo wp_kses_post($settings['heading']); ?></span>
	                	<?php endif; ?>
	                	<?php if(!empty($settings['banner_title1'])): ?>
	                    	<h1 class="hero-title"><?php echo wp_kses_post($settings['banner_title1']); ?></h1>
	                    <?php endif; ?>
	                    <?php if(!empty($settings['banner_desc'])): ?>
	                    	<p class="hero-text"><?php echo wp_kses_post($settings['banner_desc']); ?></p>
	                    <?php endif; ?>
	                    <div class="btn-group">
	                    	<?php if(!empty($settings['button_text_1'])): ?>
	                        <a href="<?php echo esc_url( $settings['button_link_1']['url'] ) ?>" class="th-btn style3 style-new"><?php echo esc_html($settings['button_text_1']); ?><i class="fas fa-long-arrow-right ms-2"></i></a>
	                        <?php endif; ?>
	                        <?php if(!empty($settings['button_link_2']['url'])): ?>
	                        <a href="<?php echo esc_url( $settings['button_link_2']['url'] ) ?>" class="call-btn style-video popup-video">
	                            <div class="play-btn style2"><i class="fas fa-play"></i></div>
	                            <div class="btn-content">
	                                <p class="btn-title"><?php echo esc_html($settings['button_text_2']); ?></p>
	                                <span class="btn-text"><?php echo esc_html($settings['button_text_22']); ?></span>
	                            </div>
	                        </a>
	                        <?php endif; ?>
	                    </div>
	                </div>
	            </div>
	        </div>
	        <div class="hero-img">
	            <?php echo Konta_img_tag( array(
                    	'url' => esc_url( $settings['banner_img2']['url'] ),
                    ) ); ?>
	        </div>
	    </div>
		<?php
		}
	}

}