<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Konta_Banner2_2 extends Widget_Base {

	public function get_name() {
		return 'drillerbanner2';
	}

	public function get_title() {
		return __( 'Banner New', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'banner_style',
			[
				'label' 		=> __( 'Konta Banner Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
					'4' 		=> __( 'Style Four', 'Konta' ),
				],
			]
		);

		/*-----------------------------------------style one ------------------------------------*/
		$repeater = new Repeater();
		$repeater->add_control(
			'banner_heading', [
				'label' 		=> __( 'Heading', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'GET DISCOUNT 25% DURING COVID - 19r' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Classical Education' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'For The Future...' , 'Konta' ),
				'label_block' 	=> true,
			]
        );

        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Grursus mal suada faci lisis Lorem ipsum dolarorit more that ametion fadolorit to the consectetur elit.' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$repeater->add_control(
			'button_text2',
			[
				'label' 	=> esc_html__( 'Button Text 2', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link2',
			[
				'label' 		=> esc_html__( 'Button url 2', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $repeater->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video url', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(

			'banner_1',
			[
				'label' 		=> __( 'Banner Slider', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_heading' => __( 'Add Social Icon','Konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_heading.value }}}',
				'condition'	=> ['banner_style' => ['1']]
			]
		);

		/*-----------------------------------------style two ------------------------------------*/
		$repeater = new Repeater();
		$repeater->add_control(
			'banner_heading', [
				'label' 		=> __( 'Heading', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 3,
				'default' 		=> __( 'GET DISCOUNT 25% DURING COVID - 19r' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title 1', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Classical Education' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'For The Future...' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Grursus mal suada faci lisis Lorem ipsum dolarorit more that ametion fadolorit to the consectetur elit.' , 'Konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'button_text2',
			[
				'label' 	=> esc_html__( 'Button Text 2', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'Konta' ),
			]
        );

        $repeater->add_control(
			'button_link2',
			[
				'label' 		=> esc_html__( 'Button Link 2', 'Konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'Konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		
		$repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(

			'banner_2',
			[
				'label' 		=> __( 'Banner Slider', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_heading' => __( 'Add Social Icon','Konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_heading.value }}}',
				'condition'	=> ['banner_style' => ['2', '3']]
			]
		);

		$repeater4 = new Repeater();

        $repeater4->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater4->add_control(
            'shape_img',
            [
                'label'     => __( 'Shape Image', 'konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater4->add_control(
			'heading', [
				'label' 		=> __( 'Heading', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'KONTA' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater4->add_control(
			'banner_title1', [
				'label' 		=> __( 'Title 1', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'WORLD BEST <span class="bg-theme">INDUSTRY</span>' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater4->add_control(
			'banner_title2', [
				'label' 		=> __( 'Title 2', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SOLUTIONS HERE' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater4->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Enthusiastically provide access to client-focused testing procedures through cooperative niches. Intrinsicly promote compelling methods of empowerment before.' , 'konta' ),
				'label_block' 	=> true,
			]
        );
        $repeater4->add_control(
			'button_text_1',
			[
				'label' 	=> esc_html__( 'First Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater4->add_control(
			'button_link_1',
			[
				'label' 		=> esc_html__( 'First Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater4->add_control(
			'button_text_2',
			[
				'label' 	=> esc_html__( 'Second Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Latest Projects', 'konta' ),
			]
        );

        $repeater4->add_control(
			'button_link_2',
			[
				'label' 		=> esc_html__( 'Second Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
	
		$this->add_control(
			'banners_4',
			[
				'label' 		=> __( 'Banners', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater4->get_controls(),
				'default' 		=> [
					[
						'banner_title' 		=> __( 'Banner Two', 'konta' ),
					],
				],
				'title_field' 	=> '{{{ banner_title }}}',
				'condition'	=> ['banner_style' => '4']
			]
		);

		
        $this->end_controls_section();

        //---------------------------------------Tags Style---------------------------------------//

		$this->start_controls_section(
			'tags_style',
			[
				'label' 	=> __( 'Tags Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['banner_style' => '4']
			]
		);
		$this->add_control(
			'tags_color',
			[
				'label' 		=> __( 'Tags Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-style8 .hero-meta span' => 'color: {{VALUE}}',
                ],
			]
        );		
       
        $this->add_control(
			'tags_hover_color',
			[
				'label' 		=> __( 'Tags Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-style8 .hero-meta span:hover' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'tags_separator_color',
			[
				'label' 		=> __( 'Tags Separator Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-style8 .hero-meta span:after' => '--white-color: {{VALUE}}',
                ],
			]
        ); 
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'tags_typography',
				'label' 	=> __( 'Tags Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .hero-style8 .hero-meta span',
			]
        );
        $this->add_responsive_control(
			'tags_margin',
			[
				'label' 		=> __( 'Tags Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-style8 .hero-meta span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'tags_padding',
			[
				'label' 		=> __( 'Tags Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-style8 .hero-meta span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

        //---------------------------------------Subtitle Style---------------------------------------//

		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['banner_style!' => '4']
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Subtitle Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-subtitle, {{WRAPPER}} .hero-meta span' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'subtitle_typography',
				'label' 	=> __( 'Subtitle Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .hero-subtitle, {{WRAPPER}} .hero-name',
			]
        );
        $this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( 'Subtitle Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-subtitle, {{WRAPPER}} .hero-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'subtitle_padding',
			[
				'label' 		=> __( 'Subtitle Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-subtitle, {{WRAPPER}} .hero-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

        //---------------------------------------Title Style---------------------------------------//

		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h1' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} h1',
			]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Title Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Title Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//

		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				// 'condition'	=> ['banner_style!' => '2']
			]
		);
		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Description Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .hero-text' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Description Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .hero-text',
			]
        );
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Description Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Description Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .hero-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();


		//---------------------------------------Button Style 1---------------------------------------//

		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3:hover, {{WRAPPER}} .th-btn.btn1:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3:hover:before, {{WRAPPER}} .th-btn.style3:hover:after' => '--white-color:{{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1',
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1',
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'Konta' ),
				'selector' => '{{WRAPPER}} .th-btn.style3, {{WRAPPER}} .th-btn.btn1',
			]
		);
        $this->end_controls_section();

        //---------------------------------------Button Style 2---------------------------------------//

		$this->start_controls_section(
			'button_style_section2',
			[
				'label' 	=> __( 'Button 2 Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['banner_style' => ['1', '3']]
			]
        );

        $this->add_control(
			'button_color2',
			[
				'label' 		=> __( 'Button Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_control(
			'button_color_hover2',
			[
				'label' 		=> __( 'Button Color Hover', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style6:hover,  {{WRAPPER}}  .th-btn.style4' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_control(
			'button_bg_color2',
			[
				'label' 		=> __( 'Button Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4' => 'background-color:{{VALUE}} !important',
					'{{WRAPPER}}  .th-btn.style4' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color2',
			[
				'label' 		=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style4:hover:before, {{WRAPPER}} .th-btn.style4:hover:after, {{WRAPPER}} .th-btn.style6:hover:before, {{WRAPPER}} .th-btn.style6:hover:after' => 'background-color:{{VALUE}} !important',
                ],
			]
        );
      $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography2',
				'label' 	=> __( 'Button Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4',
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border2',
				'label' 	=> __( 'Border', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4',
			]
		);

        $this->add_responsive_control(
			'button_margin2',
			[
				'label' 		=> __( 'Button Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding2',
			[
				'label' 		=> __( 'Button Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius2',
			[
				'label' 		=> __( 'Button Border Radius', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style6,  {{WRAPPER}}  .th-btn.style4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

                //---------------------------------------Button Style 2---------------------------------------//

		$this->start_controls_section(
			'button_style_section3',
			[
				'label' 	=> __( 'Button 2 Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['banner_style' => ['2']]
			]
        );

        $this->add_control(
			'button_color3',
			[
				'label' 		=> __( 'Button Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_control(
			'button_color_hover3',
			[
				'label' 		=> __( 'Button Color Hover', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2:hover' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_control(
			'button_bg_color3',
			[
				'label' 		=> __( 'Button Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2' => 'background-color:{{VALUE}} !important',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color3',
			[
				'label' 		=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2:hover:before, .th-btn.style2:hover:after' => '--white-color:{{VALUE}} !important',
                ],
			]
        );
      $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography3',
				'label' 	=> __( 'Button Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn.style2',
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border3',
				'label' 	=> __( 'Border', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn.style2',
			]
		);

        $this->add_responsive_control(
			'button_margin3',
			[
				'label' 		=> __( 'Button Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding3',
			[
				'label' 		=> __( 'Button Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius3',
			[
				'label' 		=> __( 'Button Border Radius', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn.style2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

     
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['banner_style'] == '1' ){

			echo '<div class="th-hero-wrapper hero-11">';
		        echo '<div class="hero-slider-11 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1">';

		        	foreach( $settings['banner_1'] as $data ){
			            echo '<div class="th-hero-slide">';
			                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'">';
			                    echo '<img src="'.KONTA_PLUGDIRURI . 'assets/img/hero_overlay_5.png" alt="Hero Image">';
			                echo '</div>';
			                echo '<div class="container z-index-common">';
			                    echo '<div class="hero-style11">';
			                    	if(!empty($data['banner_heading'])){
				                        echo '<span class="hero-subtitle" data-ani="slideinleft" data-ani-delay="0.1s">'.esc_html($data['banner_heading']).'</span>';
				                    }
				                    if(!empty($data['banner_title1'])){
				                        echo '<h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.3s">'.esc_html($data['banner_title1']).'</h1>';
				                    }
				                    if(!empty($data['banner_title2'])){
				                        echo '<h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.5s">'.esc_html($data['banner_title2']).'</h1>';
				                    }
				                    if(!empty($data['banner_desc'])){
				                        echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.6s">'.esc_html($data['banner_desc']).'</p>';
				                    }
			                        echo '<div class="btn-group style2" data-ani="slideinleft" data-ani-delay="0.7s">';
			                        	if(!empty($data['button_text'])){
				                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text2'])){
				                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style4">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                    echo ' <a href="'.esc_url( $data['video_link']['url'] ).'" class="play-btn style3 popup-video"><i class="fas fa-play"></i></a>';
			                echo '</div>';
			            echo '</div>';
			        }       
		        echo '</div>';
		        echo '<div class="hero-shape"></div>';
		    echo '</div>';
		}elseif( $settings['banner_style'] == '2' ){
			echo '<div class="th-hero-wrapper hero-12">';
		        echo '<div class="hero-slider-12 th-carousel" id="heroSlide12" data-slide-show="1" data-md-slide-show="1" data-fade="true">';
		        	foreach( $settings['banner_2'] as $data ){
			            echo '<div class="th-hero-slide">';
			                echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'">';
			                    echo '<img src="'.KONTA_PLUGDIRURI . 'assets/img/hero_overlay_6.png" alt="Hero Image">';
			                echo '</div>';
			                echo '<div class="container">';
			                    echo '<div class="hero-style12">';

			                    	if(!empty($data['banner_heading'])){
				                        echo '<div class="hero-meta" data-ani="slideindown" data-ani-delay="0.5s">'.wp_kses_post($data['banner_heading']).'</div>';
				                    }
				                    if(!empty($data['banner_title1'])){
				                        echo '<h1 class="hero-title text-white" data-ani="slideindown" data-ani-delay="0.4s">'.esc_html($data['banner_title1']).'</h1>';
				                    }
				                    if(!empty($data['banner_title2'])){
				                        echo '<h1 class="hero-title text-white" data-ani="slideindown" data-ani-delay="0.1s">'.esc_html($data['banner_title2']).'</h1>';
				                    }
			                        if(!empty($data['banner_desc'])){
				                        echo '<p class="hero-text text-white" data-ani="slideinup" data-ani-delay="0.1s">';
				                        	echo esc_html( $data['banner_desc']) ;
				                        echo '</p>';
				                    }
			                        echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.5s">';
			                        	if(!empty($data['button_text'])){
				                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text2'])){
				                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        }   
		        echo '</div>';
		        echo '<div class="icon-box">';
		            echo '<button data-slick-prev="#heroSlide6" class="slick-arrow default"><i class="far fa-chevron-left"></i></button>';
		            echo '<button data-slick-next="#heroSlide6" class="slick-arrow default"><i class="far fa-chevron-right"></i></button>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['banner_style'] == '3' ){

			echo '<div class="th-hero-wrapper hero-slider-13 th-carousel" id="hero" data-slide-show="1" data-md-slide-show="1" data-fade="true" data-dots="true" data-xl-dots="true" data-ml-dots="true" data-lg-dots="true">';

				foreach( $settings['banner_2'] as $data ){
			        echo '<div class="th-hero-slide">';
			            echo '<div class="th-hero-bg" data-bg-src="'.esc_url($data['banner_img']['url']).'">';
			                echo '<img src="'.KONTA_PLUGDIRURI . 'assets/img/hero_overlay_7.png" alt="Hero Image">';
			            echo '</div>';
			            echo '<div class="container">';
			                echo '<div class="hero-style13">';
			                	if(!empty($data['banner_heading'])){
			                		echo '<div class="hero-meta text-white" data-ani="slideindown" data-ani-delay="0.6s">'.wp_kses_post($data['banner_heading']).'</div>';
			                    }
			                    if(!empty($data['banner_title1'])){
			                    	echo '<h1 class="hero-title text-white" data-ani="slideindown" data-ani-delay="0.4s">'.wp_kses_post($data['banner_title1']).'</h1>';
			                    }
			                    if(!empty($data['banner_title2'])){
			                    	echo '<h1 class="hero-title text-white" data-ani="slideindown" data-ani-delay="0.1s">'.wp_kses_post($data['banner_title2']).'</h1>';
			                    }
			                    if(!empty($data['banner_desc'])){
			                    	echo '<p class="hero-text text-white" data-ani="slideinup" data-ani-delay="0.1s">'.esc_html($data['banner_desc']).'</p>';
			                    }
			                    echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.5s">';
			                    	if(!empty($data['button_text'])){
			                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                        }
			                        if(!empty($data['button_text2'])){
			                            echo '<a href="'.esc_url( $data['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                        }
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    }
		    echo '</div>';

		}else{
			echo '<div class="th-hero-wrapper hero-9">';
		        echo '<div class="hero-slider-9 th-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-dots="true">';

		        	foreach( $settings['banners_4'] as $data ){
			            echo '<div class="th-hero-slide">';
			            	if(!empty($data['shape_img']['url'])){
				                echo '<div class="th-hero-bg" data-overlay="title" data-opacity="9" data-bg-src="'.esc_url( $data['shape_img']['url'] ).'">';
				                echo '</div>';
				            }

			                echo '<div class="container z-index-common">';
			                    echo '<div class="hero-style9">';
			                    	if(!empty($data['heading'])){
				                        echo '<span class="hero-subtitle text-theme" data-ani="slideinleft" data-ani-delay="0.1s"><img src="'.KONTA_PLUGDIRURI . 'assets/img/hero-subtitle-icon8-1.svg" alt="Hero Image"> '.esc_html($data['heading']).'</span>';
				                    }
				                    if(!empty($data['banner_title1'])){
				                        echo '<h1 class="hero-title text-white" data-ani="slideinleft" data-ani-delay="0.3s">'.wp_kses_post($data['banner_title1']).'</h1>';
				                    }
				                    if(!empty($data['banner_title2'])){
				                        echo '<h1 class="hero-title text-white" data-ani="slideinleft" data-ani-delay="0.5s">'.wp_kses_post($data['banner_title2']).'<span class="text-theme">!</span></h1>';
				                    }
				                    if(!empty($data['banner_desc'])){
				                        echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.6s">'.esc_html($data['banner_desc']).'</p>';
				                    }
			                        echo '<div class="btn-group style2" data-ani="slideinleft" data-ani-delay="0.7s">';

			                        	if(!empty($data['button_text_1'])){
				                            echo '<a href="'.esc_url( $data['button_link_1']['url'] ).'" class="th-btn style3">'.esc_html($data['button_text_1']).' <i class="fas fa-arrow-right ms-2"></i></a>';
				                        }
				                        if(!empty($data['button_text_2'])){
				                            echo '<a href="'.esc_url( $data['button_link_2']['url'] ).'" class="th-btn style7">'.esc_html($data['button_text_2']).'<i class="fas fa-arrow-right ms-2"></i></a>';
				                        }

			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			                if(!empty($data['banner_img'])){
				                echo '<div class="hero-img d-xl-block d-none">';
				                    echo konta_img_tag( array(
			                        	'url' => esc_url( $data['banner_img']['url'] ),
			                        ) );
				                echo '</div>';
				            }

			            echo '</div>';
			        } 
		        echo '</div>';
		    echo '</div>';
		}


	}
}