<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Client Logo Widget .
 *
 */
class Konta_Client_Logo_2 extends Widget_Base {

	public function get_name() {
		return 'drillerclientlogo';
	}

	public function get_title() {
		return __( 'Client Logo v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'client_logo_section',
			[
				'label' 	=> __( 'Client Logo', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'client_logo',
			[
				'label' 	=> __( 'Client Logo', 'Konta' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'logos',
			[
				'label' 		=> __( 'Client Logos', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();



	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<!-----------------------Start partner Logo Slider----------------------->';
	        echo '<div class="row th-carousel" id="brandSlide" data-slide-show="6" data-lg-slide-show="5" data-md-slide-show="4" data-sm-slide-show="3" data-xs-slide-show="3">';
	        	foreach( $settings['logos'] as $singlelogo ) {
	        		echo '<div class="col-auto">';
	                    echo '<div class="text-center">';
	                        echo Konta_img_tag( array(
	                            'url'   => esc_url( $singlelogo['client_logo']['url'] ),
	                        ) );
	                    echo '</div>';
	                echo '</div>';
		        } 
	        echo '</div>';
        echo '<!-----------------------End partner Logo Slider----------------------->';
	}
}